/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act.rightbanner.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.component.act.rightbanner.ui.AttachSvgaView;
import com.yy.hiyo.channel.component.act.rightbanner.ui.BaseRoomActivityView;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;

public class ActSvgaView
extends BaseRoomActivityView {
    private AttachSvgaView mSvgaView;
    private RoomActivityAction mData;
    private String mLastSvgaUrl;

    public ActSvgaView(Context context) {
        super(context);
        this.mSvgaView = new AttachSvgaView(context);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.mSvgaView, lp);
    }

    @Override
    public void setData(RoomActivityAction data2) {
        if (data2 != null && data2.pictureType == ActivityAction.PictureType.SVGA) {
            this.mData = data2;
            this.mSvgaView.setVisibility(0);
            if (!StringUtils.equal((String)this.mLastSvgaUrl, (String)data2.iconUrl)) {
                this.mLastSvgaUrl = data2.iconUrl;
                String thumb = StringUtils.isNotEmpty((String)data2.iconUrl) && !data2.iconUrl.endsWith("svga") ? YYImageUtils.getThumbnailPostfixPx((int)(data2.width / 2), (int)(data2.height / 2), (boolean)true) : "";
                SvgaLoader.load((SVGAImageView)this.mSvgaView, (String)(data2.iconUrl + thumb), (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (ActSvgaView.this.isAttachToWindow()) {
                            ActSvgaView.this.mSvgaView.startAnimation();
                        }
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)"ActSvgaView", (Throwable)e);
                        ActSvgaView.this.mLastSvgaUrl = null;
                    }
                });
            }
            if (data2.isUpdateSize) {
                this.setViewSize((View)this.mSvgaView, data2);
            }
        }
    }

    @Override
    public RoomActivityAction getData() {
        return this.mData;
    }

    @Override
    public View getView() {
        return this.mSvgaView;
    }
}

