/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act;

import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.Callback;
import com.yy.appbase.reddot.IRedDot;
import com.yy.appbase.reddot.RedDot;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.component.act.ActivityMvp;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.GiftPanelAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import net.ihago.money.api.appconfigcenter.PluginSubType;
import org.jetbrains.annotations.NotNull;

public class ActivityPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements ActivityMvp.IPresenter {
    private static final String TAG = "FTVoiceRoom activity ActivityPresenter";
    private MutableLiveData<GiftPanelAction> mGiftPanelActionData;
    private MutableLiveData<Boolean> mGiftRedDotVisible;
    private ActivityTagInfo mRoomTag;
    private IPluginService.IPluginDataChangedCallBack mPluginChangedListener = new IPluginService.IPluginDataChangedCallBack(){

        public void onVideoModeChanged(String channelId, boolean isVideoMode) {
            ActivityPresenter.this.requestActivities(true);
        }
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.mGiftPanelActionData = new SafeLiveData();
        this.mGiftRedDotVisible = new SafeLiveData();
        this.requestActivities(true);
    }

    private void requestActivities(boolean force) {
        ActivityTagInfo tag;
        MLog.info((Object)TAG, (String)"requestActivities isGiftIconClicked %b", (Object[])new Object[]{this.isGiftIconClicked()});
        this.mRoomTag = tag = this.getRoomTag();
        ((IActivityService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IActivityService.class)).fetchGiftActivities(this.getChannelId(), tag, (Callback)WeakCallback.of((IDestroyable)this, data2 -> {
            MLog.info((Object)TAG, (String)"fetchGiftActivities response %s, isGiftIconClicked %b", (Object[])new Object[]{data2, this.isGiftIconClicked()});
            this.mGiftPanelActionData.setValue(data2);
            this.mGiftRedDotVisible.setValue((Object)(data2 != null && !this.isGiftIconClicked() ? 1 : 0));
        }), force);
        if (this.isGiftIconClicked()) {
            this.mGiftRedDotVisible.setValue((Object)false);
        }
    }

    @NotNull
    private ActivityTagInfo getRoomTag() {
        ChannelTagItem tag = this.getChannelDetailInfo().baseInfo.tag.getFirstTag();
        ActivityTagInfo info = new ActivityTagInfo("" + tag.getTagId(), tag.getName());
        info.setPluginType(this.getChannel().getPluginService().getCurPluginData().mode);
        info.setPluginSubType(this.getChannel().getPluginService().getCurPluginData().isVideoMode() ? PluginSubType.PluginSubTypeVideo.getValue() : PluginSubType.PluginSubTypeAudio.getValue());
        info.setChannelRole(this.getChannel().getRoleService().getMyRoleCache());
        return info;
    }

    @Override
    public LiveData<GiftPanelAction> getGiftPanelAction() {
        return this.mGiftPanelActionData;
    }

    @Override
    public LiveData<Boolean> getGiftRedDotVisible() {
        return this.mGiftRedDotVisible;
    }

    @Override
    public void onGiftIconClick() {
        RoomSetting.getPreference().edit().putBoolean("first_charge", true).apply();
        this.mGiftRedDotVisible.setValue((Object)false);
    }

    @Override
    public boolean isGiftIconClicked() {
        return RoomSetting.getPreference().getBoolean("first_charge", false);
    }

    @Override
    public void onActivityClicked(ActivityAction data2) {
        MLog.info((Object)TAG, (String)"onActivityClicked %s", (Object[])new Object[]{data2});
        RoomSetting.getPreference().edit().putLong("room_activity_click_at" + data2.id, System.currentTimeMillis()).apply();
        if (data2 instanceof RoomActivityAction) {
            // empty if block
        }
        RoomTrack.INSTANCE.roomRightBottomActClick(this.getChannelId(), data2.id, data2.linkUrl);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach && ChannelDefine.isRadioMode((int)this.getChannel().getPluginService().getCurPluginData().mode)) {
            this.getChannel().getPluginService().addPluginDataListener(this.mPluginChangedListener);
        }
        RedDot redDot = RedDot.obtain((boolean)false);
        this.getGiftRedDotVisible().observe((LifecycleOwner)((IChannelPageContext)this.getMvpContext()).getLifecycleOwner(), arg_0 -> ((RedDot)redDot).setVisible(arg_0));
        ((BottomPresenter)this.getPresenter(BottomPresenter.class)).addGiftRedDot((IRedDot)redDot);
    }

    public void onDestroy() {
        super.onDestroy();
        ((IActivityService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IActivityService.class)).clearAllRoomActivities();
        this.getChannel().getPluginService().removePluginDataListener(this.mPluginChangedListener);
    }
}

