/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.act.ActivityBannerActionAdapter;
import com.yy.hiyo.channel.component.act.rightbanner.RightBannerActivityMvp;
import com.yy.hiyo.channel.component.act.rightbanner.ui.ActEmbedWebView;
import com.yy.hiyo.channel.component.act.rightbanner.ui.BaseRoomActivityView;
import com.yy.hiyo.channel.component.base.ui.banner.ExtendedBanner;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityActionList;
import java.util.ArrayList;
import java.util.Collection;

public class ActivityContainer
extends YYConstraintLayout
implements RightBannerActivityMvp.IView,
ICustomView,
View.OnTouchListener {
    private static final String TAG = "ActivityContainer";
    private static final int BANNER_DELAY_TIME = 5000;
    private YYConstraintLayout mRootLayout;
    private ExtendedBanner mBanner;
    private RightBannerActivityMvp.IPresenter mPresenter;
    private int mBannerWidth = 0;
    private int mBannerHeight = 0;
    private static final int MAX_ACT_WIDTH = ResourceUtils.getDimen((int)R.dimen.room_act_max_width);
    private static final int MAX_ACT_CONTAINER_HEIGHT = ResourceUtils.getDimen((int)R.dimen.room_act_container_max_height);
    private float mPreDownY = 0.0f;
    private float mPreDownX = 0.0f;
    private float mTouchY = 0.0f;
    private float mTouchX = 0.0f;
    private boolean mShowBannerFlag = false;
    private int height = 0;
    private ITouchEventListener mTouchEventListener;
    private SimpleLifeCycleOwner lifecycleOwner = new SimpleLifeCycleOwner("ActivityContainer");
    private int mLastY;
    private int mParentHeight;
    private ActivityBannerActionAdapter mBannerAdapter;

    public ActivityContainer(Context context) {
        super(context);
        this.createView(null);
    }

    public ActivityContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public ActivityContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView(attrs);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mPreDownY = ev.getY();
            this.mPreDownX = ev.getX();
            this.mLastY = (int)ev.getRawY();
        } else {
            if (ev.getAction() == 2) {
                this.mTouchY = ev.getY();
                this.mTouchX = ev.getX();
                if (this.mPreDownY - this.mTouchY > 50.0f) {
                    if (this.mTouchEventListener != null) {
                        this.mTouchEventListener.onMoveUp(this.mPreDownY - this.mTouchY);
                    }
                } else if (this.mTouchY - this.mPreDownY > 50.0f && this.mTouchEventListener != null) {
                    this.mTouchEventListener.onMoveDown(this.mPreDownY - this.mTouchY);
                }
                if (Math.abs(this.mTouchY - this.mPreDownY) < 5.0f || Math.abs(this.mTouchX - this.mPreDownX) - Math.abs(this.mTouchY - this.mPreDownY) > 0.0f) {
                    return super.onInterceptTouchEvent(ev);
                }
                return true;
            }
            if (ev.getAction() == 1) {
                this.mTouchY = ev.getY();
                if (this.mTouchEventListener != null) {
                    this.mTouchEventListener.onMoveStop(this.mPreDownY, this.mTouchY);
                }
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.onInterceptTouchEvent(ev);
    }

    public void setPresenter(RightBannerActivityMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        this.mBannerAdapter = new ActivityBannerActionAdapter(presenter);
        if (this.mBanner != null) {
            this.mBanner.setActionAdapter(this.mBannerAdapter);
        }
        presenter.getShowData().observe((LifecycleOwner)this.lifecycleOwner, (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isShow) {
                if (isShow != null) {
                    MLog.info((Object)ActivityContainer.TAG, (String)"onChanged %b", (Object[])new Object[]{isShow});
                    if (ActivityContainer.this.mShowBannerFlag) {
                        ActivityContainer.this.setVisibility(Boolean.TRUE.equals(isShow) ? 0 : 8);
                    }
                }
            }
        });
        presenter.getRoomAction().observe((LifecycleOwner)this.lifecycleOwner, (Observer)new Observer<RoomActivityActionList>(){

            public void onChanged(@Nullable RoomActivityActionList roomActivityActionList) {
                if (roomActivityActionList != null && !FP.empty((Collection)roomActivityActionList.list)) {
                    ArrayList actList = new ArrayList(roomActivityActionList.list);
                    MLog.info((Object)ActivityContainer.TAG, (String)"onChanged size=%s", (Object[])new Object[]{actList.size()});
                    int maxDimension = 0;
                    for (int i = 0; i < actList.size(); ++i) {
                        RoomActivityAction activityAction = (RoomActivityAction)actList.get(i);
                        if (activityAction == null) continue;
                        ActivityContainer.this.checkBannerSize(activityAction.width, activityAction.height);
                        int dimensionRatio = 0;
                        if (activityAction.height > 0 && activityAction.width > 0) {
                            dimensionRatio = activityAction.height * 100 / activityAction.width;
                        }
                        if (maxDimension >= dimensionRatio) continue;
                        maxDimension = dimensionRatio;
                    }
                    ActivityContainer.this.updateContainerHeight(maxDimension);
                    ActivityContainer.this.mBanner.setVisibility(0);
                    ActivityContainer.this.mShowBannerFlag = true;
                    if (ActivityContainer.this.getMeasuredHeight() > 0 && ActivityContainer.this.getMeasuredHeight() > 0) {
                        ActivityContainer.this.onSizeChanged(ActivityContainer.this.getMeasuredHeight(), ActivityContainer.this.getMeasuredHeight(), 0, 0);
                    }
                } else {
                    ActivityContainer.this.mBanner.setVisibility(8);
                    ActivityContainer.this.mShowBannerFlag = false;
                }
                ActivityContainer.this.mBannerAdapter.updateData(roomActivityActionList);
            }
        });
    }

    private void updateContainerHeight(int maxDimension) {
        MLog.info((Object)TAG, (String)"updateContainerHeight maxHeight %s", (Object[])new Object[]{maxDimension});
        FrameLayout.LayoutParams param2 = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (this.height == maxDimension || param2 == null) {
            return;
        }
        param2.height = maxDimension * DpToPxDef.RESOLUTION_80_DP / 100;
        this.height = maxDimension;
        this.setLayoutParams((ViewGroup.LayoutParams)param2);
    }

    public void createView(@Nullable AttributeSet attrs) {
        ActivityContainer.inflate((Context)this.getContext(), (int)R.layout.room_activity_container_channel, (ViewGroup)this);
        this.mRootLayout = this;
        this.mRootLayout.setOnTouchListener((View.OnTouchListener)this);
        this.mBanner = (ExtendedBanner)this.findViewById(R.id.voice_banner);
        this.mBanner.setDelayTime(5000);
        this.mBanner.setIndicatorGravity(6);
        this.mBanner.isAutoPlay(true);
        this.mBanner.setVisibility(8);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBannerAdapter != null) {
            this.mBannerAdapter.destroy();
        }
        this.lifecycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.lifecycleOwner.onEvent(Lifecycle.Event.ON_START);
    }

    public void onResume() {
        BaseRoomActivityView activityView;
        MLog.debug((Object)TAG, (String)"onResume %s", (Object[])new Object[]{this});
        this.lifecycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
        this.mBanner.startAutoPlay();
        if (this.mBannerAdapter != null && (activityView = this.mBannerAdapter.getCurrentView()) instanceof ActEmbedWebView) {
            ((ActEmbedWebView)activityView).onResume();
        }
    }

    public void onPause() {
        BaseRoomActivityView activityView;
        MLog.debug((Object)TAG, (String)"onStop %s", (Object[])new Object[]{this});
        this.lifecycleOwner.onEvent(Lifecycle.Event.ON_PAUSE);
        this.mBanner.stopAutoPlay();
        if (this.mBannerAdapter != null && (activityView = this.mBannerAdapter.getCurrentView()) instanceof ActEmbedWebView) {
            ((ActEmbedWebView)activityView).onPause();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup mViewGroup = (ViewGroup)this.getParent();
        if (null != mViewGroup) {
            this.mParentHeight = mViewGroup.getHeight();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mPresenter.onLocationChange(this.getContainerLocation());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0 && this.mBannerWidth > 0 && this.mBannerHeight > 0) {
            this.setBannerSize(w, h);
        }
    }

    public int[] getContainerLocation() {
        int[] location = new int[2];
        this.getLocationInWindow(location);
        ScreenWrapperUtils.INSTANCE.paraseLocationInWindow(location);
        return location;
    }

    private void setBannerSize(int width, int height) {
        if (this.mBanner == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"setBannerSize before width=%d, height=%d, mBannerWidth=%d, mBannerHeight=%d", (Object[])new Object[]{width, height, this.mBannerWidth, this.mBannerHeight});
        height = this.getContainerHeight(height);
        width = this.getContainerWidth(width);
        boolean sizeChanged = false;
        ViewGroup.LayoutParams lp = this.mBanner.getLayoutParams();
        if (lp.width != width) {
            lp.width = width;
            sizeChanged = true;
        }
        if (lp.height != height) {
            lp.height = height;
            sizeChanged = true;
        }
        if (sizeChanged) {
            MLog.info((Object)TAG, (String)"setBannerSize width=%d, height=%d", (Object[])new Object[]{width, height});
            this.mBanner.setLayoutParams(lp);
            if (this.mBannerAdapter != null) {
                this.mBannerAdapter.updateSize();
            }
        }
    }

    private void checkBannerSize(int width, int height) {
        if (width > this.mBannerWidth) {
            this.mBannerWidth = width;
        }
        if (height > this.mBannerHeight) {
            this.mBannerHeight = height;
        }
    }

    private int getContainerHeight(int height) {
        int h = ResolutionUtils.dip2Px((float)(this.mBannerHeight / 2 + 10));
        int max = Math.min(h, MAX_ACT_CONTAINER_HEIGHT);
        return height < max ? height : max;
    }

    private int getContainerWidth(int width) {
        int h = ResolutionUtils.dip2Px((float)(this.mBannerWidth / 2 + 10));
        int max = Math.min(h, MAX_ACT_WIDTH);
        return width < max ? width : max;
    }

    private float getBannerRatio() {
        return 1.0f * (float)MAX_ACT_WIDTH / (float)MAX_ACT_CONTAINER_HEIGHT;
    }

    public void setTouchEventListener(ITouchEventListener listener2) {
        this.mTouchEventListener = listener2;
    }

    public void removeTouchEventListener() {
        this.mTouchEventListener = null;
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                break;
            }
            case 2: {
                int maxTop;
                int dy = (int)event.getRawY() - this.mLastY;
                int top = view.getTop() + dy;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)"ACTION_MOVE dy=%d", (Object[])new Object[]{dy});
                }
                if (top > (maxTop = this.mParentHeight - this.getHeight())) {
                    top = maxTop;
                }
                if (top < 0) {
                    top = 0;
                }
                this.setLocation(top);
                this.mLastY = (int)event.getRawY();
                break;
            }
            case 1: {
                if (!RuntimeContext.sIsDebuggable) break;
                MLog.info((Object)TAG, (String)"ACTION_UP", (Object[])new Object[0]);
                break;
            }
        }
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        super.dispatchTouchEvent(ev);
        return true;
    }

    public void setLocation(int top) {
        if (this.mRootLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRootLayout.getLayoutParams();
            layoutParams.topMargin = top;
            this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static interface ITouchEventListener {
        public void onMoveUp(float var1);

        public void onMoveDown(float var1);

        public void onMoveStop(float var1, float var2);
    }
}

