/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.service;

import android.app.Activity;
import androidx.annotation.Nullable;
import biz.SeatUser;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.MediaTokenInfo;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.rolepermission.IRolePermissionService;
import com.yy.hiyo.channel.base.service.IBaseRoomGameService;
import com.yy.hiyo.channel.base.service.IBottomDynaService;
import com.yy.hiyo.channel.base.service.ICalculatorService;
import com.yy.hiyo.channel.base.service.IChannelBarrageService;
import com.yy.hiyo.channel.base.service.IChannelMemberService;
import com.yy.hiyo.channel.base.service.IChannelTitleBgService;
import com.yy.hiyo.channel.base.service.IConfigService;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IFamilyService;
import com.yy.hiyo.channel.base.service.IGetCrawlerService;
import com.yy.hiyo.channel.base.service.IGroupPlayService;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.base.service.IOnlineUserSearchService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ITagService;
import com.yy.hiyo.channel.base.service.ITeamUpService;
import com.yy.hiyo.channel.base.service.IVoiceFilterService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.service.pluginservice.IChannelPluginService;
import com.yy.hiyo.channel.base.service.pluginservice.IChannelPluginServiceCreator;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import java.util.List;

public interface IChannel {
    public IMsgService getMsgService();

    public IRoleService getRoleService();

    public IDataService getDataService();

    public IRolePermissionService getPermissionService();

    public ISeatService getSeatService();

    public IMediaService getMediaService();

    public ICalculatorService getCalculatorService();

    public IFamilyService getFamilyService();

    public IChannelBarrageService getBarrageService();

    public IPluginService getPluginService();

    public IVoiceFilterService getVoiceFilterService();

    public ITagService getTagService();

    public IGetCrawlerService getCrawlerService();

    public IChannelMemberService getChannelMemberService();

    public IConfigService getConfigService();

    public IGroupPlayService getGroupPlayService();

    public ITeamUpService getTeamUpService();

    public IBaseRoomGameService getBaseRoomGameService();

    public <T extends IChannelPluginService> void registerPluginServiceCreator(Class<T> var1, IChannelPluginServiceCreator<T> var2);

    public <T extends IChannelPluginService> T getPluginService(Class<T> var1);

    public Object getNotifyDispatcher();

    public Activity getContext();

    public EnterParam getEnterParam();

    public EnterChannelData getEnterChannelData();

    public IChannelTitleBgService getChannelTitleBgService();

    public IOnlineUserSearchService getOnlineUserSearchService();

    public IBottomDynaService getDynaService();

    public void join(EnterParam var1, IJoinCallBack var2);

    public void onPreJoin(EnterParam var1);

    public void handleJoinSuccess(boolean var1, EnterParam var2, ChannelDetailInfo var3, EnterChannelData var4);

    public void leave(ILeaveCallBack var1);

    public void joinBroadcastGroup(EnterParam var1, IJoinCallBack var2);

    public void leaveBroadcastGroup(ILeaveCallBack var1);

    public void createChannel(CreateChannelParams var1, ICreateCallBack var2);

    public void disbandChannel(String var1, IDisbandCallBack var2);

    public void kickoff(long var1, IKickOffCallBack var3);

    public void pullBlackThisChannel(IPullBackCallBack var1);

    default public IChannelCenterService getCenterService() {
        return (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
    }

    public String getChannelId();

    @Nullable
    public String getVCid();

    public void addNotifyHandler(INotifyDispatchService.INotifyHandler var1);

    public void removeNotifyHandler(INotifyDispatchService.INotifyHandler var1);

    public static class JoinCallBackEx
    implements IJoinCallBack {
        private IJoinCallBack callBack;

        public JoinCallBackEx(IJoinCallBack joinCallBack) {
            this.callBack = joinCallBack;
        }

        @Override
        public void onSuccess(EnterParam requestParams, ChannelDetailInfo info, EnterChannelData data) {
            if (this.callBack != null) {
                this.callBack.onSuccess(requestParams, info, data);
            }
            MLog.info((Object)"FTRoomGroup", (String)(info.baseInfo.gid + ",join success requestParams:%s,info:%s, data:%s"), (Object[])new Object[]{requestParams, info, data});
        }

        @Override
        public void onFailByOnlineLimit(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByOnlineLimit(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByOnlineLimit:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailByNeedPassword(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByNeedPassword(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByNeedPassword:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailByPasswordError(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByPasswordError(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByPasswordError:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onKickOffFrozenError(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onKickOffFrozenError(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onKickOffFrozenError:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailByChannelNotExist(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByChannelNotExist(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByChannelNotExist:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onChannelBanned(EnterParam requestParams, ChannelBannedData bannedData, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onChannelBanned(requestParams, bannedData, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onChannelBanned:%s,bannedData:%s", (Object[])new Object[]{requestParams.toString(), bannedData != null ? bannedData.toString() : ""});
        }

        @Override
        public void onFailByPasswordTryTooFrequently(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByPasswordTryTooFrequently(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByPasswordTryTooFrequently:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onPrivateChannel(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onPrivateChannel(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onPrivateChannel:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailByInviteExpire(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByInviteExpire(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByInviteExpire:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailByInviteClickMaxLimit(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailByInviteClickMaxLimit(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailByInviteClickMaxLimit:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailChannelMatchFail(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailChannelMatchFail(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailChannelMatchFail:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailChannelAllDisBand(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailChannelAllDisBand(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailChannelAllDisBand:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onRetryUnBannedChannel(String channelId, EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onRetryUnBannedChannel(channelId, requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onRetryUnBannedChannel:%s", (Object[])new Object[]{channelId});
        }

        @Override
        public void onCrossRegionNotAllow(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onCrossRegionNotAllow(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onCrossRegionNotAllow:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailEnterMultiVideoRoom(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailEnterMultiVideoRoom(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailEnterMultiVideoRoom:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailClientHardwareBad(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailClientHardwareBad(requestParams, msgTip);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onFailClientHardwareBad:%s", (Object[])new Object[]{requestParams.toString()});
        }

        @Override
        public void onFailNumberNoArrow(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailNumberNoArrow(requestParams, msgTip);
            }
        }

        @Override
        public void onFailChannelShowNumLimit(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailChannelShowNumLimit(requestParams, msgTip);
            }
        }

        @Override
        public void onInBlackList(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onInBlackList(requestParams, msgTip);
            }
        }

        @Override
        public void onInOwnerBlackList(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onInOwnerBlackList(requestParams, msgTip);
            }
        }

        @Override
        public void onAgeLimit(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onAgeLimit(requestParams, msgTip);
            }
        }

        @Override
        public void onFailSensitive(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onFailSensitive(requestParams, msgTip);
            }
        }

        @Override
        public void onOtherError(EnterParam requestParams, String msgTip) {
            if (this.callBack != null) {
                this.callBack.onOtherError(requestParams, msgTip);
            }
        }

        @Override
        public void onError(EnterParam requestParams, int errorCode, String errorTips, Exception e) {
            if (this.callBack != null) {
                this.callBack.onError(requestParams, errorCode, errorTips, e);
            }
            MLog.info((Object)"FTRoomGroup", (String)"join onError errorCode:%d,errorTips:%s,requestParams:%s", (Object[])new Object[]{errorCode, errorTips, requestParams.toString()});
        }

        @Override
        public void onNotMatchChannel(EnterParam param) {
            if (this.callBack != null) {
                this.callBack.onNotMatchChannel(param);
            }
        }

        @Override
        public void onEnterLimitPopWindow(EnterParam param, String errmsg) {
            if (this.callBack != null) {
                this.callBack.onEnterLimitPopWindow(param, errmsg);
            }
        }

        @Override
        public void onModifyChannelLimit() {
            if (this.callBack != null) {
                this.callBack.onModifyChannelLimit();
            }
        }
    }

    public static interface IKickOffCallBack {
        public void onSuccess(String var1, long var2, long var4);

        public void onNoPermission();

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface ILeaveBroadcastGroupCallBack {
        public void onSuccess(String var1);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IJoinBroadcastGroupCallBack {
        public void onSuccess(ChannelInfo var1, MediaTokenInfo var2, List<SeatUser> var3);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface ILeaveCallBack {
        public void onSuccess(String var1, ChannelLeaveResp var2);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IPullBackCallBack {
        public void onSuccess(String var1);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IJoinCallBack {
        public void onSuccess(EnterParam var1, ChannelDetailInfo var2, EnterChannelData var3);

        public void onFailByOnlineLimit(EnterParam var1, String var2);

        public void onFailByNeedPassword(EnterParam var1, String var2);

        public void onFailByPasswordError(EnterParam var1, String var2);

        public void onKickOffFrozenError(EnterParam var1, String var2);

        public void onFailByChannelNotExist(EnterParam var1, String var2);

        public void onChannelBanned(EnterParam var1, ChannelBannedData var2, String var3);

        public void onFailByPasswordTryTooFrequently(EnterParam var1, String var2);

        public void onPrivateChannel(EnterParam var1, String var2);

        public void onFailByInviteExpire(EnterParam var1, String var2);

        public void onFailByInviteClickMaxLimit(EnterParam var1, String var2);

        public void onFailChannelMatchFail(EnterParam var1, String var2);

        public void onFailChannelAllDisBand(EnterParam var1, String var2);

        public void onRetryUnBannedChannel(String var1, EnterParam var2, String var3);

        public void onCrossRegionNotAllow(EnterParam var1, String var2);

        public void onFailEnterMultiVideoRoom(EnterParam var1, String var2);

        public void onFailClientHardwareBad(EnterParam var1, String var2);

        public void onFailNumberNoArrow(EnterParam var1, String var2);

        public void onFailSensitive(EnterParam var1, String var2);

        public void onFailChannelShowNumLimit(EnterParam var1, String var2);

        public void onInBlackList(EnterParam var1, String var2);

        public void onInOwnerBlackList(EnterParam var1, String var2);

        public void onAgeLimit(EnterParam var1, String var2);

        public void onOtherError(EnterParam var1, String var2);

        public void onError(EnterParam var1, int var2, String var3, Exception var4);

        public void onNotMatchChannel(EnterParam var1);

        public void onEnterLimitPopWindow(EnterParam var1, String var2);

        public void onModifyChannelLimit();
    }

    public static interface IDisbandCallBack {
        public void onSuccess(String var1);

        public void onFailByStillHasOthersIn(String var1);

        public void onFailByCannotDeleteTopChannel(String var1);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface ICreateCallBack {
        public void onSuccess(ChannelDetailInfo var1);

        public void onFailByGroupNumLimit(String var1);

        public void onContainSensitiveWord(CreateChannelParams var1, String var2);

        public void onNoPermission(String var1);

        public void onNoUseOldVersion(String var1);

        public void onOtherError(String var1);

        public void onError(int var1, String var2, Exception var3);
    }
}

