/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean.create;

import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.channel.base.bean.SameCityInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import net.ihago.channel.srv.mgr.EntryPoint;

public class CreateChannelParams {
    public int type;
    public String name;
    public String tagId;
    public TagBean extraTagBean;
    public long ownUid = AccountUtil.getUid();
    public long creatorUid = AccountUtil.getUid();
    public String parentCid;
    public boolean isSameCity;
    public SameCityInfo sameCityInfo;
    public int from;
    public long cardId;
    public boolean mustSelectTag;
    public boolean needCheckPermit;
    public String avatar = "";
    public ChannelPluginData channelPluginData;
    public String password = "";
    public int joinMode = 1;
    public boolean isShowGamePanel = false;
    public int createType = 1;
    public int createFrom;
    public int lockEnterMode = 1;
    public String source = "";
    public int beRoleMode;
    public long joinPayLevel;
    public long joinActiveTime;
    public int firstType;
    public int secondType;
    public boolean enterChannelWhenCreated = true;
    public String groupCid;
    public boolean isFromGroup = false;
    public boolean isFromChannelCard = false;
    @Nullable
    public String fromChannelId;
    public String gameId = "";
    public Integer defaultPluginType = null;
    public boolean hasShowPartyToast = false;
    public boolean assistGameStartMatch = false;

    private CreateChannelParams() {
    }

    public static CreateChannelParams obtain() {
        return new CreateChannelParams();
    }

    public static CreateChannelParams obtain(String parentCid, int type, String name) {
        return new Builder().type(type).name(name).parentCid(parentCid).build();
    }

    public static CreateChannelParams obtain(String parentCid, int type, String name, String tagId, int from) {
        return new Builder().type(type).name(name).parentCid(parentCid).tagId(tagId).from(from).build();
    }

    public static CreateChannelParams obtain(String parentCid, int from) {
        return new Builder().parentCid(parentCid).from(from).build();
    }

    public static CreateChannelParams obtain(String parentCid, int from, long cardId) {
        return new Builder().parentCid(parentCid).from(from).cardId(cardId).build();
    }

    public String toString() {
        return "CreateChannelParams{type=" + this.type + ", name='" + this.name + '\'' + ", tagId='" + this.tagId + '\'' + ", extraTagBean=" + this.extraTagBean + ", ownUid=" + this.ownUid + ", creatorUid=" + this.creatorUid + ", parentCid='" + this.parentCid + '\'' + ", isSameCity=" + this.isSameCity + ", sameCityInfo=" + this.sameCityInfo + ", from=" + this.from + ", cardId=" + this.cardId + ", mustSelectTag=" + this.mustSelectTag + ", needCheckPermit=" + this.needCheckPermit + ", avatar='" + this.avatar + '\'' + ", channelPluginData=" + (Object)((Object)this.channelPluginData) + ", password='" + this.password + '\'' + ", joinMode=" + this.joinMode + ", isShowGamePanel=" + this.isShowGamePanel + ", createType=" + this.createType + ", createFrom=" + this.createFrom + ", lockEnterMode=" + this.lockEnterMode + ", source='" + this.source + '\'' + ", beRoleMode=" + this.beRoleMode + ", joinPayLevel=" + this.joinPayLevel + ", joinActiveTime=" + this.joinActiveTime + ", firstType=" + this.firstType + ", secondType=" + this.secondType + '}';
    }

    public static class Builder {
        private int type;
        private String name;
        private String tagId;
        private TagBean extraTagBean;
        private String parentCid;
        private boolean isSameCity;
        private SameCityInfo sameCityInfo;
        public String avatar = "";
        private int from;
        private int createFrom;
        private long cardId;
        private boolean mustSelectTag;
        private String source = "";
        private int beRoleMode;
        private String groupCid;
        private boolean isFromGroup = false;
        private boolean hasShowPartyToast = false;
        private boolean isFromChannelCard = false;
        private String fromChannelId;

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder extraTagBean(TagBean extraTagBean) {
            this.extraTagBean = extraTagBean;
            return this;
        }

        public Builder parentCid(String parentCid) {
            this.parentCid = parentCid;
            return this;
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder isSameCity(boolean isSameCity) {
            this.isSameCity = isSameCity;
            return this;
        }

        public Builder sameCityInfo(SameCityInfo sameCityInfo) {
            this.sameCityInfo = sameCityInfo;
            return this;
        }

        public Builder from(int from) {
            this.from = from;
            return this;
        }

        public Builder createFrom(int createFrom) {
            this.createFrom = createFrom;
            return this;
        }

        public Builder cardId(long cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder mustSelectTag(boolean mustSelectTag) {
            this.mustSelectTag = mustSelectTag;
            return this;
        }

        public Builder beRoleMode(int beRoleMode) {
            this.beRoleMode = beRoleMode;
            return this;
        }

        public Builder groupCid(String groupCid) {
            this.groupCid = groupCid;
            return this;
        }

        public Builder isFromGroup(boolean isFromGroup) {
            this.isFromGroup = isFromGroup;
            return this;
        }

        public Builder hasShowPartyToast(boolean hasShowPartyToast) {
            this.hasShowPartyToast = hasShowPartyToast;
            return this;
        }

        public Builder isFromChannelCard(boolean isFromChannelCard) {
            this.isFromChannelCard = isFromChannelCard;
            return this;
        }

        public Builder fromChannelId(String fromChannelId) {
            this.fromChannelId = fromChannelId;
            return this;
        }

        public CreateChannelParams build() {
            CreateChannelParams params = CreateChannelParams.obtain();
            params.type = this.type;
            params.tagId = this.tagId;
            params.extraTagBean = this.extraTagBean;
            params.name = this.name;
            params.parentCid = this.parentCid;
            params.avatar = this.avatar;
            params.isSameCity = this.isSameCity;
            params.sameCityInfo = this.sameCityInfo;
            params.from = this.from;
            params.createFrom = this.createFrom;
            params.cardId = this.cardId;
            params.mustSelectTag = this.mustSelectTag;
            params.beRoleMode = this.beRoleMode;
            params.source = this.source;
            params.groupCid = this.groupCid;
            params.isFromGroup = this.isFromGroup;
            params.hasShowPartyToast = this.hasShowPartyToast;
            params.isFromChannelCard = this.isFromChannelCard;
            params.fromChannelId = this.fromChannelId;
            if (this.isFromGroup && StringUtils.isEmpty((String)this.groupCid)) {
                throw new IllegalArgumentException("\u4ece\u7fa4\u7ec4\u521b\u5efa\uff0c\u5fc5\u987b\u6307\u5b9a\u7fa4\u7ec4cid");
            }
            return params;
        }
    }

    public static class CreateType {
        public static final int TYPE_GROUP = 1;
        public static final int TYPE_ROOM = 2;
    }

    public static class CreateFrom {
        public static final int channel_from_aggregation = 1;
        public static final int channel_from_social = 2;
        public static final int channel_from_im = 3;
        public static final int channel_from_my = 4;
        public static final int channel_from_bbs = 5;
        public static final int channel_from_same_city = 6;
        public static final int channel_from_h5 = 7;
        public static final int choose_share_page = 8;
        public static final int im_more_option = 9;
        public static final int discovery_group = 10;
        public static final int select_group = 11;
        public static final int party_channel_list = 12;
        public static final int tool_create_group = 13;
        public static final int party_tips_create_group = 14;
        public static final int in_game_create = 15;
        public static final int play_with_friends = 21;
        public static final int home_create = 22;
        public static final int my_created_page = 23;
        public static final int old_user_with_party = 24;
    }

    public static class From {
        public static final int None = EntryPoint.None.getValue();
        public static final int channel_recommand_page = EntryPoint.CHANNEL_FROM_AGGREGATION.getValue();
        public static final int channel_list_panel = EntryPoint.CHANNEL_FROM_SOCIAL.getValue();
        public static final int channel_aggregation = EntryPoint.CHANNEL_FROM_IM.getValue();
        public static final int channel_link_tag = EntryPoint.CHANNEL_FROM_MY.getValue();
        public static final int channel_more_list = EntryPoint.CHANNEL_FROM_BBS.getValue();
        public static final int my_channel_list = EntryPoint.CHANNEL_FROM_SAME_CITY.getValue();
        public static final int channel_h5 = EntryPoint.CHANNEL_FROM_H5.getValue();
        public static final int choose_share_page = EntryPoint.CHOOSE_SHARE_PAGE.getValue();
        public static final int im_more_option = EntryPoint.IM_MORE_OPTION.getValue();
        public static final int discovery_group = EntryPoint.DISCOVERY_GROUP.getValue();
        public static final int select_group = EntryPoint.SELECT_GROUP.getValue();
        public static final int party_channel_list = EntryPoint.PARTY_CHANNEL_LIST.getValue();
        public static final int tool_create_group = EntryPoint.TOOL_CREATE_GROUP.getValue();
        public static final int HIIDO_UPGRADE_CREATE_BY_MYSHOW = EntryPoint.HIIDO_UPGRADE_CREATE_BY_MYSHOW.getValue();
        public static final int HIIDO_UPGRADE_CREATE_BY_CHANNELSHOW = EntryPoint.HIIDO_UPGRADE_CREATE_BY_CHANNELSHOW.getValue();
        public static final int HIIDO_UPGRADE_CREATE_BY_CHANNELNEWTOP = EntryPoint.HIIDO_UPGRADE_CREATE_BY_CHANNELNEWTOP.getValue();
        public static final int GAME_TYPE = 19;
        public static final int PLAY_WITH_FRIENDS = EntryPoint.HIIDO_PLAY_WITH_FRIENDS.getValue();
        public static final int channel_bottom_add = EntryPoint.HIIDO_BOTTOM_ADD.getValue();
        public static final int BOTTOM_PLUS_CREATE = EntryPoint.BOTTOM_PLUS_CREATE.getValue();
        public static final int BOTTOM_LIST_CREATE = EntryPoint.BOTTOM_LIST_CREATE.getValue();
    }
}

