/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IBeforeSeatUpdateListener;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SeatData
extends KvoSource {
    private static final String TAG = "SeatData";
    public static final int SEAT_INDEX_BEGIN = 1;
    private List<SeatUser> mSeatList = new ArrayList<SeatUser>(12);
    private Long lastValidFirstSeatUid = 0L;
    public static final String kvo_isSeatChanged = "isSeatChanged";
    @KvoFieldAnnotation(name="isSeatChanged")
    private Object isSeatChanged;
    private List<WeakReference<ISeatUpdateListener>> mSeatUpdateListenerList = new CopyOnWriteArrayList<WeakReference<ISeatUpdateListener>>();
    private List<WeakReference<IBeforeSeatUpdateListener>> mBeforeSeatUpdateListenerList = new CopyOnWriteArrayList<WeakReference<IBeforeSeatUpdateListener>>();

    public List<SeatUser> getSeatList() {
        return this.mSeatList;
    }

    public Long getLastValidFirstSeatUid() {
        return this.lastValidFirstSeatUid;
    }

    public void clearLastValidFirstSeatUid() {
        this.lastValidFirstSeatUid = 0L;
    }

    public List<SeatUser> getHasUserSeatList() {
        ArrayList<SeatUser> list = new ArrayList<SeatUser>();
        for (SeatUser seatUser : this.mSeatList) {
            if (seatUser.uid <= 0L) continue;
            list.add(seatUser);
        }
        return list;
    }

    public boolean hasUserInSeat() {
        for (SeatUser seatUser : this.mSeatList) {
            if (seatUser.uid <= 0L) continue;
            return true;
        }
        return false;
    }

    public List<Long> getSeatUidsList() {
        ArrayList<Long> uidList = new ArrayList<Long>(this.mSeatList.size());
        for (SeatUser seat : this.mSeatList) {
            uidList.add(seat.uid);
        }
        return uidList;
    }

    public List<Long> getSeatStatusList() {
        ArrayList<Long> statusList = new ArrayList<Long>(this.mSeatList.size());
        for (SeatUser seat : this.mSeatList) {
            statusList.add(seat.status);
        }
        return statusList;
    }

    public void updateSeatStatusList(List<Long> seatStatusList) {
        int size = Math.min(seatStatusList.size(), this.mSeatList.size());
        for (int i = 0; i < size; ++i) {
            this.mSeatList.get((int)i).status = seatStatusList.get(i);
        }
    }

    public SeatUser getSeatByUid(long uid) {
        for (SeatUser seat : this.mSeatList) {
            if (seat.uid != uid) continue;
            return seat;
        }
        return null;
    }

    public SeatUser getSeatByIndex(int index) {
        for (SeatUser seat : this.mSeatList) {
            if (seat.index != index) continue;
            return seat;
        }
        return null;
    }

    public int getSeatIndex(long uid) {
        SeatUser seat = this.getSeatByUid(uid);
        if (seat != null) {
            return seat.index;
        }
        return -1;
    }

    public boolean isInFirstSeat(long uid) {
        return 1 == this.getSeatIndex(uid);
    }

    public long getSeatStatus(long uid) {
        SeatUser seat = this.getSeatByUid(uid);
        if (seat != null) {
            return seat.status;
        }
        return 0L;
    }

    public boolean isInSeat(long uid) {
        return this.getSeatByUid(uid) != null;
    }

    public boolean isSeatFull() {
        for (SeatUser seat : this.mSeatList) {
            if (0L != seat.uid) continue;
            return false;
        }
        return true;
    }

    public boolean isSeatLocked(int seatIndex) {
        SeatUser seat = this.getSeatByIndex(seatIndex);
        return seat != null && SeatStatusUtils.isLocked((long)seat.status);
    }

    public boolean isSeatAllLocked() {
        if (FP.empty(this.mSeatList)) {
            return false;
        }
        for (SeatUser seat : this.mSeatList) {
            if (SeatStatusUtils.isLocked((long)seat.status)) continue;
            return false;
        }
        return true;
    }

    public boolean isSeatFullWithLocked() {
        if (FP.empty(this.mSeatList)) {
            return false;
        }
        for (SeatUser seat : this.mSeatList) {
            if (0L != seat.uid || SeatStatusUtils.isLocked((long)seat.status)) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySeatIndex() {
        if (FP.empty(this.mSeatList)) {
            return -1;
        }
        for (int i = 0; i < this.mSeatList.size(); ++i) {
            SeatUser seat = this.mSeatList.get(i);
            if (0L != seat.uid || SeatStatusUtils.isLocked((long)seat.status)) continue;
            return i;
        }
        return -1;
    }

    public void update(List<SeatUser> seatList, boolean notifyChanged) {
        if (this.mSeatList.equals(seatList)) {
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"update data not change", (Object[])new Object[0]);
            }
            return;
        }
        if (null == seatList) {
            seatList = new ArrayList<SeatUser>();
        }
        MLog.info((Object)TAG, (String)"update notifyChanged %b, %s", (Object[])new Object[]{notifyChanged, seatList});
        this.beforeSeatUpdate(seatList);
        this.mSeatList = seatList;
        if (notifyChanged) {
            this.updateFirstSeatUid(seatList);
            this.onSeatUpdate();
            this.setSeatChanged(new Object());
        }
    }

    private void updateFirstSeatUid(List<SeatUser> seatList) {
        if (seatList.size() > 0 && seatList.get((int)0).uid > 0L) {
            this.lastValidFirstSeatUid = seatList.get((int)0).uid;
        }
    }

    public void setSeatChanged(Object seatChanged) {
        this.setValue(kvo_isSeatChanged, seatChanged);
    }

    public void addSeatUpdateListener(ISeatUpdateListener listener) {
        for (WeakReference<ISeatUpdateListener> weakRef : this.mSeatUpdateListenerList) {
            ISeatUpdateListener seatUpdateListener = (ISeatUpdateListener)weakRef.get();
            if (seatUpdateListener != listener) continue;
            return;
        }
        this.mSeatUpdateListenerList.add(new WeakReference<ISeatUpdateListener>(listener));
        if (listener != null) {
            listener.onSeatUpdate(this.mSeatList);
        }
    }

    public void removeSeatUpdateListener(ISeatUpdateListener listener) {
        WeakReference<ISeatUpdateListener> foundRef = null;
        for (WeakReference<ISeatUpdateListener> weakRef : this.mSeatUpdateListenerList) {
            ISeatUpdateListener seatUpdateListener = (ISeatUpdateListener)weakRef.get();
            if (seatUpdateListener != listener) continue;
            foundRef = weakRef;
            break;
        }
        if (foundRef != null) {
            this.mSeatUpdateListenerList.remove(foundRef);
        }
    }

    private void onSeatUpdate() {
        for (WeakReference<ISeatUpdateListener> weakRef : this.mSeatUpdateListenerList) {
            ISeatUpdateListener listener = (ISeatUpdateListener)weakRef.get();
            if (listener == null) continue;
            listener.onSeatUpdate(this.mSeatList);
        }
    }

    public void addBeforeUpdateSeatListener(IBeforeSeatUpdateListener listener) {
        for (WeakReference<IBeforeSeatUpdateListener> weakRef : this.mBeforeSeatUpdateListenerList) {
            IBeforeSeatUpdateListener beforeSeatUpdateListener = (IBeforeSeatUpdateListener)weakRef.get();
            if (beforeSeatUpdateListener != listener) continue;
            return;
        }
        this.mBeforeSeatUpdateListenerList.add(new WeakReference<IBeforeSeatUpdateListener>(listener));
    }

    public void removeBeforeUpdateSeatListener(IBeforeSeatUpdateListener listener) {
        WeakReference<IBeforeSeatUpdateListener> foundRef = null;
        for (WeakReference<IBeforeSeatUpdateListener> weakRef : this.mBeforeSeatUpdateListenerList) {
            IBeforeSeatUpdateListener beforeSeatUpdateListener = (IBeforeSeatUpdateListener)weakRef.get();
            if (beforeSeatUpdateListener != listener) continue;
            foundRef = weakRef;
            return;
        }
        if (foundRef != null) {
            this.mBeforeSeatUpdateListenerList.remove(foundRef);
        }
    }

    private void beforeSeatUpdate(List<SeatUser> seatList) {
        for (WeakReference<IBeforeSeatUpdateListener> weakRef : this.mBeforeSeatUpdateListenerList) {
            IBeforeSeatUpdateListener listener = (IBeforeSeatUpdateListener)weakRef.get();
            if (listener == null) continue;
            listener.beforeSeatUpdate(seatList);
        }
    }

    public void clear() {
        if (this.mSeatList != null) {
            this.mSeatList.clear();
        }
        this.lastValidFirstSeatUid = 0L;
    }

    public long getFirstNotEmptySeatUid() {
        if (FP.empty(this.mSeatList)) {
            return -1L;
        }
        for (int i = 0; i < this.mSeatList.size(); ++i) {
            SeatUser seat = this.mSeatList.get(i);
            if (0L == seat.uid || SeatStatusUtils.isLocked((long)seat.status)) continue;
            return seat.uid;
        }
        return -1L;
    }
}

