/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.widget;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;

public class GalleryLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private static final String TAG = "GalleryLayoutManager";
    static final int LAYOUT_START = -1;
    static final int LAYOUT_END = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mFirstVisiblePosition = 0;
    private int mLastVisiblePos = 0;
    private int mInitialSelectedPosition = 0;
    int mCurSelectedPosition = -1;
    View mCurSelectedView;
    private State mState;
    private LinearSnapHelper mSnapHelper = new LinearSnapHelper();
    private InnerScrollListener mInnerScrollListener = new InnerScrollListener();
    private boolean mCallbackInFling = false;
    private int mOrientation = 0;
    private OrientationHelper mHorizontalHelper;
    private OrientationHelper mVerticalHelper;
    private ItemTransformer mItemTransformer;
    private OnItemSelectedListener mOnItemSelectedListener;
    RecyclerView mRecyclerView;

    public GalleryLayoutManager(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getCurSelectedPosition() {
        return this.mCurSelectedPosition;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return new LayoutParams(-2, -1);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            this.reset();
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        if (state.isPreLayout()) {
            return;
        }
        if (state.getItemCount() != 0 && !state.didStructureChange()) {
            return;
        }
        if (this.getChildCount() == 0 || state.didStructureChange()) {
            this.reset();
        }
        this.mInitialSelectedPosition = Math.min(Math.max(0, this.mInitialSelectedPosition), this.getItemCount() - 1);
        this.detachAndScrapAttachedViews(recycler);
        this.firstFillCover(recycler, state, 0);
    }

    private void reset() {
        if (this.mState != null) {
            this.mState.mItemsFrames.clear();
        }
        if (this.mCurSelectedPosition != -1) {
            this.mInitialSelectedPosition = this.mCurSelectedPosition;
        }
        this.mFirstVisiblePosition = this.mInitialSelectedPosition = Math.min(Math.max(0, this.mInitialSelectedPosition), this.getItemCount() - 1);
        this.mLastVisiblePos = this.mInitialSelectedPosition;
        this.mCurSelectedPosition = -1;
        if (this.mCurSelectedView != null) {
            this.mCurSelectedView.setSelected(false);
            this.mCurSelectedView = null;
        }
    }

    private void firstFillCover(RecyclerView.Recycler recycler, RecyclerView.State state, int scrollDelta) {
        if (this.mOrientation == 0) {
            this.firstFillWithHorizontal(recycler, state);
        } else {
            this.firstFillWithVertical(recycler, state);
        }
        if (this.mItemTransformer != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                this.mItemTransformer.transformItem(this, child, this.calculateToCenterFraction(child, scrollDelta));
            }
        }
        this.mInnerScrollListener.onScrolled(this.mRecyclerView, 0, 0);
    }

    private void firstFillWithHorizontal(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachAndScrapAttachedViews(recycler);
        int leftEdge = this.getOrientationHelper().getStartAfterPadding();
        int rightEdge = this.getOrientationHelper().getEndAfterPadding();
        int startPosition = this.mInitialSelectedPosition;
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        View scrap = recycler.getViewForPosition(this.mInitialSelectedPosition);
        this.addView(scrap, 0);
        this.measureChildWithMargins(scrap, 0, 0);
        int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
        int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
        int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
        int left = (int)((float)this.getPaddingLeft() + (float)(this.getHorizontalSpace() - scrapWidth) / 2.0f);
        scrapRect.set(left, topOffset, left + scrapWidth, topOffset + scrapHeight);
        this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
        if (this.getState().mItemsFrames.get(startPosition) == null) {
            this.getState().mItemsFrames.put(startPosition, (Object)scrapRect);
        } else {
            ((Rect)this.getState().mItemsFrames.get(startPosition)).set(scrapRect);
        }
        this.mFirstVisiblePosition = this.mLastVisiblePos = startPosition;
        int leftStartOffset = this.getDecoratedLeft(scrap);
        int rightStartOffset = this.getDecoratedRight(scrap);
        this.fillLeft(recycler, this.mInitialSelectedPosition - 1, leftStartOffset, leftEdge);
        this.fillRight(recycler, this.mInitialSelectedPosition + 1, rightStartOffset, rightEdge);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        super.onItemsRemoved(recyclerView, positionStart, itemCount);
    }

    private void firstFillWithVertical(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachAndScrapAttachedViews(recycler);
        int topEdge = this.getOrientationHelper().getStartAfterPadding();
        int bottomEdge = this.getOrientationHelper().getEndAfterPadding();
        int startPosition = this.mInitialSelectedPosition;
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        View scrap = recycler.getViewForPosition(this.mInitialSelectedPosition);
        this.addView(scrap, 0);
        this.measureChildWithMargins(scrap, 0, 0);
        int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
        int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
        int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
        int top = (int)((float)this.getPaddingTop() + (float)(this.getVerticalSpace() - scrapHeight) / 2.0f);
        scrapRect.set(leftOffset, top, leftOffset + scrapWidth, top + scrapHeight);
        this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
        if (this.getState().mItemsFrames.get(startPosition) == null) {
            this.getState().mItemsFrames.put(startPosition, (Object)scrapRect);
        } else {
            ((Rect)this.getState().mItemsFrames.get(startPosition)).set(scrapRect);
        }
        this.mFirstVisiblePosition = this.mLastVisiblePos = startPosition;
        int topStartOffset = this.getDecoratedTop(scrap);
        int bottomStartOffset = this.getDecoratedBottom(scrap);
        this.fillTop(recycler, this.mInitialSelectedPosition - 1, topStartOffset, topEdge);
        this.fillBottom(recycler, this.mInitialSelectedPosition + 1, bottomStartOffset, bottomEdge);
    }

    private void fillLeft(RecyclerView.Recycler recycler, int startPosition, int startOffset, int leftEdge) {
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        for (int i = startPosition; i >= 0 && startOffset > leftEdge; --i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap, 0);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
            scrapRect.set(startOffset - scrapWidth, topOffset, startOffset, topOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.left;
            this.mFirstVisiblePosition = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillRight(RecyclerView.Recycler recycler, int startPosition, int startOffset, int rightEdge) {
        Rect scrapRect = new Rect();
        int height = this.getVerticalSpace();
        for (int i = startPosition; i < this.getItemCount() && startOffset < rightEdge; ++i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
            scrapRect.set(startOffset, topOffset, startOffset + scrapWidth, topOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.right;
            this.mLastVisiblePos = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillTop(RecyclerView.Recycler recycler, int startPosition, int startOffset, int topEdge) {
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        for (int i = startPosition; i >= 0 && startOffset > topEdge; --i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap, 0);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
            scrapRect.set(leftOffset, startOffset - scrapHeight, leftOffset + scrapWidth, startOffset);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.top;
            this.mFirstVisiblePosition = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillBottom(RecyclerView.Recycler recycler, int startPosition, int startOffset, int bottomEdge) {
        Rect scrapRect = new Rect();
        int width = this.getHorizontalSpace();
        for (int i = startPosition; i < this.getItemCount() && startOffset < bottomEdge; ++i) {
            View scrap = recycler.getViewForPosition(i);
            this.addView(scrap);
            this.measureChildWithMargins(scrap, 0, 0);
            int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
            int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
            int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
            scrapRect.set(leftOffset, startOffset, leftOffset + scrapWidth, startOffset + scrapHeight);
            this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
            startOffset = scrapRect.bottom;
            this.mLastVisiblePos = i;
            if (this.getState().mItemsFrames.get(i) == null) {
                this.getState().mItemsFrames.put(i, (Object)scrapRect);
                continue;
            }
            ((Rect)this.getState().mItemsFrames.get(i)).set(scrapRect);
        }
    }

    private void fillCover(RecyclerView.Recycler recycler, RecyclerView.State state, int scrollDelta) {
        if (this.getItemCount() == 0) {
            return;
        }
        if (this.mOrientation == 0) {
            this.fillWithHorizontal(recycler, state, scrollDelta);
        } else {
            this.fillWithVertical(recycler, state, scrollDelta);
        }
        if (this.mItemTransformer != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                this.mItemTransformer.transformItem(this, child, this.calculateToCenterFraction(child, scrollDelta));
            }
        }
    }

    private float calculateToCenterFraction(View child, float pendingOffset) {
        int distance = this.calculateDistanceCenter(child, pendingOffset);
        int childLength = this.mOrientation == 0 ? child.getWidth() : child.getHeight();
        return Math.max(-1.0f, Math.min(1.0f, (float)distance * 1.0f / (float)childLength));
    }

    private int calculateDistanceCenter(View child, float pendingOffset) {
        OrientationHelper orientationHelper = this.getOrientationHelper();
        int parentCenter = (orientationHelper.getEndAfterPadding() - orientationHelper.getStartAfterPadding()) / 2 + orientationHelper.getStartAfterPadding();
        if (this.mOrientation == 0) {
            return (int)((float)(child.getWidth() / 2) - pendingOffset + (float)child.getLeft() - (float)parentCenter);
        }
        return (int)((float)(child.getHeight() / 2) - pendingOffset + (float)child.getTop() - (float)parentCenter);
    }

    private void fillWithVertical(RecyclerView.Recycler recycler, RecyclerView.State state, int dy) {
        int topEdge = this.getOrientationHelper().getStartAfterPadding();
        int bottomEdge = this.getOrientationHelper().getEndAfterPadding();
        if (this.getChildCount() > 0) {
            View child;
            if (dy >= 0) {
                int fixIndex = 0;
                for (int i = 0; i < this.getChildCount() && this.getDecoratedBottom(child = this.getChildAt(i + fixIndex)) - dy < topEdge; ++i) {
                    this.removeAndRecycleView(child, recycler);
                    ++this.mFirstVisiblePosition;
                    --fixIndex;
                }
            } else {
                for (int i = this.getChildCount() - 1; i >= 0 && this.getDecoratedTop(child = this.getChildAt(i)) - dy > bottomEdge; --i) {
                    this.removeAndRecycleView(child, recycler);
                    --this.mLastVisiblePos;
                }
            }
        }
        int startPosition = this.mFirstVisiblePosition;
        int startOffset = -1;
        int width = this.getHorizontalSpace();
        if (dy >= 0) {
            if (this.getChildCount() != 0) {
                View lastView = this.getChildAt(this.getChildCount() - 1);
                startPosition = this.getPosition(lastView) + 1;
                startOffset = this.getDecoratedBottom(lastView);
            }
            int i = startPosition;
            while (i < this.getItemCount() && startOffset < bottomEdge + dy) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
                if (startOffset == -1 && startPosition == 0) {
                    int top = (int)((float)this.getPaddingTop() + (float)(this.getVerticalSpace() - scrapHeight) / 2.0f);
                    scrapRect.set(leftOffset, top, leftOffset + scrapWidth, top + scrapHeight);
                } else {
                    scrapRect.set(leftOffset, startOffset, leftOffset + scrapWidth, startOffset + scrapHeight);
                }
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.bottom;
                this.mLastVisiblePos = i++;
            }
        } else {
            if (this.getChildCount() > 0) {
                View firstView = this.getChildAt(0);
                startPosition = this.getPosition(firstView) - 1;
                startOffset = this.getDecoratedTop(firstView);
            }
            int i = startPosition;
            while (i >= 0 && startOffset > topEdge + dy) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap, 0);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int leftOffset = (int)((float)this.getPaddingLeft() + (float)(width - scrapWidth) / 2.0f);
                scrapRect.set(leftOffset, startOffset - scrapHeight, leftOffset + scrapWidth, startOffset);
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.top;
                this.mFirstVisiblePosition = i--;
            }
        }
    }

    private void fillWithHorizontal(RecyclerView.Recycler recycler, RecyclerView.State state, int dx) {
        int leftEdge = this.getOrientationHelper().getStartAfterPadding();
        int rightEdge = this.getOrientationHelper().getEndAfterPadding();
        if (this.getChildCount() > 0) {
            View child;
            if (dx >= 0) {
                int fixIndex = 0;
                for (int i = 0; i < this.getChildCount() && this.getDecoratedRight(child = this.getChildAt(i + fixIndex)) - dx < leftEdge; ++i) {
                    this.removeAndRecycleView(child, recycler);
                    ++this.mFirstVisiblePosition;
                    --fixIndex;
                }
            } else {
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    child = this.getChildAt(i);
                    if (this.getDecoratedLeft(child) - dx <= rightEdge) continue;
                    this.removeAndRecycleView(child, recycler);
                    --this.mLastVisiblePos;
                }
            }
        }
        int startPosition = this.mFirstVisiblePosition;
        int startOffset = -1;
        int height = this.getVerticalSpace();
        if (dx >= 0) {
            if (this.getChildCount() != 0) {
                View lastView = this.getChildAt(this.getChildCount() - 1);
                startPosition = this.getPosition(lastView) + 1;
                startOffset = this.getDecoratedRight(lastView);
            }
            int i = startPosition;
            while (i < this.getItemCount() && startOffset < rightEdge + dx) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
                if (startOffset == -1 && startPosition == 0) {
                    int left = (int)((float)this.getPaddingLeft() + (float)(this.getHorizontalSpace() - scrapWidth) / 2.0f);
                    scrapRect.set(left, topOffset, left + scrapWidth, topOffset + scrapHeight);
                } else {
                    scrapRect.set(startOffset, topOffset, startOffset + scrapWidth, topOffset + scrapHeight);
                }
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.right;
                this.mLastVisiblePos = i++;
            }
        } else {
            if (this.getChildCount() > 0) {
                View firstView = this.getChildAt(0);
                startPosition = this.getPosition(firstView) - 1;
                startOffset = this.getDecoratedLeft(firstView);
            }
            int i = startPosition;
            while (i >= 0 && startOffset > leftEdge + dx) {
                Rect scrapRect = (Rect)this.getState().mItemsFrames.get(i);
                View scrap = recycler.getViewForPosition(i);
                this.addView(scrap, 0);
                if (scrapRect == null) {
                    scrapRect = new Rect();
                    this.getState().mItemsFrames.put(i, (Object)scrapRect);
                }
                this.measureChildWithMargins(scrap, 0, 0);
                int scrapWidth = this.getDecoratedMeasuredWidth(scrap);
                int scrapHeight = this.getDecoratedMeasuredHeight(scrap);
                int topOffset = (int)((float)this.getPaddingTop() + (float)(height - scrapHeight) / 2.0f);
                scrapRect.set(startOffset - scrapWidth, topOffset, startOffset, topOffset + scrapHeight);
                this.layoutDecorated(scrap, scrapRect.left, scrapRect.top, scrapRect.right, scrapRect.bottom);
                startOffset = scrapRect.left;
                this.mFirstVisiblePosition = i--;
            }
        }
    }

    private int getHorizontalSpace() {
        return this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int getVerticalSpace() {
        return this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
    }

    public State getState() {
        if (this.mState == null) {
            this.mState = new State();
        }
        return this.mState;
    }

    private int calculateScrollDirectionForPosition(int position) {
        if (this.getChildCount() == 0) {
            return -1;
        }
        int firstChildPos = this.mFirstVisiblePosition;
        return position < firstChildPos ? -1 : 1;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction = this.calculateScrollDirectionForPosition(targetPosition);
        PointF outVector = new PointF();
        if (direction == 0) {
            return null;
        }
        if (this.mOrientation == 0) {
            outVector.x = direction;
            outVector.y = 0.0f;
        } else {
            outVector.x = 0.0f;
            outVector.y = direction;
        }
        return outVector;
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dx == 0) {
            return 0;
        }
        int delta = -dx;
        int parentCenter = (this.getOrientationHelper().getEndAfterPadding() - this.getOrientationHelper().getStartAfterPadding()) / 2 + this.getOrientationHelper().getStartAfterPadding();
        if (dx > 0) {
            if (this.getPosition(this.getChildAt(this.getChildCount() - 1)) == this.getItemCount() - 1) {
                View child = this.getChildAt(this.getChildCount() - 1);
                delta = -Math.max(0, Math.min(dx, (child.getRight() - child.getLeft()) / 2 + child.getLeft() - parentCenter));
            }
        } else if (this.mFirstVisiblePosition == 0) {
            View child = this.getChildAt(0);
            delta = -Math.min(0, Math.max(dx, (child.getRight() - child.getLeft()) / 2 + child.getLeft() - parentCenter));
        }
        this.getState().mScrollDelta = -delta;
        this.fillCover(recycler, state, -delta);
        this.offsetChildrenHorizontal(delta);
        return -delta;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        int delta = -dy;
        int parentCenter = (this.getOrientationHelper().getEndAfterPadding() - this.getOrientationHelper().getStartAfterPadding()) / 2 + this.getOrientationHelper().getStartAfterPadding();
        if (dy > 0) {
            if (this.getPosition(this.getChildAt(this.getChildCount() - 1)) == this.getItemCount() - 1) {
                View child = this.getChildAt(this.getChildCount() - 1);
                delta = -Math.max(0, Math.min(dy, (this.getDecoratedBottom(child) - this.getDecoratedTop(child)) / 2 + this.getDecoratedTop(child) - parentCenter));
            }
        } else if (this.mFirstVisiblePosition == 0) {
            View child = this.getChildAt(0);
            delta = -Math.min(0, Math.max(dy, (this.getDecoratedBottom(child) - this.getDecoratedTop(child)) / 2 + this.getDecoratedTop(child) - parentCenter));
        }
        this.getState().mScrollDelta = -delta;
        this.fillCover(recycler, state, -delta);
        this.offsetChildrenVertical(delta);
        return -delta;
    }

    public OrientationHelper getOrientationHelper() {
        if (this.mOrientation == 0) {
            if (this.mHorizontalHelper == null) {
                this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this);
            }
            return this.mHorizontalHelper;
        }
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this);
        }
        return this.mVerticalHelper;
    }

    public void setItemTransformer(ItemTransformer itemTransformer) {
        this.mItemTransformer = itemTransformer;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    public void attach(RecyclerView recyclerView) {
        this.attach(recyclerView, -1);
    }

    public void attach(RecyclerView recyclerView, int selectedPosition) {
        if (recyclerView == null) {
            throw new IllegalArgumentException("The attach RecycleView must not null!!");
        }
        this.mRecyclerView = recyclerView;
        this.mInitialSelectedPosition = Math.max(0, selectedPosition);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this);
        this.mSnapHelper.attachToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mInnerScrollListener);
        RecyclerView.OnFlingListener onFlingListener = new RecyclerView.OnFlingListener(){

            public boolean onFling(int velocityX, int velocityY) {
                return false;
            }
        };
        recyclerView.setOnFlingListener(onFlingListener);
    }

    public void setCallbackInFling(boolean callbackInFling) {
        this.mCallbackInFling = callbackInFling;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        GallerySmoothScroller linearSmoothScroller = new GallerySmoothScroller(recyclerView.getContext());
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    private class GallerySmoothScroller
    extends LinearSmoothScroller {
        public GallerySmoothScroller(Context context) {
            super(context);
        }

        public int calculateDxToMakeCentral(View view) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager == null || !layoutManager.canScrollHorizontally()) {
                return 0;
            }
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
            int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
            int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
            int start = layoutManager.getPaddingLeft();
            int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
            int childCenter = left + (int)((float)(right - left) / 2.0f);
            int containerCenter = (int)((float)(end - start) / 2.0f);
            return containerCenter - childCenter;
        }

        public int calculateDyToMakeCentral(View view) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager == null || !layoutManager.canScrollVertically()) {
                return 0;
            }
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
            int top = layoutManager.getDecoratedTop(view) - params.topMargin;
            int bottom = layoutManager.getDecoratedBottom(view) + params.bottomMargin;
            int start = layoutManager.getPaddingTop();
            int end = layoutManager.getHeight() - layoutManager.getPaddingBottom();
            int childCenter = top + (int)((float)(bottom - top) / 2.0f);
            int containerCenter = (int)((float)(end - start) / 2.0f);
            return containerCenter - childCenter;
        }

        protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
            int dy;
            int dx = this.calculateDxToMakeCentral(targetView);
            int distance = (int)Math.sqrt(dx * dx + (dy = this.calculateDyToMakeCentral(targetView)) * dy);
            int time = this.calculateTimeForDeceleration(distance);
            if (time > 0) {
                action.update(-dx, -dy, time, (Interpolator)this.mDecelerateInterpolator);
            }
        }
    }

    private class InnerScrollListener
    extends RecyclerView.OnScrollListener {
        int mState;
        boolean mCallbackOnIdle;

        private InnerScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int selectedPosition;
            super.onScrolled(recyclerView, dx, dy);
            View snap = GalleryLayoutManager.this.mSnapHelper.findSnapView(recyclerView.getLayoutManager());
            if (snap != null && (selectedPosition = recyclerView.getLayoutManager().getPosition(snap)) != GalleryLayoutManager.this.mCurSelectedPosition) {
                if (GalleryLayoutManager.this.mCurSelectedView != null) {
                    GalleryLayoutManager.this.mCurSelectedView.setSelected(false);
                }
                GalleryLayoutManager.this.mCurSelectedView = snap;
                GalleryLayoutManager.this.mCurSelectedView.setSelected(true);
                GalleryLayoutManager.this.mCurSelectedPosition = selectedPosition;
                if (!GalleryLayoutManager.this.mCallbackInFling && this.mState != 0) {
                    this.mCallbackOnIdle = true;
                    return;
                }
                if (GalleryLayoutManager.this.mOnItemSelectedListener != null) {
                    GalleryLayoutManager.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.this.mCurSelectedPosition);
                }
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            this.mState = newState;
            if (this.mState == 0) {
                View snap = GalleryLayoutManager.this.mSnapHelper.findSnapView(recyclerView.getLayoutManager());
                if (snap != null) {
                    int selectedPosition = recyclerView.getLayoutManager().getPosition(snap);
                    if (selectedPosition != GalleryLayoutManager.this.mCurSelectedPosition) {
                        if (GalleryLayoutManager.this.mCurSelectedView != null) {
                            GalleryLayoutManager.this.mCurSelectedView.setSelected(false);
                        }
                        GalleryLayoutManager.this.mCurSelectedView = snap;
                        GalleryLayoutManager.this.mCurSelectedView.setSelected(true);
                        GalleryLayoutManager.this.mCurSelectedPosition = selectedPosition;
                        if (GalleryLayoutManager.this.mOnItemSelectedListener != null) {
                            GalleryLayoutManager.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.this.mCurSelectedPosition);
                        }
                    } else if (!GalleryLayoutManager.this.mCallbackInFling && GalleryLayoutManager.this.mOnItemSelectedListener != null && this.mCallbackOnIdle) {
                        this.mCallbackOnIdle = false;
                        GalleryLayoutManager.this.mOnItemSelectedListener.onItemSelected(recyclerView, snap, GalleryLayoutManager.this.mCurSelectedPosition);
                    }
                } else {
                    MLog.error((Object)GalleryLayoutManager.TAG, (String)"onScrollStateChanged: snap null", (Object[])new Object[0]);
                }
            }
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(RecyclerView var1, View var2, int var3);
    }

    public static interface ItemTransformer {
        public void transformItem(GalleryLayoutManager var1, View var2, float var3);
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }
    }

    class State {
        SparseArray<Rect> mItemsFrames = new SparseArray();
        int mScrollDelta = 0;
    }
}

