/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.ktv.bean;

import com.google.gson.annotations.SerializedName;
import net.ihago.ktv.api.biz.AudioPosition;

public final class KTVAudioPosition {
    @SerializedName(value="songId")
    private String songId = "";
    @SerializedName(value="audioTs")
    private long audioTs;
    @SerializedName(value="position")
    private int position;
    @SerializedName(value="totalDuration")
    private int totalDuration;

    private KTVAudioPosition(Builder builder) {
        this.songId = builder.songId;
        this.audioTs = builder.audioTs;
        this.position = builder.position;
        this.totalDuration = builder.totalDuration;
    }

    public String getSongId() {
        return this.songId;
    }

    public long getAudioTs() {
        return this.audioTs;
    }

    public int getPosition() {
        return this.position;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public void setKTVAudioPosition(AudioPosition audioPosition) {
        this.songId = audioPosition.song_id;
        this.audioTs = audioPosition.audio_ts;
        this.position = audioPosition.position;
        this.totalDuration = audioPosition.total_duration;
    }

    public static AudioPosition convertTo(KTVAudioPosition audioPosition) {
        return new AudioPosition.Builder().song_id(audioPosition.getSongId()).audio_ts(Long.valueOf(audioPosition.getAudioTs())).position(Integer.valueOf(audioPosition.getPosition())).total_duration(Integer.valueOf(audioPosition.getTotalDuration())).build();
    }

    public String toString() {
        return "KTVAudioPosition{songId='" + this.songId + '\'' + ", audioTs=" + this.audioTs + ", position=" + this.position + ", totalDuration=" + this.totalDuration + '}';
    }

    public static final class Builder {
        private String songId = "";
        private long audioTs;
        private int position;
        private int totalDuration;

        public Builder songId(String songId) {
            this.songId = songId;
            return this;
        }

        public Builder audioTs(long audioTs) {
            this.audioTs = audioTs;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder totalDuration(int totalDuration) {
            this.totalDuration = totalDuration;
            return this;
        }

        public KTVAudioPosition build() {
            return new KTVAudioPosition(this);
        }
    }
}

