/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.utils;

import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageReuseView;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.proto.ProtoManager;
import javax.annotation.Nullable;

public class ChannelUtils {
    public static int getMode(@Nullable GameInfo gameInfo) {
        if (gameInfo == null || FP.empty((CharSequence)gameInfo.gid)) {
            MLog.warn((Object)"ChannelUtils", (String)"getMode gameInfo is bull", (Object[])new Object[0]);
            return 1;
        }
        MLog.info((Object)"ChannelUtils", (String)"getMode gid: %s isOutterGame: %s", (Object[])new Object[]{gameInfo.gid, gameInfo.getIsOutterGame()});
        if (gameInfo.getIsOutterGame()) {
            return 400;
        }
        if (gameInfo.isRoomCheesGame()) {
            return 100;
        }
        if (gameInfo.isRoomAssistGame()) {
            return 300;
        }
        switch (gameInfo.gid) {
            case "ktv": {
                return 11;
            }
            case "micup": {
                return 12;
            }
            case "pickme": {
                return 13;
            }
            case "dayingjia": {
                return 101;
            }
            case "radio": {
                return 14;
            }
            case "chat": {
                return 10;
            }
            case "multivideo": {
                return 15;
            }
        }
        return 200;
    }

    public static boolean isGame(@Nullable GameInfo gameInfo) {
        if (gameInfo == null || FP.empty((CharSequence)gameInfo.gid)) {
            return false;
        }
        if (gameInfo.isRoomCheesGame()) {
            return true;
        }
        if (gameInfo.isRoomAssistGame()) {
            return true;
        }
        if (gameInfo.getIsOutterGame()) {
            return true;
        }
        switch (gameInfo.gid) {
            case "radio": 
            case "chat": 
            case "multivideo": 
            case "ktv": 
            case "micup": 
            case "pickme": {
                return false;
            }
            case "dayingjia": {
                return true;
            }
        }
        return true;
    }

    public static long getCurrentTime() {
        long dis = SystemClock.elapsedRealtime() - ProtoManager.getInstance().getClientRealTime();
        return ProtoManager.getInstance().getServiceTime() + dis;
    }

    public static void checkReuseViewType(Class clazz) {
        if (RuntimeContext.sIsDebuggable) {
            Class<?>[] is = clazz.getInterfaces();
            boolean hasInterface = false;
            for (Class<?> i : is) {
                if (!StringUtils.equal((String)i.getName(), (String)IPageReuseView.class.getName())) continue;
                hasInterface = true;
            }
            if (!hasInterface) {
                throw new IllegalStateException(String.format("reuse view error, class %s", clazz));
            }
        }
    }
}

