/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.publicscreen.msg;

import android.text.TextUtils;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.cbase.R;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;

public class ImageMsg
extends BaseImMsg {
    private String imageUrl;
    private int width;
    private int high;
    private float scale = 1.0f;
    public static final String kvo_dataChange = "dataChange";
    @KvoFieldAnnotation(name="dataChange")
    private Object dataChange;
    public static final String kvo_localPath = "localPath";
    @KvoFieldAnnotation(name="localPath")
    private String localPath;
    private String nanoUrl;
    private int urlFrom;
    private int emojiType;
    private boolean shareImage = false;

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return super.toString();
        }
        return "ImageMsg{imageUrl='" + this.imageUrl + '\'' + "width='" + this.width + '\'' + "high='" + this.high + '\'' + "scale='" + this.scale + '\'' + "localPath='" + this.localPath + '\'' + "dataChange='" + this.dataChange + '\'' + "super='" + super.toString() + '\'' + '}';
    }

    public ImageMsg(BaseImMsg msg) {
        super(msg);
    }

    public ImageMsg() {
    }

    public CharSequence getSessionTips() {
        if (this.isRevokeMsg()) {
            return super.getSessionTips();
        }
        return StringUtils.format((String)"%s: %s", (Object[])new Object[]{this.getNick(), ResourceUtils.getString((int)R.string.img_tag)});
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public Object getDataChange() {
        return this.dataChange;
    }

    public void setDataChange(Object dataChange) {
        this.setValue(kvo_dataChange, dataChange);
    }

    public void setLocalPath(String localPath) {
        this.setValue(kvo_localPath, localPath);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getNanoUrl() {
        return this.nanoUrl;
    }

    public void setNanoUrl(String nanoUrl) {
        this.nanoUrl = nanoUrl;
    }

    public int getUrlFrom() {
        return this.urlFrom;
    }

    public void setUrlFrom(int urlFrom) {
        this.urlFrom = urlFrom;
    }

    public void setEmojiType(int emojiType) {
        this.emojiType = emojiType;
    }

    public int getEmojiType() {
        return this.emojiType;
    }

    public boolean isShareImage() {
        return this.shareImage;
    }

    public void setShareImage(boolean shareImage) {
        this.shareImage = shareImage;
    }

    public boolean isGifWithFileName() {
        try {
            if (TextUtils.isEmpty((CharSequence)this.imageUrl)) {
                return false;
            }
            int index = this.imageUrl.lastIndexOf(".");
            String fileFormat = this.imageUrl.substring(index);
            return fileFormat.contains("gif");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isEmojiImage() {
        return this.emojiType == Config.EMOJI_TYPE_CUSTOM || this.isGifWithFileName();
    }

    public static class Config {
        public static int EMOJI_TYPE_NONE = 0;
        public static int EMOJI_TYPE_CUSTOM = 1;
        public int width;
        public int height;
        public String nanoUrl;
        public int from;
        public int emojiType;
    }
}

