/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.radio.beauty;

import android.content.Context;
import android.content.SharedPreferences;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.LocalEffectItemBDBean;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.BeautyIntensityConfig;
import com.yy.appbase.unifyconfig.config.BeautyIntensityConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.module.radio.beauty.IBeautyPresenter;
import com.yy.hiyo.channel.cbase.module.radio.beauty.IBeautyView;
import com.yy.hiyo.videoeffect.orangefilter.IOrangeFilterService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/yy/hiyo/channel/cbase/module/radio/beauty/BeautyPresenter;", "Lcom/yy/hiyo/channel/cbase/module/radio/beauty/IBeautyPresenter;", "beautyLevel", "", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "", "(ILcom/yy/appbase/callback/ICommonCallback;)V", "getBeautyLevel", "()I", "mBeautyView", "Lcom/yy/hiyo/channel/cbase/module/radio/beauty/IBeautyView;", "mLastBeautyIntensity", "mLastThinIntensity", "mOrganFilterService", "Lcom/yy/hiyo/videoeffect/orangefilter/IOrangeFilterService;", "connectOrangeFilter", "", "destroyOrangeFilter", "getBeautyIntensityConfig", "Lcom/yy/appbase/unifyconfig/config/BeautyIntensityConfigData;", "getBeautySp", "Landroid/content/SharedPreferences;", "initBeautyView", "setBaseBeautyIntensity", "setBeautyIntensity", "intensity", "needUpdate", "setBigEyeIntensity", "setFilterIntensity", "filePath", "", "setThinFaceIntensity", "setView", "iBeautyView", "cbase_release"})
public final class BeautyPresenter
implements IBeautyPresenter {
    private IBeautyView mBeautyView;
    private final IOrangeFilterService mOrganFilterService;
    private int mLastBeautyIntensity;
    private int mLastThinIntensity;
    private final int beautyLevel;

    @Override
    public void setBeautyIntensity(int intensity, boolean needUpdate) {
        if (needUpdate) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = this.getBeautySp();
            boolean instantly$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putInt("beautyIntensity", intensity);
            editor$iv.apply();
        }
        this.mOrganFilterService.setBeautyIntensity(intensity);
        RadioUtils.INSTANCE.reportBeautyParamChange("" + this.mLastBeautyIntensity + '$' + intensity);
        this.mLastBeautyIntensity = intensity;
    }

    @Override
    public void setBaseBeautyIntensity() {
        int beauty = this.getBeautyIntensityConfig().getBeautyIntensity();
        this.setBeautyIntensity(beauty, false);
    }

    @Override
    public void setThinFaceIntensity(int intensity, boolean needUpdate) {
        if (needUpdate) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = this.getBeautySp();
            boolean instantly$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putInt("thinFaceIntensity", intensity);
            editor$iv.apply();
        }
        this.mOrganFilterService.setBigEyeThinFaceIntensity(intensity);
        RadioUtils.INSTANCE.reportThinParamChange("" + this.mLastThinIntensity + '$' + intensity);
        this.mLastThinIntensity = intensity;
    }

    @Override
    public void setBigEyeIntensity(int intensity, boolean needUpdate) {
        if (needUpdate) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = this.getBeautySp();
            boolean instantly$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putInt("bigEyeIntensity", intensity);
            editor$iv.apply();
        }
    }

    private final SharedPreferences getBeautySp() {
        long mCurUid = AccountUtil.getUid();
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences(context, "radio_beauty" + mCurUid, 0);
    }

    @Override
    public void setView(@NotNull IBeautyView iBeautyView) {
        Intrinsics.checkParameterIsNotNull((Object)iBeautyView, (String)"iBeautyView");
        this.mBeautyView = iBeautyView;
        iBeautyView.setPresenter(this);
        this.initBeautyView();
    }

    private final void initBeautyView() {
        block0: {
            SharedPreferences historyData = this.getBeautySp();
            int beauty = historyData.getInt("beautyIntensity", 0);
            int thinFace = historyData.getInt("thinFaceIntensity", 0);
            int bigEye = historyData.getInt("bigEyeIntensity", 0);
            IBeautyView iBeautyView = this.mBeautyView;
            if (iBeautyView == null) break block0;
            iBeautyView.initBeauty(beauty, thinFace, bigEye);
        }
    }

    private final void setFilterIntensity(String filePath, int intensity) {
        MLog.info((Object)"BeautyPresenter", (String)("setFilterIntensity filePath=" + filePath + ", intensity=" + intensity), (Object[])new Object[0]);
        this.mOrganFilterService.useFilter(filePath);
        this.mOrganFilterService.setFilterIntensity(intensity);
    }

    @Override
    public void destroyOrangeFilter() {
        MLog.info((Object)"BeautyPresenter", (String)"destroyOrangeFilter", (Object[])new Object[0]);
        this.mOrganFilterService.destroyService();
    }

    @Override
    public void connectOrangeFilter() {
        SharedPreferences historyData = this.getBeautySp();
        int beauty = historyData.getInt("beautyIntensity", this.getBeautyIntensityConfig().getBeautyIntensity());
        int thinFace = historyData.getInt("thinFaceIntensity", this.getBeautyIntensityConfig().getThinFaceIntensity());
        this.setBeautyIntensity(beauty, true);
        this.setThinFaceIntensity(thinFace, true);
        if (historyData.contains("selectedFilter")) {
            int filterId = historyData.getInt("selectedFilter", -1);
            String filterPath = historyData.getString("selectedFilterPath", "");
            if (filterId != -1 && CommonExtensionsKt.isNotNullOrEmpty((String)filterPath)) {
                int filterIntensity = historyData.getInt("filterIntensity" + filterId, this.getBeautyIntensityConfig().getFilterIntensity());
                String string2 = filterPath;
                if (string2 == null) {
                    string2 = "";
                }
                this.setFilterIntensity(string2, filterIntensity);
            }
        } else {
            LocalEffectItemBDBean localEffectItemBDBean = this.mOrganFilterService.getDefaultFilter();
            if (localEffectItemBDBean != null) {
                LocalEffectItemBDBean localEffectItemBDBean2 = localEffectItemBDBean;
                boolean bl = false;
                boolean bl2 = false;
                LocalEffectItemBDBean filter = localEffectItemBDBean2;
                boolean bl3 = false;
                String filterFilePath = filter.unzipPath + '/' + this.mOrganFilterService.findFilterFile(filter.unzipPath);
                if (YYFileUtils.isFileExisted((String)filterFilePath)) {
                    SharedPreferences.Editor editor$iv;
                    int defaultIntensity = this.getBeautyIntensityConfig().getFilterIntensity();
                    this.setFilterIntensity(filterFilePath, defaultIntensity);
                    SharedPreferences $this$edit$iv = this.getBeautySp();
                    boolean instantly$iv = false;
                    boolean $i$f$edit = false;
                    SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
                    SharedPreferences.Editor $this$edit = editor;
                    boolean bl4 = false;
                    $this$edit.putInt("selectedFilter", filter.id);
                    $this$edit.putString("selectedFilterPath", filterFilePath);
                    $this$edit.putInt("filterIntensity" + filter.id, defaultIntensity);
                    editor$iv.apply();
                }
            }
        }
        this.mOrganFilterService.detectCameraPreviewBack();
    }

    private final BeautyIntensityConfigData getBeautyIntensityConfig() {
        BeautyIntensityConfig config;
        BeautyIntensityConfig beautyIntensityConfig;
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.BEAUTY_INTENSITY_CONFIG);
        if (!(aConfigData instanceof BeautyIntensityConfig)) {
            aConfigData = null;
        }
        if ((beautyIntensityConfig = (config = (BeautyIntensityConfig)aConfigData)) == null || (beautyIntensityConfig = beautyIntensityConfig.getData()) == null) {
            beautyIntensityConfig = BeautyIntensityConfigData.Companion.getDEFAULT();
        }
        return beautyIntensityConfig;
    }

    public final int getBeautyLevel() {
        return this.beautyLevel;
    }

    public BeautyPresenter(int beautyLevel, @Nullable ICommonCallback<Boolean> callback) {
        this.beautyLevel = beautyLevel;
        IService iService = ServiceManagerProxy.getService(IOrangeFilterService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026ilterService::class.java)");
        this.mOrganFilterService = (IOrangeFilterService)iService;
        this.mOrganFilterService.initService(this.beautyLevel, callback);
        MLog.info((Object)"BeautyPresenter", (String)"mOrganFilterService initService", (Object[])new Object[0]);
    }
}

