/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.ktv.bean;

import androidx.annotation.NonNull;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVDef;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoleInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;

public final class KTVRoomData
extends KvoSource {
    private KTVRoomSongInfo mCurrentSongInfo = new KTVRoomSongInfo.Builder().build();
    private String mRoomId;
    public static final String kvo_mPolicy = "mPolicy";
    @KvoFieldAnnotation(name="mPolicy")
    @KTVDef.KTVROLE
    private int mPolicy;
    private KTVRoleInfo mRoleInfo = new KTVRoleInfo();

    public void setKTVRoomData(KTVRoomSongInfo songInfo, String roomId) {
        this.mRoomId = roomId;
        if (songInfo == null) {
            this.setCurrentSongInfo("", 0L, "", "", "", "", "", -1, "", "", "");
        } else {
            this.setCurrentSongInfo(songInfo.getResourceId(), songInfo.getUid(), songInfo.getNick() == null ? "" : songInfo.getNick(), songInfo.getAvatar() == null ? "" : songInfo.getAvatar(), songInfo.getSongName() == null ? "" : songInfo.getSongName(), songInfo.getOriginalSinger() == null ? "" : songInfo.getOriginalSinger(), songInfo.getSongId(), songInfo.getStatus(), songInfo.getComposer() == null ? "" : songInfo.getComposer(), songInfo.getSongWriter() == null ? "" : songInfo.getSongWriter(), songInfo.getCoverImageUrl() == null ? "" : songInfo.getCoverImageUrl());
            FeatureLog.i((String)"FTKTVRoomService", (String)"current song info: %s", (Object[])new Object[]{songInfo.toString()});
        }
    }

    private void setCurrentSongInfo(String resourceId, long uid, String nick, String avatar, String songName, String originalSinger, String songId, int status, String composer, String songWriter, String coverImageUrl) {
        this.mCurrentSongInfo.setResourceId(resourceId);
        this.mCurrentSongInfo.setUid(uid);
        this.mCurrentSongInfo.setNick(nick);
        this.mCurrentSongInfo.setAvatar(avatar);
        this.mCurrentSongInfo.setCoverImageUrl(coverImageUrl);
        this.mCurrentSongInfo.setSongName(songName);
        this.mCurrentSongInfo.setOriginalSinger(originalSinger);
        this.mCurrentSongInfo.setSongId(songId);
        this.mCurrentSongInfo.setComposer(composer);
        this.mCurrentSongInfo.setSongWriter(songWriter);
        this.mCurrentSongInfo.setStatus(status);
    }

    public KTVRoomSongInfo getCurrentSongInfo() {
        return this.mCurrentSongInfo;
    }

    public String getRoomId() {
        return this.mRoomId;
    }

    public void setSelectSongPolicy(int songPolicy) {
        int policy = this.mPolicy & 0xFFFFFFFC | songPolicy;
        this.setPolicy(policy);
    }

    public int getSelectSongPolicy() {
        return this.mPolicy & 3;
    }

    public static int getSelectSongPolicy(int policy) {
        return policy & 3;
    }

    private void setPolicy(int policy) {
        this.setValue(kvo_mPolicy, policy);
    }

    @NonNull
    public KTVRoleInfo getRoleInfo() {
        return this.mRoleInfo;
    }

    public void isInSeat(boolean inSeat) {
        if (inSeat) {
            this.mRoleInfo.setSelectSongPolicy(1);
        } else {
            this.mRoleInfo.setSelectSongPolicy(0);
        }
    }

    public void isOwnerOrMaster(int roleType, boolean isAnchor) {
        boolean ownerOrMaster;
        boolean bl = ownerOrMaster = roleType == 10 || roleType == 15;
        if (ownerOrMaster || isAnchor) {
            this.mRoleInfo.setCloseKTVPolicy(1);
        } else {
            this.mRoleInfo.setCloseKTVPolicy(0);
        }
    }

    public void enablePauseOrCutSong(boolean enable) {
        if (enable) {
            this.mRoleInfo.setPauseSongPolicy(1);
            this.mRoleInfo.setCutSongPolicy(1);
        } else {
            this.mRoleInfo.setPauseSongPolicy(0);
            this.mRoleInfo.setCutSongPolicy(0);
        }
    }

    public boolean hasSkipSongPolicy() {
        return this.mRoleInfo.getCutSongPolicy() == 1;
    }

    public boolean hasCloseKTVPolicy() {
        return this.mRoleInfo.getCloseKTVPolicy() == 1;
    }
}

