/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.common;

import android.content.SharedPreferences;
import android.os.Build;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RadioLiveConfig;
import com.yy.appbase.unifyconfig.config.RadioLiveConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.bean.LiveCodeRate;
import com.yy.hiyo.channel.base.bean.LiveCodeRateKt;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IKtvVideoService;
import com.yy.hiyo.voice.base.channelvoice.LiveConstansUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\b\u0010$\u001a\u00020\u0016H\u0002J\u0006\u0010%\u001a\u00020\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/yy/hiyo/channel/cbase/module/common/AnchorQualityManager;", "", "()V", "TAG", "", "anchorBitRate", "getAnchorBitRate", "()Ljava/lang/String;", "setAnchorBitRate", "(Ljava/lang/String;)V", "anchorFrameRate", "getAnchorFrameRate", "setAnchorFrameRate", "anchorResoultion", "getAnchorResoultion", "setAnchorResoultion", "currSupportCodeRateList", "", "Lcom/yy/hiyo/channel/base/bean/LiveCodeRate;", "unSupportArGiftMap", "", "", "", "getUnSupportArGiftMap", "()Ljava/util/Map;", "setUnSupportArGiftMap", "(Ljava/util/Map;)V", "canSwitchQuality", "getConfigData", "Lcom/yy/appbase/unifyconfig/config/RadioLiveConfigData;", "getDefaultQuality", "", "getLastAnchorQuality", "getNextLowCurCodeRate", "cur", "getSupportHighetQuality", "isHardCodeQualitySwitch", "isSupportHighQuality", "updateOldQuality", "quality", "updateSupportCodeRateList", "", "codeRateList", "", "cbase_release"})
public final class AnchorQualityManager {
    @NotNull
    public static final String TAG = "AnchorQualityManager";
    private static final List<LiveCodeRate> currSupportCodeRateList;
    @NotNull
    private static Map<Long, Boolean> unSupportArGiftMap;
    @NotNull
    private static String anchorResoultion;
    @NotNull
    private static String anchorBitRate;
    @NotNull
    private static String anchorFrameRate;
    public static final AnchorQualityManager INSTANCE;

    @NotNull
    public final Map<Long, Boolean> getUnSupportArGiftMap() {
        return unSupportArGiftMap;
    }

    public final void setUnSupportArGiftMap(@NotNull Map<Long, Boolean> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        unSupportArGiftMap = map;
    }

    @NotNull
    public final String getAnchorResoultion() {
        return anchorResoultion;
    }

    public final void setAnchorResoultion(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        anchorResoultion = string2;
    }

    @NotNull
    public final String getAnchorBitRate() {
        return anchorBitRate;
    }

    public final void setAnchorBitRate(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        anchorBitRate = string2;
    }

    @NotNull
    public final String getAnchorFrameRate() {
        return anchorFrameRate;
    }

    public final void setAnchorFrameRate(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        anchorFrameRate = string2;
    }

    public final void updateSupportCodeRateList(@NotNull List<LiveCodeRate> codeRateList) {
        Object v0;
        boolean bl;
        Iterable iterable;
        block2: {
            Intrinsics.checkParameterIsNotNull(codeRateList, (String)"codeRateList");
            MLog.info((Object)TAG, (String)("updateSupportCodeRateList, size=" + codeRateList.size()), (Object[])new Object[0]);
            CommonExtensionsKt.logList((String)TAG, (String)"current code rates: ", codeRateList);
            MLog.info((Object)TAG, (String)"devices model:%s", (Object[])new Object[]{Build.MODEL});
            currSupportCodeRateList.clear();
            currSupportCodeRateList.addAll((Collection<LiveCodeRate>)codeRateList);
            Iterable iterable2 = currSupportCodeRateList;
            boolean bl2 = false;
            iterable = iterable2;
            bl = false;
            for (Object t : iterable) {
                LiveCodeRate it = (LiveCodeRate)t;
                boolean bl3 = false;
                if (!(it.getCodeRate() == 5)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LiveCodeRate find = v0;
        boolean showEnvSetting = SystemUtils.isShowEnvSetting();
        boolean use720P = SettingFlags.getBoolean((String)"key_use_720p", (boolean)false);
        MLog.info((Object)TAG, (String)("updateSupportCodeRateList find:" + find + ", showEnvSetting:" + showEnvSetting + ", use720P:" + use720P), (Object[])new Object[0]);
        if (showEnvSetting && find == null && use720P) {
            iterable = new LiveCodeRate();
            List<LiveCodeRate> list = currSupportCodeRateList;
            bl = false;
            boolean bl4 = false;
            Iterable $this$apply = iterable;
            boolean bl5 = false;
            $this$apply.setCodeRate(5);
            Iterable iterable3 = iterable;
            list.add((LiveCodeRate)iterable3);
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).setLowerCodeRateFetcher(new IKtvVideoService.LowerCodeRateFetcher(){

            public int getLowerCodeRate(int cur) {
                return AnchorQualityManager.INSTANCE.getNextLowCurCodeRate(cur);
            }
        });
    }

    private final RadioLiveConfigData getConfigData() {
        RadioLiveConfig config;
        RadioLiveConfig radioLiveConfig;
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.RADIO_LIVE_CONFIG);
        if (!(aConfigData instanceof RadioLiveConfig)) {
            aConfigData = null;
        }
        if ((radioLiveConfig = (config = (RadioLiveConfig)aConfigData)) == null || (radioLiveConfig = radioLiveConfig.getData()) == null) {
            radioLiveConfig = RadioLiveConfigData.Companion.getDEFAULT();
        }
        return radioLiveConfig;
    }

    public final boolean isSupportHighQuality() {
        Iterable $this$forEach$iv = currSupportCodeRateList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LiveCodeRate it = (LiveCodeRate)element$iv;
            boolean bl = false;
            if (it.getCodeRate() < 4 && it.getCodeRate() < 5) continue;
            return true;
        }
        return false;
    }

    public final int getSupportHighetQuality() {
        int highestQuality = -1;
        Iterable $this$forEach$iv = currSupportCodeRateList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LiveCodeRate it = (LiveCodeRate)element$iv;
            boolean bl = false;
            if (it.getCodeRate() <= highestQuality || it.getCodeRate() > 5) continue;
            highestQuality = it.getCodeRate();
        }
        return highestQuality;
    }

    public final boolean canSwitchQuality() {
        return this.isHardCodeQualitySwitch() || this.isSupportHighQuality() && this.getConfigData().getAnchorCanSwitchQuality();
    }

    public final int getDefaultQuality() {
        RadioLiveConfigData configData = this.getConfigData();
        return this.isSupportHighQuality() && configData.getAnchorDefaultQuality() == 2 ? this.getSupportHighetQuality() : LiveCodeRateKt.getStandardQuality();
    }

    private final boolean isHardCodeQualitySwitch() {
        return SettingFlags.getBoolean((String)"hard_code_live_quality_switch", (boolean)false);
    }

    public final int getLastAnchorQuality() {
        int quality = LiveConstansUtil.INSTANCE.getRadioVideoSp().getInt("anchor_last_quality", this.getDefaultQuality());
        quality = this.updateOldQuality(quality);
        return quality;
    }

    private final int updateOldQuality(int quality) {
        int newQuality = quality;
        if (quality == 1) {
            SharedPreferences.Editor editor$iv;
            newQuality = LiveCodeRateKt.getStandardQuality();
            SharedPreferences $this$edit$iv = LiveConstansUtil.INSTANCE.getRadioVideoSp();
            boolean instantly$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putInt("anchor_last_quality", newQuality);
            editor$iv.apply();
        } else if (quality == 2) {
            SharedPreferences.Editor editor$iv;
            newQuality = this.getSupportHighetQuality();
            SharedPreferences $this$edit$iv = LiveConstansUtil.INSTANCE.getRadioVideoSp();
            boolean instantly$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putInt("anchor_last_quality", newQuality);
            editor$iv.apply();
        }
        return newQuality;
    }

    public final int getNextLowCurCodeRate(int cur) {
        int nextCodeRate = -1;
        Iterable $this$forEach$iv = currSupportCodeRateList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LiveCodeRate it = (LiveCodeRate)element$iv;
            boolean bl = false;
            int n = it.getCodeRate();
            if (nextCodeRate > n || cur <= n) continue;
            nextCodeRate = it.getCodeRate();
        }
        return nextCodeRate;
    }

    private AnchorQualityManager() {
    }

    static {
        AnchorQualityManager anchorQualityManager;
        INSTANCE = anchorQualityManager = new AnchorQualityManager();
        boolean bl = false;
        currSupportCodeRateList = new ArrayList();
        bl = false;
        unSupportArGiftMap = new LinkedHashMap();
        anchorResoultion = "";
        anchorBitRate = "";
        anchorFrameRate = "";
    }
}

