/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.context.pagelifecycle;

import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeDispatcher;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PageLifeDispatcher
implements IPageLifeDispatcher {
    private static String TAG = "PageLifeDispatcher";
    private List<IPageLifeCycle> mLifeListeners = new CopyOnWriteArrayList<IPageLifeCycle>();
    private boolean attached = false;

    public PageLifeDispatcher(String channelId) {
        TAG = "PageLifeDispatcher " + channelId + " ";
    }

    public void updateChannelId(String channelId) {
        TAG = TAG + " " + channelId;
    }

    @Override
    public synchronized void addLifeListener(IPageLifeCycle life) {
        MLog.info((Object)TAG, (String)"addLifeListener %s", (Object[])new Object[]{life});
        if (!this.mLifeListeners.contains(life) && life != null) {
            this.mLifeListeners.add(life);
        }
    }

    @Override
    public synchronized void removeLifeListener(IPageLifeCycle life) {
        MLog.info((Object)TAG, (String)"removeLifeListener %s", (Object[])new Object[]{life});
        if (life != null) {
            this.mLifeListeners.remove(life);
        }
    }

    @Override
    public synchronized void onPageDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy!", (Object[])new Object[0]);
        if (this.attached) {
            this.onDetach();
        }
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.onPageDestroy();
        }
        this.mLifeListeners.clear();
    }

    @Override
    public synchronized void onAttach() {
        MLog.info((Object)TAG, (String)"onAttach!", (Object[])new Object[0]);
        if (!this.attached) {
            this.attached = true;
            for (IPageLifeCycle item : this.mLifeListeners) {
                item.onAttach();
            }
        }
    }

    @Override
    public synchronized void onDetach() {
        MLog.info((Object)TAG, (String)"onDetach!", (Object[])new Object[0]);
        if (this.attached) {
            this.attached = false;
            for (IPageLifeCycle item : this.mLifeListeners) {
                item.onDetach();
            }
        }
    }

    @Override
    public synchronized void beforeShow() {
        MLog.info((Object)TAG, (String)"beforeShow!", (Object[])new Object[0]);
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.beforeShow();
        }
    }

    @Override
    public synchronized void onShown() {
        MLog.info((Object)TAG, (String)"onShown!", (Object[])new Object[0]);
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.onShown();
        }
    }

    @Override
    public synchronized void beforeHide() {
        MLog.info((Object)TAG, (String)"beforeHide!", (Object[])new Object[0]);
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.beforeHide();
        }
    }

    @Override
    public synchronized void onHidden() {
        MLog.info((Object)TAG, (String)"onHidden!", (Object[])new Object[0]);
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.onHidden();
        }
    }

    @Override
    public synchronized void onPreMinimize() {
        MLog.info((Object)TAG, (String)"onPreMinimize", (Object[])new Object[0]);
        for (IPageLifeCycle item : this.mLifeListeners) {
            item.onPreMinimize();
        }
    }
}

