/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.context;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPresenter;
import com.yy.hiyo.mvp.base.IMvp;
import com.yy.hiyo.mvp.base.PresenterProvider;
import java.util.HashMap;

public class ChannelPagePresenterLifeDispatcher {
    private static final String TAG = "FTVoiceRoom CPPLD";
    private AttachStatus mAttachStatus = AttachStatus.UNKNOWN;
    private AbsPage mPage;
    private PresenterProvider mPresenterProvider;
    private HashMap<IChannelPresenter, AttachStatus> mAttachedInfo = new HashMap();
    private String thisStr = super.toString();

    public ChannelPagePresenterLifeDispatcher() {
        MLog.info((Object)TAG, (String)"new %s", (Object[])new Object[]{this});
    }

    void setPresenterProvider(PresenterProvider provider) {
        this.mPresenterProvider = provider;
        provider.addCreateListener(presenter -> {
            if (presenter instanceof IChannelPresenter) {
                this.onPresenterCreated((IChannelPresenter)presenter);
            }
        });
    }

    void onPageDetach(AbsPage page) {
        MLog.info((Object)TAG, (String)"onPageDetach %s, from %s", (Object[])new Object[]{this, this.mAttachStatus});
        if (this.mAttachStatus != AttachStatus.DETACH) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"onPageDetach %s", (Object[])new Object[]{page});
            }
            this.mAttachStatus = AttachStatus.DETACH;
            for (IMvp.IPresenter item : this.mPresenterProvider.getAll()) {
                if (!(item instanceof IChannelPresenter)) continue;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)TAG, (String)"onPageDetach presenter %s, AttachStatus %s", (Object[])new Object[]{item, this.mAttachStatus});
                }
                this.mAttachedInfo.put((IChannelPresenter)item, AttachStatus.DETACH);
                ((IChannelPresenter)item).onPageDetach(page);
            }
        }
    }

    public void onPageAttach(AbsPage page) {
        MLog.info((Object)TAG, (String)"onPageAttach %s, from %s", (Object[])new Object[]{this, this.mAttachStatus});
        if (this.mAttachStatus != AttachStatus.ATTACHED) {
            MLog.info((Object)TAG, (String)"onPageAttach %s", (Object[])new Object[]{page});
            this.mPage = page;
            this.mAttachStatus = AttachStatus.ATTACHED;
            for (IMvp.IPresenter item : this.mPresenterProvider.getAll()) {
                if (!(item instanceof IChannelPresenter)) continue;
                this.notifyAttach((IChannelPresenter)item);
            }
        }
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy %s", (Object[])new Object[]{this});
        this.mAttachedInfo.clear();
    }

    private void notifyAttach(IChannelPresenter presenter) {
        MLog.debug((Object)TAG, (String)"notifyAttach presenter %s, AttachStatus %s", (Object[])new Object[]{presenter, this.mAttachStatus});
        if (this.mPage != null) {
            boolean isFirstInit = this.mAttachedInfo.get(presenter) == null;
            this.mAttachedInfo.put(presenter, AttachStatus.ATTACHED);
            presenter.onPageAttach(this.mPage, !isFirstInit);
        }
    }

    private void onPresenterCreated(IChannelPresenter presenter) {
        if (this.mPage != null) {
            this.notifyAttach(presenter);
        }
    }

    public String toString() {
        return this.thisStr;
    }

    private static enum AttachStatus {
        ATTACHED,
        DETACH,
        UNKNOWN;

    }
}

