/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.drawerlayout.widget.DrawerLayout;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.banner.BannerScroller;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.WindowSwipeHelper;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.view.BeautyFuzzyView;
import com.yy.hiyo.channel.cbase.view.CoverTransformer;
import com.yy.hiyo.channel.cbase.view.SlidingPagerAdapter;
import com.yy.hiyo.channel.cbase.view.VerticalSlidingLayout;
import java.util.ArrayList;

public abstract class AbsChannelDrawerWindow
extends AbsChannelWindow {
    public DrawerLayout mDrawerLayout;
    @NonNull
    private YYPlaceHolderView rightContainer;
    private VerticalSlidingLayout mSlidingLayout;
    private BeautyFuzzyView mPreFuzzyView;
    private BeautyFuzzyView mNextFuzzyView;
    private BeautyFuzzyView mCurFuzzyView;
    private final DrawerLayout.SimpleDrawerListener mDrawerListener = new DrawerLayout.SimpleDrawerListener(){

        public void onDrawerSlide(View drawerView, float slideOffset) {
            super.onDrawerSlide(drawerView, slideOffset);
            View mainPage = AbsChannelDrawerWindow.this.mDrawerLayout.getChildAt(0);
            if (mainPage != null && mainPage != drawerView) {
                float translationX = (float)(-drawerView.getWidth()) * slideOffset;
                if (LanguageUtils.isRtl()) {
                    translationX = -translationX;
                }
                mainPage.setTranslationX(translationX);
                mainPage.invalidate();
            }
        }
    };

    public AbsChannelDrawerWindow(Context context, UICallBacks callBacks, String name, boolean slide) {
        super(context, callBacks, name);
        this.createDrawerLayout();
        if (slide) {
            this.createSlidingLayout();
            this.getBaseLayer().addView((View)this.mSlidingLayout);
            this.initViewPagerScroll();
            this.setSlidingPager();
        } else {
            this.getBaseLayer().addView((View)this.mDrawerLayout);
        }
        this.rightContainer = new YYPlaceHolderView(context);
    }

    @Override
    public void setMainPage(AbsPage absPage) {
        View mainPage = absPage.getPageView();
        if (mainPage.getParent() == null) {
            DrawerLayout.LayoutParams params = new DrawerLayout.LayoutParams(-1, -1);
            this.mDrawerLayout.addView(mainPage, 0, (ViewGroup.LayoutParams)params);
        }
    }

    public void setRightPanel() {
        YYPlaceHolderView drawerPage;
        if (this.rightContainer != null && !this.rightContainer.isInflated() && (drawerPage = this.rightContainer).getParent() == null) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext);
            DrawerLayout.LayoutParams lp = new DrawerLayout.LayoutParams((int)((double)screenWidth * 0.73), -1);
            lp.gravity = 0x800005;
            this.mDrawerLayout.addView((View)drawerPage, (ViewGroup.LayoutParams)lp);
        }
    }

    public YYPlaceHolderView getRightContainer() {
        return this.rightContainer;
    }

    public DrawerLayout getDrawerLayout() {
        return this.mDrawerLayout;
    }

    public VerticalSlidingLayout getSlidingLayout() {
        return this.mSlidingLayout;
    }

    public void resetView(IResetCallback resetCallback) {
        MLog.info((Object)"AbstractWindow", (String)"resetView", (Object[])new Object[0]);
        SlidingPagerAdapter adapter = new SlidingPagerAdapter();
        this.mPreFuzzyView = new BeautyFuzzyView(this.getContext());
        this.mNextFuzzyView = new BeautyFuzzyView(this.getContext());
        this.mCurFuzzyView = new BeautyFuzzyView(this.getContext());
        ArrayList<BeautyFuzzyView> list = new ArrayList<BeautyFuzzyView>(3);
        list.add(this.mPreFuzzyView);
        list.add(this.mCurFuzzyView);
        list.add(this.mNextFuzzyView);
        adapter.setData(list);
        this.mSlidingLayout.setOffscreenPageLimit(4);
        this.mSlidingLayout.setAdapter(adapter);
        this.mSlidingLayout.setCurrentItem(1);
        resetCallback.updateView(this.mPreFuzzyView, this.mCurFuzzyView, this.mNextFuzzyView);
    }

    private void createSlidingLayout() {
        this.mSlidingLayout = new VerticalSlidingLayout(this.getContext());
    }

    protected void setCoverSlidingMode(boolean coverMode) {
        if (this.mSlidingLayout != null && NAB.B.equals((Object)NewABDefine.LIVE_TRANSFORM_TEST.getTest())) {
            this.mSlidingLayout.setPageTransformer(false, coverMode ? new CoverTransformer() : null, 0);
        }
    }

    private void setSlidingPager() {
        SlidingPagerAdapter adapter = new SlidingPagerAdapter();
        this.mPreFuzzyView = new BeautyFuzzyView(this.getContext());
        this.mNextFuzzyView = new BeautyFuzzyView(this.getContext());
        ArrayList<BeautyFuzzyView> list = new ArrayList<BeautyFuzzyView>(3);
        list.add(this.mPreFuzzyView);
        list.add((BeautyFuzzyView)this.mDrawerLayout);
        list.add(this.mNextFuzzyView);
        adapter.setData(list);
        this.mSlidingLayout.setOffscreenPageLimit(4);
        this.mSlidingLayout.setAdapter(adapter);
        this.mSlidingLayout.setCurrentItem(1);
        this.mSlidingLayout.setOverScrollMode(2);
    }

    private void initViewPagerScroll() {
        BannerScroller scroller = new BannerScroller(this.getContext());
        scroller.setDuration(200);
        this.mSlidingLayout.setScroller((Scroller)scroller);
    }

    public BeautyFuzzyView getPreFuzzyView() {
        return this.mPreFuzzyView;
    }

    public BeautyFuzzyView getNextFuzzyView() {
        return this.mNextFuzzyView;
    }

    private void createDrawerLayout() {
        if (this.mDrawerLayout == null) {
            this.mDrawerLayout = new InnerDrawerLayout(this.getContext());
            this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.mDrawerListener);
        }
    }

    public boolean onBackKeyEvent() {
        if (this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(0x800005)) {
            this.mDrawerLayout.closeDrawer(0x800005);
            return true;
        }
        return false;
    }

    private class InnerDrawerLayout
    extends DrawerLayout
    implements WindowSwipeHelper.IScrollable {
        public InnerDrawerLayout(Context context) {
            super(context);
        }

        public InnerDrawerLayout(@Nullable Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public InnerDrawerLayout(@Nullable Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public boolean isLeftEdge() {
            return !this.isDrawerOpen(0x800005);
        }
    }

    public static interface IResetCallback {
        public void updateView(BeautyFuzzyView var1, BeautyFuzzyView var2, BeautyFuzzyView var3);
    }
}

