/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch.ImageViewTouch;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch.ImageViewTouchBase;
import java.util.ArrayList;
import java.util.List;

public class PreviewAdapter
extends PagerAdapter {
    private ArrayList<Item> mItems = new ArrayList();
    private Context mContext;

    public PreviewAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.mItems.size();
    }

    public View instantiateItem(ViewGroup container, int position) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.album_preview_item, null);
        container.addView(view, -1, -1);
        this.handle(view, this.mItems.get(position));
        return view;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }

    public Item getMediaItem(int position) {
        return this.mItems.get(position);
    }

    public void addAll(List<Item> items) {
        this.mItems.addAll(items);
    }

    public void resetView(ViewGroup container, int position) {
        View view = this.instantiateItem(container, position);
        ((ImageViewTouch)view.findViewById(R.id.image_view)).resetMatrix();
    }

    private void handle(View view, Item item) {
        View videoPlayButton = view.findViewById(R.id.video_play_button);
        if (item.isVideo()) {
            videoPlayButton.setVisibility(0);
            videoPlayButton.setOnClickListener(v -> {});
        } else {
            videoPlayButton.setVisibility(8);
        }
        ImageViewTouch image = (ImageViewTouch)view.findViewById(R.id.image_view);
        image.setDisplayType(ImageViewTouchBase.DisplayType.FIT_TO_SCREEN);
        image.setSingleTapListener(() -> {});
        if (item.isGif()) {
            SelectionSpec.getInstance().imageEngine.loadGifImage(this.mContext, image, item.getContentUri());
        } else {
            SelectionSpec.getInstance().imageEngine.loadImage(this.mContext, image, item.getContentUri());
        }
    }
}

