/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.loader;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.LongSparseArray;
import androidx.loader.content.CursorLoader;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import java.util.HashSet;

public class AlbumLoader
extends CursorLoader {
    public static final String COLUMN_COUNT = "count";
    public static final String COLUMN_URI = "uri";
    static final String COLUMN_BUCKET_ID = "bucket_id";
    static final String COLUMN_BUCKET_DISPLAY_NAME = "bucket_display_name";
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String[] COLUMNS = new String[]{"_id", "bucket_id", "bucket_display_name", "uri", "count"};
    private static final String[] PROJECTION = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type"};
    private static final String SELECTION = "(media_type=? OR media_type=?) AND _size>0";
    private static final String[] SELECTION_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private static final String SELECTION_FOR_SINGLE_MEDIA_TYPE = "media_type=? AND _size>0";
    static final String BUCKET_ORDER_BY = "date_modified DESC";

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    private AlbumLoader(Context context, String selection, String[] selectionArgs) {
        super(context, QUERY_URI, PROJECTION, selection, selectionArgs, BUCKET_ORDER_BY);
    }

    public static CursorLoader newInstance(Context context) {
        String[] selectionArgs;
        String selection;
        if (SelectionSpec.getInstance().onlyShowImages()) {
            selection = SELECTION_FOR_SINGLE_MEDIA_TYPE;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(1);
        } else if (SelectionSpec.getInstance().onlyShowVideos()) {
            selection = SELECTION_FOR_SINGLE_MEDIA_TYPE;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(3);
        } else {
            selection = SELECTION;
            selectionArgs = SELECTION_ARGS;
        }
        return new AlbumLoader(context, selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor loadInBackground() {
        try (Cursor albums = null;){
            albums = super.loadInBackground();
            MatrixCursor allAlbum = new MatrixCursor(COLUMNS);
            int totalCount = 0;
            Uri allAlbumCoverUri = null;
            LongSparseArray countMap = new LongSparseArray();
            if (albums != null) {
                while (albums.moveToNext()) {
                    long bucketId = albums.getLong(albums.getColumnIndex(COLUMN_BUCKET_ID));
                    Long count = (Long)countMap.get(bucketId);
                    count = count == null ? 1L : count + 1L;
                    countMap.put(bucketId, (Object)count);
                }
            }
            MatrixCursor newAlbums = new MatrixCursor(COLUMNS);
            if (albums != null && albums.moveToFirst()) {
                allAlbumCoverUri = AlbumLoader.getUri(albums);
                HashSet<Long> done = new HashSet<Long>();
                do {
                    long bucketId;
                    if (done.contains(bucketId = albums.getLong(albums.getColumnIndex(COLUMN_BUCKET_ID)))) continue;
                    long fileId = albums.getLong(albums.getColumnIndex("_id"));
                    String bucketDisplayName = albums.getString(albums.getColumnIndex(COLUMN_BUCKET_DISPLAY_NAME));
                    Uri uri = AlbumLoader.getUri(albums);
                    long count = (Long)countMap.get(bucketId);
                    newAlbums.addRow((Object[])new String[]{Long.toString(fileId), Long.toString(bucketId), bucketDisplayName, uri.toString(), String.valueOf(count)});
                    done.add(bucketId);
                    totalCount = (int)((long)totalCount + count);
                } while (albums.moveToNext());
            }
            allAlbum.addRow((Object[])new String[]{Album.ALBUM_ID_ALL, Album.ALBUM_ID_ALL, "All", allAlbumCoverUri == null ? null : allAlbumCoverUri.toString(), String.valueOf(totalCount)});
            MergeCursor mergeCursor = new MergeCursor(new Cursor[]{allAlbum, newAlbums});
            return mergeCursor;
        }
    }

    private static Uri getUri(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndex("_id"));
        String mimeType = cursor.getString(cursor.getColumnIndex("mime_type"));
        Uri contentUri = AlbumLoader.isImage(mimeType) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (AlbumLoader.isVideo(mimeType) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : QUERY_URI);
        return ContentUris.withAppendedId((Uri)contentUri, (long)id2);
    }

    public static boolean isImage(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public static boolean isVideo(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("video");
    }

    public void onContentChanged() {
    }
}

