/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.collection.ArraySet;
import com.yy.base.utils.YYImageUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public enum MimeType {
    JPEG("image/jpeg", MimeType.arraySetOf("jpg", "jpeg")),
    PNG("image/png", MimeType.arraySetOf("png")),
    GIF("image/gif", MimeType.arraySetOf("gif")),
    BMP("image/x-ms-bmp", MimeType.arraySetOf("bmp")),
    WEBP("image/webp", MimeType.arraySetOf("webp")),
    HEIF("image/heif", MimeType.arraySetOf("heif", "heic")),
    MP4("video/mp4", MimeType.arraySetOf("mp4", "m4v"));

    private final String mMimeTypeName;
    private final Set<String> mExtensions;

    private MimeType(String mimeTypeName, Set<String> extensions) {
        this.mMimeTypeName = mimeTypeName;
        this.mExtensions = extensions;
    }

    public static Set<MimeType> ofAll() {
        return EnumSet.allOf(MimeType.class);
    }

    public static Set<MimeType> of(MimeType type, MimeType ... rest) {
        return EnumSet.of(type, rest);
    }

    public static Set<MimeType> ofImage() {
        if (Build.VERSION.SDK_INT >= 28) {
            return EnumSet.of(JPEG, new MimeType[]{PNG, GIF, BMP, WEBP, HEIF});
        }
        return EnumSet.of(JPEG, PNG, GIF, BMP, WEBP);
    }

    public static Set<MimeType> ofImageExclusiveGif() {
        if (Build.VERSION.SDK_INT >= 28) {
            return EnumSet.of(JPEG, PNG, BMP, WEBP, HEIF);
        }
        return EnumSet.of(JPEG, PNG, BMP, WEBP);
    }

    public static Set<MimeType> ofExclusiveGif() {
        EnumSet<MimeType> all = EnumSet.allOf(MimeType.class);
        all.remove((Object)GIF);
        return all;
    }

    public static Set<MimeType> ofVideo() {
        return EnumSet.of(MP4);
    }

    public static boolean isImage(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public static boolean isVideo(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.startsWith("video");
    }

    public static boolean isGif(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals(GIF.toString());
    }

    private static Set<String> arraySetOf(String ... suffixes) {
        return new ArraySet(Arrays.asList(suffixes));
    }

    public String toString() {
        return this.mMimeTypeName;
    }

    public boolean checkType(ContentResolver resolver, Uri uri) {
        MimeTypeMap map = MimeTypeMap.getSingleton();
        if (uri == null) {
            return false;
        }
        String type = map.getExtensionFromMimeType(resolver.getType(uri));
        String path = null;
        boolean pathParsed = false;
        for (String extension : this.mExtensions) {
            if (extension.equals(type)) {
                return true;
            }
            if (!pathParsed) {
                path = YYImageUtils.getPath((ContentResolver)resolver, (Uri)uri);
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    path = path.toLowerCase(Locale.US);
                }
                pathParsed = true;
            }
            if (path == null || !path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

