/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.ablum;

import android.os.Message;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.CameraMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.camera.base.ablum_select.AlbumSelectMsgDef;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.AlbumAdapterConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.HagoAlbum;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view.SelectViewMain;

public class AlbumSelectController
extends AbstractController {
    private SelectViewMain mAlbumSelectView;

    public AlbumSelectController(Environment environment) {
        super(environment);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (AlbumSelectMsgDef.MSG_SHOW_ABLUM_SELECT == msg.what) {
            if (msg.obj instanceof HagoAlbum.OnSelect) {
                AlbumConfig albumConfig;
                boolean isDisableChannelMini = msg.getData().getBoolean("disable_channel_mini", false);
                int mediaMode = msg.getData().getInt("Media_Mode", 0);
                int showType = msg.getData().getInt("Show_Type", 0);
                AlbumAdapterConfig config = new AlbumAdapterConfig();
                config.mOnSelect = (HagoAlbum.OnSelect)msg.obj;
                config.mIsDisableChannelMini = isDisableChannelMini;
                config.mShowType = showType;
                config.mMediaMode = mediaMode;
                config.mFrom = msg.getData().getInt("from", 0);
                if (msg.getData().containsKey("config") && null != (albumConfig = (AlbumConfig)msg.getData().getSerializable("config"))) {
                    config.videoDisable = albumConfig.videoDisable;
                    config.groupVideoPermissionDays = albumConfig.groupVideoPermissionDays;
                }
                this.showSelectView(config);
            }
        } else if (AlbumSelectMsgDef.MSG_CLOSE_ABLUM_SELECT == msg.what) {
            if (msg.arg1 == 1001) {
                this.sendMessage(CameraMsgDef.MSG_ALBUM_SELECT_BACKPRESS);
            }
            this.removeWindow();
        }
    }

    public Object handleMessageSync(Message msg) {
        if (AlbumSelectMsgDef.MSG_NOTIFY_ABLUM_SELECT == msg.what && this.mAlbumSelectView != null) {
            this.mAlbumSelectView.notifyDataSetChanged();
            return null;
        }
        return super.handleMessageSync(msg);
    }

    public void notify(Notification msg) {
        super.notify(msg);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.destory();
    }

    private void showSelectView(AlbumAdapterConfig config) {
        if (this.mAlbumSelectView == null) {
            this.mAlbumSelectView = new SelectViewMain(this.getEnvironment().getContext(), (UICallBacks)this, config);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mAlbumSelectView, true);
    }

    protected boolean onWindowBackKeyEvent() {
        this.sendMessage(CameraMsgDef.MSG_ALBUM_SELECT_BACKPRESS);
        return super.onWindowBackKeyEvent();
    }

    private void removeWindow() {
        if (this.mAlbumSelectView != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mAlbumSelectView);
        }
        this.destory();
    }

    private void destory() {
        this.mAlbumSelectView = null;
    }
}

