/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.AlbumSelectMsgDef;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.AlbumAdapterConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.HagoAlbum;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.IncapableCause;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.AlbumCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.SelectedItemCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.AlbumMediaAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.AlbumsAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.AlbumsSpinner;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.MediaFileInfoUtils;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.PhotoMetadataUtils;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view.MediaSelectionView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SelectViewMain
extends DefaultWindow
implements AdapterView.OnItemSelectedListener,
INoRoomMiniWindow,
AlbumCollection.AlbumCallbacks,
AlbumMediaAdapter.CheckStateListener,
View.OnClickListener {
    private static final String TAG = "SelectViewMain";
    private AlbumsSpinner mAlbumsSpinner;
    private AlbumsAdapter mAlbumsAdapter;
    private SimpleTitleBar mSimpleTitleBar;
    private MediaSelectionView mMediaSelectionView;
    private RelativeLayout mRelativeLayout;
    private final AlbumCollection mAlbumCollection = new AlbumCollection();
    private final SelectedItemCollection mSelectedItemCollection = new SelectedItemCollection(this.getContext());
    private YYTextView mTextViewSelectNum;
    private YYFrameLayout mYYFrameLayoutSend;
    private HagoAlbum.OnSelect mOnSelect;
    private boolean isDisableChannelMini;
    private int mShowType;
    private int mMediaMode;
    private int mFrom;
    private AlbumAdapterConfig mAlbumAdapterConfig;

    public SelectViewMain(Context context, UICallBacks callBacks, AlbumAdapterConfig config) {
        super(context, callBacks, "Ablum");
        this.mOnSelect = config.mOnSelect;
        this.mShowType = config.mShowType;
        this.mMediaMode = config.mMediaMode;
        this.mFrom = config.mFrom;
        this.mAlbumAdapterConfig = config;
        this.isDisableChannelMini = config.mIsDisableChannelMini;
        this.initParam();
        this.init();
    }

    private void initParam() {
        this.mSelectedItemCollection.onCreate(null);
    }

    private void init() {
        this.setBackgroundColor(this.getResources().getColor(R.color.common_widget_bg));
        this.mSimpleTitleBar = new SimpleTitleBar(this.getContext());
        this.mSimpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_ABLUM_SELECT, 1001));
        this.mAlbumsAdapter = new AlbumsAdapter(this.getContext(), null, false);
        this.mAlbumsSpinner = new AlbumsSpinner(this.getContext());
        this.mAlbumsSpinner.setOnItemSelectedListener(this);
        this.mAlbumsSpinner.setSelectedTextView(this.mSimpleTitleBar.getLeftTextView());
        this.mAlbumsSpinner.setPopupAnchorView((View)this.mSimpleTitleBar);
        this.mAlbumsSpinner.setAdapter(this.mAlbumsAdapter);
        this.mAlbumsSpinner.setOnSelectedClickListener(() -> {
            if (this.mOnSelect instanceof HagoAlbum.OnChannelReport && ((HagoAlbum.OnChannelReport)this.mOnSelect).getHiidoEvent() != null) {
                HiidoStatis.reportEvent((HiidoEvent)((HagoAlbum.OnChannelReport)this.mOnSelect).getHiidoEvent().put("function_id", "choose_photo_album_click"));
            }
        });
        this.mAlbumCollection.onCreate((FragmentActivity)this.getContext(), this);
        this.mAlbumCollection.loadAlbums();
        this.getBarLayer().addView((View)this.mSimpleTitleBar, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)48.0f)));
        this.mRelativeLayout = new YYRelativeLayout(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.getBarLayer().addView((View)this.mRelativeLayout, (ViewGroup.LayoutParams)layoutParams);
        int layoutID = R.layout.album_bottom_send;
        if (this.mShowType == 1) {
            layoutID = R.layout.album_bottom_send_emoji;
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutID, null);
        this.mYYFrameLayoutSend = (YYFrameLayout)view.findViewById(R.id.album_fl_send);
        this.mYYFrameLayoutSend.setEnabled(false);
        this.mYYFrameLayoutSend.setOnClickListener((View.OnClickListener)this);
        this.mTextViewSelectNum = (YYTextView)view.findViewById(R.id.album_tv_select_num);
        RelativeLayout.LayoutParams layoutParamsRelat = new RelativeLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)50.0f));
        layoutParamsRelat.addRule(12);
        this.mRelativeLayout.addView(view, (ViewGroup.LayoutParams)layoutParamsRelat);
    }

    private void load(Album album) {
        if (album == null) {
            return;
        }
        if (this.mMediaSelectionView != null) {
            if (StringUtils.equalsIgnoreCase((String)album.getId(), (String)this.mMediaSelectionView.getAlbumId())) {
                return;
            }
            this.mRelativeLayout.removeView((View)this.mMediaSelectionView);
            this.mMediaSelectionView = null;
        }
        this.mMediaSelectionView = new MediaSelectionView(this.mShowType, this.mMediaMode, this.getContext(), album, this.mAlbumAdapterConfig, this, this.mSelectedItemCollection);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)48.0f) + SystemUtils.getStatusBarHeight((Context)this.getContext());
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)50.0f);
        this.mRelativeLayout.addView((View)this.mMediaSelectionView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void onDetached() {
        super.onDetached();
        this.mAlbumCollection.onDestroy();
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.mAlbumCollection.setStateCurrentSelection(position);
        this.mAlbumsAdapter.getCursor().moveToPosition(position);
        Album album = Album.valueOf(this.mAlbumsAdapter.getCursor());
        if (album.isAll() && SelectionSpec.getInstance().capture) {
            album.addCaptureCount();
        }
        this.onAlbumSelected(album);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    public void onAlbumLoad(Cursor cursor) {
        this.mAlbumsAdapter.swapCursor(cursor);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> {
            cursor.moveToPosition(this.mAlbumCollection.getCurrentSelection());
            this.mAlbumsSpinner.setSelection(this.getContext(), this.mAlbumCollection.getCurrentSelection());
            Album album = Album.valueOf(cursor);
            if (album.isAll() && SelectionSpec.getInstance().capture) {
                album.addCaptureCount();
            }
            this.onAlbumSelected(album);
        });
    }

    @Override
    public void onAlbumReset() {
        this.mAlbumsAdapter.swapCursor(null);
    }

    private void onAlbumSelected(Album album) {
        if (!album.isAll() || !album.isEmpty()) {
            this.load(album);
        }
    }

    @Override
    public void onUpdate() {
        this.updateBottomStatuBar();
    }

    @Override
    public Boolean onMediaClick(Album album, final Item item, int adapterPosition) {
        if (this.mSelectedItemCollection.isSelected(item)) {
            Object[] objects = new Object[]{this.mSelectedItemCollection.getDataWithBundle(item), this.mSelectedItemCollection, this.mOnSelect};
            final Message msg = Message.obtain();
            final Bundle bundle = new Bundle();
            bundle.putInt("from", this.mFrom);
            if (MimeType.isVideo(item.mimeType)) {
                try {
                    PermissionHelper.checkStoragePermission((Activity)((Activity)this.getContext()), (IPermissionListener)new SimplePermissionListener(){

                        public void onPermissionGranted(@NonNull String[] permission) {
                            msg.what = AppbaseMsgDef.MSG_OPEN_VIDEO_PREVIEW_WINDOW;
                            msg.arg1 = 1;
                            bundle.putString("url", YYFileUtils.getFilePathFromUri((Context)SelectViewMain.this.getContext(), (Uri)item.uri));
                            bundle.putFloat("width", (float)item.width);
                            bundle.putFloat("height", (float)item.height);
                            bundle.putInt("dataSource", 2);
                            if (SelectViewMain.this.mFrom == 6) {
                                bundle.putBoolean("close_channel", false);
                            }
                            msg.obj = bundle;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                bundle.putBoolean("disable_channel_mini", this.isDisableChannelMini);
                msg.what = AlbumSelectMsgDef.MSG_SHOW_PREVIEW_SELECT;
                msg.obj = objects;
                msg.setData(bundle);
            }
            MsgDispatcher.getInstance().sendMessage(msg);
            return true;
        }
        return false;
    }

    @Override
    public void onSelectItem(Item item, int position) {
        IncapableCause cause = this.mSelectedItemCollection.isAcceptable(item);
        if (cause != null) {
            IncapableCause.handleCause(this.getContext(), cause);
        } else {
            ArrayList<String> paths = new ArrayList<String>(1);
            paths.add(YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)item.getContentUri()));
            this.notifySelect(paths);
        }
    }

    private void updateBottomStatuBar() {
        int selectedCount = this.mSelectedItemCollection.count();
        if (selectedCount == 0) {
            this.mYYFrameLayoutSend.setEnabled(false);
            this.mTextViewSelectNum.setText((CharSequence)ResourceUtils.getString((int)R.string.button_sure_default));
            this.mTextViewSelectNum.setAlpha(0.5f);
        } else {
            this.mYYFrameLayoutSend.setEnabled(true);
            this.mTextViewSelectNum.setAlpha(1.0f);
            this.mTextViewSelectNum.setText((CharSequence)Html.fromHtml((String)ResourceUtils.getString((int)R.string.button_sure, (Object[])new Object[]{selectedCount})));
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.album_fl_send) {
            this.notifySelect(this.mSelectedItemCollection.asListOfString());
        }
    }

    private void notifySelect(List<String> ptahs) {
        if (this.mFrom != 10) {
            MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_PREVIEW_SELECT);
            MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_ABLUM_SELECT);
        }
        this.notifySelectedInfo();
        if (this.mOnSelect != null) {
            this.mOnSelect.onSelect(ptahs);
        }
    }

    private void notifySelectedInfo() {
        if (this.mShowType == 2 || this.mFrom == 6) {
            List<Item> selectedList = this.mSelectedItemCollection.asList();
            if (selectedList.size() == 1 && MimeType.isVideo(selectedList.get((int)0).mimeType)) {
                Item item = selectedList.get(0);
                this.fixVideoInfoAndNotify(item);
            } else {
                this.fixPhotoInfoAndNotify(selectedList);
            }
        }
    }

    private void fixVideoInfoAndNotify(Item item) {
        if (item == null) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            MediaFileInfoUtils.SdkMediaInfoWrapper mediaInfo = null;
            String path = YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)item.getContentUri());
            if (YYFileUtils.isFileExisted((String)path) && SdkVersionUtils.hasScopedStorage() && !YYFileUtils.isSelfScopeFile((String)path) && YYFileUtils.isContentUri((String)item.getContentUri().toString())) {
                int index = path.lastIndexOf(".");
                String suffix = index >= 0 ? path.substring(index) : ".mp4";
                File videoFile = YYFileUtils.getTempFile((Context)RuntimeContext.sApplicationContext, (String)(AccountUtil.getUid() + "_" + System.currentTimeMillis() + "_copy" + suffix));
                YYFileUtils.copyFileFromUri((Uri)item.getContentUri(), (String)videoFile.getAbsolutePath());
                path = videoFile.getAbsolutePath();
            }
            if (!TextUtils.isEmpty((CharSequence)path)) {
                mediaInfo = MediaFileInfoUtils.getVideoInfo(path);
            }
            BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
            basicMediaInfo.duration = (int)(item.duration / 1000L);
            basicMediaInfo.width = item.width;
            basicMediaInfo.height = item.height;
            basicMediaInfo.path = path;
            if (mediaInfo != null && mediaInfo.width > 0 && mediaInfo.height > 0) {
                if (Math.abs(mediaInfo.rotate) == 90.0 || Math.abs(mediaInfo.rotate) == 270.0) {
                    basicMediaInfo.width = mediaInfo.height;
                    basicMediaInfo.height = mediaInfo.width;
                    MLog.info((Object)TAG, (String)(" vedio need rotate=" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                } else {
                    basicMediaInfo.width = mediaInfo.width;
                    basicMediaInfo.height = mediaInfo.height;
                }
            }
            YYTaskExecutor.postToMainThread(() -> {
                Message message = Message.obtain();
                message.what = AlbumSelectMsgDef.MSG_NOTIFY_SELECTED_INFO;
                message.obj = basicMediaInfo;
                MsgDispatcher.getInstance().sendMessage(message);
                if (this.mFrom == 6) {
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.ALBUM_SELECTED_VIDEO;
                    basicMediaInfo.duration = (int)item.duration;
                    msg.obj = basicMediaInfo;
                    MsgDispatcher.getInstance().sendMessage(msg);
                }
            });
        });
    }

    private void fixPhotoInfoAndNotify(List<Item> selectedList) {
        YYTaskExecutor.execute(() -> {
            ArrayList<BasicMediaInfo> mPhotos = new ArrayList<BasicMediaInfo>();
            for (int i = 0; i < selectedList.size(); ++i) {
                BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
                basicMediaInfo.path = YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)((Item)selectedList.get((int)i)).uri);
                if (!YYFileUtils.isFileExisted((String)basicMediaInfo.path)) continue;
                basicMediaInfo.width = ((Item)selectedList.get((int)i)).width;
                basicMediaInfo.height = ((Item)selectedList.get((int)i)).height;
                if (basicMediaInfo.width == 0 && basicMediaInfo.height == 0) {
                    Point point = YYImageUtils.getBitmapBound((ContentResolver)this.getContext().getContentResolver(), (Uri)((Item)selectedList.get((int)i)).uri);
                    basicMediaInfo.width = point.x;
                    basicMediaInfo.height = point.y;
                }
                MLog.info((Object)TAG, (String)(" photo need index=" + i + "\uff0cphoto size:" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                boolean isRatate = PhotoMetadataUtils.shouldRotate(basicMediaInfo.path);
                if (isRatate) {
                    basicMediaInfo.height = ((Item)selectedList.get((int)i)).width;
                    basicMediaInfo.width = ((Item)selectedList.get((int)i)).height;
                    MLog.info((Object)TAG, (String)(" photo need rotate index=" + i + " " + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                }
                mPhotos.add(basicMediaInfo);
            }
            YYTaskExecutor.postToMainThread(() -> {
                Message message = Message.obtain();
                message.what = AlbumSelectMsgDef.MSG_NOTIFY_SELECTED_INFO;
                message.obj = mPhotos;
                message.arg1 = 1;
                MsgDispatcher.getInstance().sendMessage(message);
            });
        });
    }

    public void notifyDataSetChanged() {
        if (this.mMediaSelectionView != null) {
            this.mMediaSelectionView.notifyDataSetChanged();
        }
        this.updateBottomStatuBar();
    }

    public boolean isDisableChannelMini() {
        return this.isDisableChannelMini;
    }

    public boolean isTranslucentBar() {
        return true;
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mSimpleTitleBar;
    }

    public static interface OnSelectClickListener {
        public void onSelectClick();
    }
}

