/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch.ImageViewTouchBase;

public class ImageViewTouch
extends ImageViewTouchBase {
    static final float SCROLL_DELTA_THRESHOLD = 1.0f;
    public static final long MIN_FLING_DELTA_TIME = 150L;
    private float mScaleFactor;
    protected ScaleGestureDetector mScaleDetector;
    protected GestureDetector mGestureDetector;
    protected int mTouchSlop;
    protected int mDoubleTapDirection;
    protected GestureDetector.OnGestureListener mGestureListener;
    protected ScaleGestureDetector.OnScaleGestureListener mScaleListener;
    protected boolean mDoubleTapEnabled = true;
    protected boolean mScaleEnabled = true;
    protected boolean mScrollEnabled = true;
    private OnImageViewTouchDoubleTapListener mDoubleTapListener;
    private OnImageViewTouchSingleTapListener mSingleTapListener;
    long mPointerUpTime;

    public ImageViewTouch(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ImageViewTouch(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mGestureListener = this.getGestureListener();
        this.mScaleListener = this.getScaleListener();
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), this.mScaleListener);
        this.mGestureDetector = new GestureDetector(this.getContext(), this.mGestureListener, null, true);
        this.mDoubleTapDirection = 1;
        this.setQuickScaleEnabled(false);
    }

    @TargetApi(value=19)
    public void setQuickScaleEnabled(boolean value) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mScaleDetector.setQuickScaleEnabled(value);
        }
    }

    @TargetApi(value=19)
    public boolean getQuickScaleEnabled() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.mScaleDetector.isQuickScaleEnabled();
        }
        return false;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public void setDoubleTapListener(OnImageViewTouchDoubleTapListener listener) {
        this.mDoubleTapListener = listener;
    }

    public void setSingleTapListener(OnImageViewTouchSingleTapListener listener) {
        this.mSingleTapListener = listener;
    }

    public void setDoubleTapEnabled(boolean value) {
        this.mDoubleTapEnabled = value;
    }

    public void setScaleEnabled(boolean value) {
        this.mScaleEnabled = value;
    }

    public void setScrollEnabled(boolean value) {
        this.mScrollEnabled = value;
    }

    public boolean getDoubleTapEnabled() {
        return this.mDoubleTapEnabled;
    }

    protected GestureDetector.OnGestureListener getGestureListener() {
        return new GestureListener();
    }

    protected ScaleGestureDetector.OnScaleGestureListener getScaleListener() {
        return new ScaleListener();
    }

    @Override
    protected void onLayoutChanged(int left, int top, int right, int bottom) {
        super.onLayoutChanged(left, top, right, bottom);
        this.mScaleFactor = (this.getMaxScale() - this.getMinScale()) / 2.0f + 0.5f;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getBitmapChanged()) {
            return false;
        }
        int action = event.getActionMasked();
        if (action == 6) {
            this.mPointerUpTime = event.getEventTime();
        }
        this.mScaleDetector.onTouchEvent(event);
        if (!this.mScaleDetector.isInProgress()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        switch (action) {
            case 1: {
                return this.onUp(event);
            }
        }
        return true;
    }

    @Override
    protected void onZoomAnimationCompleted(float scale) {
        if (DEBUG) {
            Log.d((String)"ImageViewTouchBase", (String)("onZoomAnimationCompleted. scale: " + scale + ", minZoom: " + this.getMinScale()));
        }
        if (scale < this.getMinScale()) {
            this.zoomTo(this.getMinScale(), 50L);
        }
    }

    protected float onDoubleTapPost(float scale, float maxZoom, float minScale) {
        if (scale + this.mScaleFactor <= maxZoom) {
            return scale + this.mScaleFactor;
        }
        return minScale;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.canScroll()) {
            return false;
        }
        this.mUserScaled = true;
        this.scrollBy(-distanceX, -distanceY);
        this.invalidate();
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.canScroll()) {
            return false;
        }
        if (DEBUG) {
            Log.i((String)"ImageViewTouchBase", (String)"onFling");
        }
        if (Math.abs(velocityX) > (float)(this.mMinFlingVelocity * 4) || Math.abs(velocityY) > (float)(this.mMinFlingVelocity * 4)) {
            if (DEBUG) {
                Log.v((String)"ImageViewTouchBase", (String)("velocity: " + velocityY));
                Log.v((String)"ImageViewTouchBase", (String)("diff: " + (e2.getY() - e1.getY())));
            }
            float scale = Math.min(Math.max(2.0f, this.getScale() / 2.0f), 3.0f);
            float scaledDistanceX = velocityX / (float)this.mMaxFlingVelocity * ((float)this.getWidth() * scale);
            float scaledDistanceY = velocityY / (float)this.mMaxFlingVelocity * ((float)this.getHeight() * scale);
            if (DEBUG) {
                Log.v((String)"ImageViewTouchBase", (String)("scale: " + this.getScale() + ", scale_final: " + scale));
                Log.v((String)"ImageViewTouchBase", (String)("scaledDistanceX: " + scaledDistanceX));
                Log.v((String)"ImageViewTouchBase", (String)("scaledDistanceY: " + scaledDistanceY));
            }
            this.mUserScaled = true;
            double total = Math.sqrt(Math.pow(scaledDistanceX, 2.0) + Math.pow(scaledDistanceY, 2.0));
            this.scrollBy(scaledDistanceX, scaledDistanceY, (long)Math.min(Math.max(300.0, total / 5.0), 800.0));
            this.postInvalidate();
            return true;
        }
        return false;
    }

    public boolean onDown(MotionEvent e) {
        return !this.getBitmapChanged();
    }

    public boolean onUp(MotionEvent e) {
        if (this.getBitmapChanged()) {
            return false;
        }
        if (this.getScale() < this.getMinScale()) {
            this.zoomTo(this.getMinScale(), 50L);
        }
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return !this.getBitmapChanged();
    }

    public boolean canScroll() {
        if (this.getScale() > 1.0f) {
            return true;
        }
        RectF bitmapRect = this.getBitmapRect();
        return !this.mViewPort.contains(bitmapRect);
    }

    public boolean canScroll(int direction) {
        RectF bitmapRect = this.getBitmapRect();
        this.updateRect(bitmapRect, this.mScrollPoint);
        Rect imageViewRect = new Rect();
        this.getGlobalVisibleRect(imageViewRect);
        if (null == bitmapRect) {
            return false;
        }
        if (bitmapRect.right >= (float)imageViewRect.right && direction < 0) {
            return Math.abs(bitmapRect.right - (float)imageViewRect.right) > 1.0f;
        }
        double bitmapScrollRectDelta = Math.abs(bitmapRect.left - this.mScrollPoint.x);
        return bitmapScrollRectDelta > 1.0;
    }

    public static interface OnImageViewTouchSingleTapListener {
        public void onSingleTapConfirmed();
    }

    public static interface OnImageViewTouchDoubleTapListener {
        public void onDoubleTap();
    }

    public class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        protected boolean mScaled = false;

        public boolean onScale(ScaleGestureDetector detector) {
            float span = detector.getCurrentSpan() - detector.getPreviousSpan();
            float targetScale = ImageViewTouch.this.getScale() * detector.getScaleFactor();
            if (ImageViewTouch.this.mScaleEnabled) {
                if (this.mScaled && span != 0.0f) {
                    ImageViewTouch.this.mUserScaled = true;
                    targetScale = Math.min(ImageViewTouch.this.getMaxScale(), Math.max(targetScale, ImageViewTouch.this.getMinScale() - 0.1f));
                    ImageViewTouch.this.zoomTo(targetScale, detector.getFocusX(), detector.getFocusY());
                    ImageViewTouch.this.mDoubleTapDirection = 1;
                    ImageViewTouch.this.invalidate();
                    return true;
                }
                if (!this.mScaled) {
                    this.mScaled = true;
                }
            }
            return true;
        }
    }

    public class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (null != ImageViewTouch.this.mSingleTapListener) {
                ImageViewTouch.this.mSingleTapListener.onSingleTapConfirmed();
            }
            return ImageViewTouch.this.onSingleTapConfirmed(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (ImageViewTouchBase.DEBUG) {
                Log.i((String)"ImageViewTouchBase", (String)("onDoubleTap. double tap enabled? " + ImageViewTouch.this.mDoubleTapEnabled));
            }
            if (ImageViewTouch.this.mDoubleTapEnabled) {
                if (Build.VERSION.SDK_INT >= 19 && ImageViewTouch.this.mScaleDetector.isQuickScaleEnabled()) {
                    return true;
                }
                ImageViewTouch.this.mUserScaled = true;
                float scale = ImageViewTouch.this.getScale();
                float targetScale = ImageViewTouch.this.onDoubleTapPost(scale, ImageViewTouch.this.getMaxScale(), ImageViewTouch.this.getMinScale());
                targetScale = Math.min(ImageViewTouch.this.getMaxScale(), Math.max(targetScale, ImageViewTouch.this.getMinScale()));
                ImageViewTouch.this.zoomTo(targetScale, e.getX(), e.getY(), ImageViewTouch.this.mDefaultAnimationDuration);
            }
            if (null != ImageViewTouch.this.mDoubleTapListener) {
                ImageViewTouch.this.mDoubleTapListener.onDoubleTap();
            }
            return super.onDoubleTap(e);
        }

        public void onLongPress(MotionEvent e) {
            if (ImageViewTouch.this.isLongClickable() && !ImageViewTouch.this.mScaleDetector.isInProgress()) {
                ImageViewTouch.this.setPressed(true);
                ImageViewTouch.this.performLongClick();
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!ImageViewTouch.this.mScrollEnabled) {
                return false;
            }
            if (e1 == null || e2 == null) {
                return false;
            }
            if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
                return false;
            }
            if (ImageViewTouch.this.mScaleDetector.isInProgress()) {
                return false;
            }
            return ImageViewTouch.this.onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!ImageViewTouch.this.mScrollEnabled) {
                return false;
            }
            if (e1 == null || e2 == null) {
                return false;
            }
            if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
                return false;
            }
            if (ImageViewTouch.this.mScaleDetector.isInProgress()) {
                return false;
            }
            long delta = SystemClock.uptimeMillis() - ImageViewTouch.this.mPointerUpTime;
            if (delta > 150L) {
                return ImageViewTouch.this.onFling(e1, e2, velocityX, velocityY);
            }
            return false;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return ImageViewTouch.this.onSingleTapUp(e);
        }

        public boolean onDown(MotionEvent e) {
            if (ImageViewTouchBase.DEBUG) {
                Log.i((String)"ImageViewTouchBase", (String)"onDown");
            }
            ImageViewTouch.this.stopAllAnimations();
            return ImageViewTouch.this.onDown(e);
        }
    }
}

