/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.CheckView;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.SquareFrameLayout;

public class MediaGrid
extends SquareFrameLayout
implements View.OnClickListener {
    private YYImageView mThumbnail;
    private CheckView mCheckView;
    private YYImageView mGifTag;
    private YYTextView mVideoDuration;
    private Item mMedia;
    private PreBindInfo mPreBindInfo;
    private OnMediaGridClickListener mListener;

    public MediaGrid(Context context) {
        super(context);
        this.init(context);
    }

    public MediaGrid(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.media_grid_content, (ViewGroup)this, true);
        this.mThumbnail = (YYImageView)this.findViewById(R.id.media_thumbnail);
        this.mCheckView = (CheckView)this.findViewById(R.id.check_view);
        this.mGifTag = (YYImageView)this.findViewById(R.id.gif);
        this.mVideoDuration = (YYTextView)this.findViewById(R.id.video_duration);
        this.mThumbnail.setOnClickListener((View.OnClickListener)this);
        this.mCheckView.setOnClickListener(this);
    }

    public void onClick(View v) {
        if (this.mListener != null) {
            if (v == this.mThumbnail) {
                boolean consume = this.mListener.onThumbnailClicked((ImageView)this.mThumbnail, this.mMedia, this.mPreBindInfo.mViewHolder);
                if (!consume) {
                    this.mListener.onCheckViewClicked(this.mCheckView, this.mMedia, this.mPreBindInfo.mViewHolder);
                }
            } else if (v == this.mCheckView) {
                this.mListener.onCheckViewClicked(this.mCheckView, this.mMedia, this.mPreBindInfo.mViewHolder);
            }
        }
    }

    public void preBindMedia(PreBindInfo info) {
        this.mPreBindInfo = info;
    }

    public void bindMedia(Item item) {
        this.mMedia = item;
        this.setGifTag();
        this.initCheckView();
        this.setImage();
        this.setVideoDuration();
    }

    public Item getMedia() {
        return this.mMedia;
    }

    private void setGifTag() {
        this.mGifTag.setVisibility(this.mMedia.isGif() ? 0 : 8);
    }

    private void initCheckView() {
        this.mCheckView.setVisibility(this.mPreBindInfo.mCheckAble ? 0 : 8);
        this.mCheckView.setCountable(this.mPreBindInfo.mCheckViewCountable);
    }

    public void setCheckEnabled(boolean enabled) {
        this.mCheckView.setEnabled(enabled);
        this.mThumbnail.setAlpha(enabled ? 1.0f : 0.5f);
    }

    public void setCheckedNum(int checkedNum) {
        this.mCheckView.setCheckedNum(checkedNum);
    }

    public void setChecked(boolean checked) {
        this.mCheckView.setChecked(checked);
    }

    private void setImage() {
        if (this.mMedia.isGif()) {
            SelectionSpec.getInstance().imageEngine.loadGifThumbnail(this.getContext(), this.mPreBindInfo.mResize, this.mPreBindInfo.mPlaceholder, this.mThumbnail, this.mMedia.getContentUri());
        } else {
            SelectionSpec.getInstance().imageEngine.loadThumbnail(this.getContext(), this.mPreBindInfo.mResize, this.mPreBindInfo.mPlaceholder, this.mThumbnail, this.mMedia.getContentUri());
        }
    }

    private void setVideoDuration() {
        if (this.mMedia.isVideo()) {
            this.mVideoDuration.setVisibility(0);
            this.mVideoDuration.setText((CharSequence)DateUtils.formatElapsedTime((long)(this.mMedia.duration / 1000L)));
        } else {
            this.mVideoDuration.setVisibility(8);
        }
    }

    public void setOnMediaGridClickListener(OnMediaGridClickListener listener) {
        this.mListener = listener;
    }

    public void removeOnMediaGridClickListener() {
        this.mListener = null;
    }

    public static class PreBindInfo {
        int mResize;
        Drawable mPlaceholder;
        boolean mCheckViewCountable;
        RecyclerView.ViewHolder mViewHolder;
        boolean mCheckAble;

        public PreBindInfo(int resize, Drawable placeholder, boolean checkViewCountable, RecyclerView.ViewHolder viewHolder, boolean checkAble) {
            this.mResize = resize;
            this.mPlaceholder = placeholder;
            this.mCheckViewCountable = checkViewCountable;
            this.mViewHolder = viewHolder;
            this.mCheckAble = checkAble;
        }
    }

    public static interface OnMediaGridClickListener {
        public boolean onThumbnailClicked(ImageView var1, Item var2, RecyclerView.ViewHolder var3);

        public void onCheckViewClicked(CheckView var1, Item var2, RecyclerView.ViewHolder var3);
    }
}

