/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.GroupVideoMsgConfig;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.AlbumAdapterConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.IncapableCause;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.SelectedItemCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.RecyclerViewCursorAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.CheckView;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.MediaGrid;

public class AlbumMediaAdapter
extends RecyclerViewCursorAdapter<RecyclerView.ViewHolder>
implements MediaGrid.OnMediaGridClickListener {
    private final SelectedItemCollection mSelectedCollection;
    private final Drawable mPlaceholder;
    private SelectionSpec mSelectionSpec;
    private CheckStateListener mCheckStateListener;
    private OnCameraClick mOnCameraClick;
    private RecyclerView mRecyclerView;
    private int mImageResize;
    private int mPreMaxSelected = 9;
    private boolean mVideoCanBeSelected;
    private boolean mEnableVideoSelected;
    private AlbumAdapterConfig mAlbumAdapterConfig;

    public AlbumMediaAdapter(int showType, AlbumAdapterConfig config, SelectedItemCollection selectedCollection, RecyclerView recyclerView) {
        super(null);
        this.mShowType = showType;
        this.mAlbumAdapterConfig = config;
        this.mSelectionSpec = SelectionSpec.getInstance();
        this.mSelectedCollection = selectedCollection;
        this.mPlaceholder = new ColorDrawable(Color.parseColor((String)"#37474F"));
        this.mRecyclerView = recyclerView;
        if (this.mShowType == 2 || this.mShowType == 3 || this.mShowType == 4) {
            this.mEnableVideoSelected = true;
            this.mVideoCanBeSelected = true;
        } else {
            this.mVideoCanBeSelected = false;
            this.mEnableVideoSelected = false;
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.photo_capture_item, parent, false);
            CaptureViewHolder holder = new CaptureViewHolder(v);
            holder.itemView.setOnClickListener(v1 -> {
                if (v1.getContext() instanceof OnPhotoCapture) {
                    ((OnPhotoCapture)v1.getContext()).capture();
                }
            });
            return holder;
        }
        if (viewType == 2) {
            return new MediaViewHolder((View)new MediaGrid(parent.getContext()));
        }
        if (viewType == 3) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_album_take_photo, parent, false);
            OpenCameraViewHolder viewHolder = new OpenCameraViewHolder(v);
            v.setOnClickListener(view -> {
                if (this.mOnCameraClick != null) {
                    this.mOnCameraClick.onCameraClick(1);
                }
            });
            return viewHolder;
        }
        return null;
    }

    @Override
    protected void onBindViewHolder(RecyclerView.ViewHolder holder, Cursor cursor) {
        if (holder instanceof CaptureViewHolder) {
            CaptureViewHolder captureViewHolder = (CaptureViewHolder)holder;
            Drawable[] drawables = captureViewHolder.mHint.getCompoundDrawables();
            for (int i = 0; i < drawables.length; ++i) {
                Drawable.ConstantState state;
                Drawable drawable2 = drawables[i];
                if (drawable2 == null || (state = drawable2.getConstantState()) == null) continue;
                Drawable newDrawable = state.newDrawable().mutate();
                newDrawable.setColorFilter(Color.parseColor((String)"#424242"), PorterDuff.Mode.SRC_IN);
                newDrawable.setBounds(drawable2.getBounds());
                drawables[i] = newDrawable;
            }
            captureViewHolder.mHint.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
        } else if (holder instanceof MediaViewHolder) {
            MediaViewHolder mediaViewHolder = (MediaViewHolder)holder;
            Item item = Item.valueOf(cursor);
            mediaViewHolder.mMediaGrid.preBindMedia(new MediaGrid.PreBindInfo(this.getImageResize(mediaViewHolder.mMediaGrid.getContext()), this.mPlaceholder, this.mSelectionSpec.countable, holder, !this.mSelectionSpec.singleSelectMode));
            mediaViewHolder.mMediaGrid.bindMedia(item);
            mediaViewHolder.mMediaGrid.setOnMediaGridClickListener(this);
            this.setCheckStatus(item, mediaViewHolder.mMediaGrid);
        } else if (holder instanceof OpenCameraViewHolder) {
            ViewGroup.LayoutParams layoutParams = holder.itemView.getLayoutParams();
            layoutParams.height = layoutParams.width;
            holder.itemView.setLayoutParams(layoutParams);
        }
    }

    private void setCheckStatus(Item item, MediaGrid mediaGrid) {
        if (this.mSelectionSpec.countable) {
            int checkedNum = this.mSelectedCollection.checkedNumOf(item);
            if (checkedNum > 0) {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setCheckedNum(checkedNum);
            } else if (this.mSelectedCollection.maxSelectableReached()) {
                mediaGrid.setCheckEnabled(false);
                mediaGrid.setCheckedNum(Integer.MIN_VALUE);
            } else if (this.mEnableVideoSelected && !this.mVideoCanBeSelected && MimeType.isVideo(item.mimeType)) {
                mediaGrid.setCheckEnabled(false);
                mediaGrid.setCheckedNum(Integer.MIN_VALUE);
            } else {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setCheckedNum(checkedNum);
            }
        } else {
            boolean selected = this.mSelectedCollection.isSelected(item);
            if (selected) {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setChecked(true);
            } else if (this.mSelectedCollection.maxSelectableReached()) {
                mediaGrid.setCheckEnabled(false);
                mediaGrid.setChecked(false);
            } else if (this.mEnableVideoSelected) {
                if (!this.mVideoCanBeSelected && MimeType.isVideo(item.mimeType)) {
                    mediaGrid.setCheckEnabled(false);
                    mediaGrid.setChecked(false);
                } else {
                    mediaGrid.setCheckEnabled(true);
                    mediaGrid.setChecked(false);
                }
            } else {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setChecked(false);
            }
        }
    }

    @Override
    public boolean onThumbnailClicked(ImageView thumbnail, Item item, RecyclerView.ViewHolder holder) {
        if (this.mCheckStateListener != null) {
            if (this.mSelectionSpec.singleSelectMode) {
                this.mCheckStateListener.onSelectItem(item, holder.getAdapterPosition());
                return true;
            }
            return this.mCheckStateListener.onMediaClick(null, item, holder.getAdapterPosition());
        }
        return false;
    }

    @Override
    public void onCheckViewClicked(CheckView checkView, Item item, RecyclerView.ViewHolder holder) {
        if (this.mSelectionSpec.countable) {
            int checkedNum = this.mSelectedCollection.checkedNumOf(item);
            if (checkedNum == Integer.MIN_VALUE) {
                boolean canSelected;
                if (this.assertAddSelection(holder.itemView.getContext(), item) && (canSelected = this.checkCanSelected(checkView.getContext(), item))) {
                    this.mSelectedCollection.add(item);
                    this.notifyCheckStateChanged();
                    this.notifySelectedChange(item, true);
                }
            } else {
                this.mSelectedCollection.remove(item);
                this.notifyCheckStateChanged();
                this.notifySelectedChange(item, false);
            }
        } else if (this.mSelectedCollection.isSelected(item)) {
            this.mSelectedCollection.remove(item);
            this.notifyCheckStateChanged();
            this.notifySelectedChange(item, false);
        } else {
            boolean canSelected = this.checkCanSelected(checkView.getContext(), item);
            if (canSelected && this.assertAddSelection(holder.itemView.getContext(), item)) {
                this.mSelectedCollection.add(item);
                this.notifyCheckStateChanged();
                this.notifySelectedChange(item, true);
            }
        }
    }

    private boolean checkCanSelected(Context context, Item item) {
        long minDuration = 3000L;
        long maxDuration = 60000L;
        long maxSize = 0x1900000L;
        if (MimeType.isVideo(item.mimeType) && null != this.mAlbumAdapterConfig && this.mAlbumAdapterConfig.mFrom == 6) {
            int recordDuration;
            if (this.mAlbumAdapterConfig.videoDisable) {
                ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.btn_group_msg_disable_video, (Object[])new Object[]{this.mAlbumAdapterConfig.groupVideoPermissionDays}), (int)0);
                return false;
            }
            AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.GROUP_VIDEO_MSG);
            if (config instanceof GroupVideoMsgConfig && (recordDuration = ((GroupVideoMsgConfig)config).getAlbumVideoDuration()) > 0) {
                maxDuration = recordDuration * 1000;
            }
        }
        if (this.mEnableVideoSelected && MimeType.isVideo(item.mimeType) && this.mShowType != 4) {
            if (item.duration < minDuration) {
                ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_album_video_too_short, (Object[])new Object[]{minDuration / 1000L}), (int)0);
            } else if (item.duration > maxDuration) {
                ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_album_video_too_long, (Object[])new Object[]{maxDuration / 1000L}), (int)0);
            } else if (item.size > maxSize) {
                ToastUtils.showToast((Context)context, (int)R.string.video_file_size_limit);
            }
            return item.duration >= minDuration && item.duration <= maxDuration && item.size < maxSize;
        }
        return true;
    }

    private void notifySelectedChange(Item item, boolean checked) {
        if (this.mEnableVideoSelected) {
            if (MimeType.isVideo(item.mimeType)) {
                if (checked) {
                    this.mPreMaxSelected = SelectionSpec.getInstance().maxSelectable;
                    SelectionSpec.getInstance().maxSelectable = 1;
                    this.notifyDataSetChanged();
                } else {
                    SelectionSpec.getInstance().maxSelectable = this.mPreMaxSelected;
                }
            } else {
                int selectedSize = this.mSelectedCollection.count();
                this.mVideoCanBeSelected = checked ? false : selectedSize == 0;
            }
        }
    }

    private void notifyCheckStateChanged() {
        this.notifyDataSetChanged();
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onUpdate();
        }
    }

    @Override
    public int getItemViewType(int position, Cursor cursor) {
        if (this.mShowType == 2) {
            if (this.getItemCount() > 0) {
                if (position == 0) {
                    return 3;
                }
                return Item.valueOf(cursor).isCapture() ? 1 : 2;
            }
            return Item.valueOf(cursor).isCapture() ? 1 : 2;
        }
        return Item.valueOf(cursor).isCapture() ? 1 : 2;
    }

    private boolean assertAddSelection(Context context, Item item) {
        IncapableCause cause = this.mSelectedCollection.isAcceptable(item);
        IncapableCause.handleCause(context, cause);
        return cause == null;
    }

    public void registerCheckStateListener(CheckStateListener listener) {
        this.mCheckStateListener = listener;
    }

    public void unregisterCheckStateListener() {
        this.mCheckStateListener = null;
    }

    public void registerCameraClickListener(OnCameraClick onCameraClick) {
        this.mOnCameraClick = onCameraClick;
    }

    public void unregisterCameraClickListener() {
        this.mOnCameraClick = null;
    }

    public void refreshSelection() {
        GridLayoutManager layoutManager = (GridLayoutManager)this.mRecyclerView.getLayoutManager();
        int first = layoutManager.findFirstVisibleItemPosition();
        int last = layoutManager.findLastVisibleItemPosition();
        if (first == -1 || last == -1) {
            return;
        }
        Cursor cursor = this.getCursor();
        for (int i = first; i <= last; ++i) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.findViewHolderForAdapterPosition(first);
            if (!(holder instanceof MediaViewHolder) || !cursor.moveToPosition(i)) continue;
            this.setCheckStatus(Item.valueOf(cursor), ((MediaViewHolder)holder).mMediaGrid);
        }
    }

    private int getImageResize(Context context) {
        if (this.mImageResize == 0) {
            RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
            int spanCount = ((GridLayoutManager)lm).getSpanCount();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            int availableWidth = screenWidth - context.getResources().getDimensionPixelSize(R.dimen.media_grid_spacing) * (spanCount - 1);
            this.mImageResize = availableWidth / spanCount;
            this.mImageResize = (int)((float)this.mImageResize * this.mSelectionSpec.thumbnailScale);
        }
        return this.mImageResize;
    }

    private static class OpenCameraViewHolder
    extends RecyclerView.ViewHolder {
        public OpenCameraViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }

    private static class CaptureViewHolder
    extends RecyclerView.ViewHolder {
        private YYTextView mHint;

        CaptureViewHolder(View itemView) {
            super(itemView);
            this.mHint = (YYTextView)itemView.findViewById(R.id.hint);
        }
    }

    private static class MediaViewHolder
    extends RecyclerView.ViewHolder {
        private MediaGrid mMediaGrid;

        MediaViewHolder(View itemView) {
            super(itemView);
            this.mMediaGrid = (MediaGrid)itemView;
        }
    }

    public static interface OnCameraClick {
        public void onCameraClick(int var1);
    }

    public static interface OnPhotoCapture {
        public void capture();
    }

    public static interface CheckStateListener {
        public void onUpdate();

        public Boolean onMediaClick(Album var1, Item var2, int var3);

        public void onSelectItem(Item var1, int var2);
    }
}

