/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.base.startup.ActivityStackManager;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.loader.AlbumLoader;
import java.lang.ref.WeakReference;

public class AlbumCollection
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int LOADER_ID = 1;
    private static final String STATE_CURRENT_SELECTION = "state_current_selection";
    private WeakReference<Context> mContext;
    private LoaderManager mLoaderManager;
    private AlbumCallbacks mCallbacks;
    private int mCurrentSelection;
    private boolean mLoadFinished;

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        this.mLoadFinished = false;
        return AlbumLoader.newInstance(context);
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        if (!this.mLoadFinished) {
            this.mLoadFinished = true;
            if (this.mCallbacks != null) {
                this.mCallbacks.onAlbumLoad(data);
            }
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        if (this.mCallbacks != null) {
            this.mCallbacks.onAlbumReset();
        }
    }

    public void onCreate(FragmentActivity activity, AlbumCallbacks callbacks) {
        this.mContext = new WeakReference<FragmentActivity>(activity);
        this.mLoaderManager = activity.getSupportLoaderManager();
        this.mCallbacks = callbacks;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        this.mCurrentSelection = savedInstanceState.getInt(STATE_CURRENT_SELECTION);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(STATE_CURRENT_SELECTION, this.mCurrentSelection);
    }

    public void onDestroy() {
        if (this.mLoaderManager != null) {
            this.mLoaderManager.destroyLoader(1);
        }
        this.mCallbacks = null;
    }

    public void loadAlbums() {
        PermissionHelper.checkStoragePermission((Activity)ActivityStackManager.getInstance().currentActivity(), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                AlbumCollection.this.mLoaderManager.initLoader(1, null, (LoaderManager.LoaderCallbacks)AlbumCollection.this);
            }
        });
    }

    public int getCurrentSelection() {
        return this.mCurrentSelection;
    }

    public void setStateCurrentSelection(int currentSelection) {
        this.mCurrentSelection = currentSelection;
    }

    public static interface AlbumCallbacks {
        public void onAlbumLoad(Cursor var1);

        public void onAlbumReset();
    }
}

