/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.camera.base.ablum_select.AlbumSelectMsgDef;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.SelectionCreator;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.engine.impl.GlideEngine;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public final class HagoAlbum {
    public static final int SHOW_TYPE_NORMAL = 0;
    public static final int SHOW_TYPE_EMOJI = 1;
    public static final int SHOW_TYPE_BBS = 2;
    public static final int SHOW_TYPE_CHANNEL = 3;
    public static final int SHOW_TYPE_FEEDBACK = 4;
    private Set<MimeType> mMimeTypes = MimeType.ofImage();
    private int mSpanCount = 4;
    private int mMaxSelectable = 1;
    private Activity mActivity;
    private int mOriginalMaxSize = Integer.MAX_VALUE;
    private boolean isDisableChannelMini = false;
    private int showType;
    private int mMediaMode = 0;
    private int mFrom = 0;
    private boolean mSingleSelectMode = false;
    private AlbumConfig mAlbumConfig;

    private HagoAlbum(Activity activity) {
        this.mActivity = activity;
    }

    public static HagoAlbum from(Activity activity) {
        return new HagoAlbum(activity);
    }

    private SelectionCreator choose(Set<MimeType> mimeTypes) {
        return this.choose(mimeTypes, true);
    }

    private SelectionCreator choose(Set<MimeType> mimeTypes, boolean mediaTypeExclusive) {
        return new SelectionCreator(this, mimeTypes, mediaTypeExclusive);
    }

    public void build(final OnSelect onSelect) {
        PermissionHelper.requestStoreAndCameraPermission((Activity)this.mActivity, (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                HagoAlbum.this.choose(HagoAlbum.this.mMimeTypes).imageEngine(new GlideEngine()).spanCount(HagoAlbum.this.mSpanCount).maxSelectable(HagoAlbum.this.mMaxSelectable).maxOriginalSize(HagoAlbum.this.mOriginalMaxSize).originalEnable(true).singleSelectMode(HagoAlbum.this.mSingleSelectMode).showSingleMediaType(true);
                Message msg = Message.obtain();
                msg.what = AlbumSelectMsgDef.MSG_SHOW_ABLUM_SELECT;
                msg.obj = onSelect;
                Bundle bundle = new Bundle();
                bundle.putBoolean("disable_channel_mini", HagoAlbum.this.isDisableChannelMini);
                bundle.putInt("Media_Mode", HagoAlbum.this.mMediaMode);
                bundle.putInt("Show_Type", HagoAlbum.this.showType);
                bundle.putInt("from", HagoAlbum.this.mFrom);
                bundle.putSerializable("config", (Serializable)HagoAlbum.this.mAlbumConfig);
                msg.setData(bundle);
                MsgDispatcher.getInstance().sendMessage(msg);
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                ToastUtils.showToast((Context)HagoAlbum.this.mActivity, (String)ResourceUtils.getString((int)R.string.toast_no_camera_permission), (int)0);
            }
        });
    }

    public HagoAlbum mimeTypes(Set<MimeType> mimeTypes) {
        if (mimeTypes != null) {
            this.mMimeTypes = mimeTypes;
        }
        return this;
    }

    public HagoAlbum spanCount(int spanCount) {
        if (spanCount >= 1 && spanCount <= 5) {
            this.mSpanCount = spanCount;
        }
        return this;
    }

    public HagoAlbum setShowType(int showType) {
        this.showType = showType;
        return this;
    }

    public HagoAlbum maxSelectable(int maxSelectable) {
        this.mMaxSelectable = maxSelectable >= 1 && maxSelectable <= 9 ? maxSelectable : 1;
        return this;
    }

    public HagoAlbum originalMaxSize(int originalMaxSize) {
        if (originalMaxSize > 0) {
            this.mOriginalMaxSize = originalMaxSize;
        }
        return this;
    }

    public HagoAlbum disableChannelMini(boolean isDisableChannelMini) {
        this.isDisableChannelMini = isDisableChannelMini;
        return this;
    }

    public int getMediaMode() {
        return this.mMediaMode;
    }

    public HagoAlbum setMediaMode(int mediaMode) {
        this.mMediaMode = mediaMode;
        return this;
    }

    public HagoAlbum from(int from) {
        this.mFrom = from;
        return this;
    }

    public HagoAlbum singleSelectMode(boolean singleSelectMode) {
        this.mSingleSelectMode = singleSelectMode;
        return this;
    }

    public HagoAlbum config(AlbumConfig config) {
        this.mAlbumConfig = config;
        return this;
    }

    public static interface OnChannelReport
    extends OnSelect {
        public HiidoEvent getHiidoEvent();
    }

    public static interface OnSelect {
        public void onSelect(List<String> var1);
    }
}

