/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.tools.ISeatLocationProvider;
import com.yy.hiyo.channel.component.seat.SeatLocationPresenter;
import com.yy.hiyo.channel.plugins.bocai.DR;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.seat.bean.WealthSeatItem;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.service.IGameAudioService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnimationManager {
    private List<WealthSeatItem> mWealthSeatItemList = new ArrayList<WealthSeatItem>();
    private AbsRoomPage mPage;
    private ISeatAnimationCallback mCallback;
    private SeatLocationPresenter mSeatLocationPresenter;
    private Map<Long, Point> mSeatPointMap = new HashMap<Long, Point>();

    public AnimationManager(IChannelPageContext roomPageContext, ISeatAnimationCallback callback) {
        this.mSeatLocationPresenter = (SeatLocationPresenter)roomPageContext.getPresenter(SeatLocationPresenter.class);
        this.mCallback = callback;
    }

    public void setRoomPage(AbsRoomPage page) {
        this.mPage = page;
    }

    public void setGameResult(List<WealthSeatItem> list) {
        this.mWealthSeatItemList = list;
    }

    public void showSeatAnimation(WealthSeatItem wealthSeatItem) {
        if (wealthSeatItem == null) {
            FeatureLog.i((String)"FTWealth", (String)"showSeatAnimation list null", (Object[])new Object[0]);
            return;
        }
        FeatureLog.i((String)"FTWealth", (String)"showSeatAnimation:%s", (Object[])new Object[]{wealthSeatItem});
        SVGAImageView svgaImageView = this.createSvga(wealthSeatItem);
        int index = this.mWealthSeatItemList.indexOf((Object)wealthSeatItem);
        WealthSeatItem nextItem = null;
        if (index + 1 < this.mWealthSeatItemList.size()) {
            nextItem = this.mWealthSeatItemList.get(index + 1);
        }
        if (svgaImageView == null) {
            FeatureLog.i((String)"FTWealth", (String)"showSeatAnimation svga null", (Object[])new Object[0]);
            WealthSeatItem finalNextItem = nextItem;
            YYTaskExecutor.postToMainThread(() -> {
                if (this.mCallback != null) {
                    this.mCallback.onFinished(wealthSeatItem, finalNextItem);
                    this.mCallback.onNext(finalNextItem);
                }
            }, (long)3600L);
            return;
        }
        if (wealthSeatItem.hasShowResult()) {
            FeatureLog.i((String)"FTWealth", (String)"showSeatAnimation hasShowResult true", (Object[])new Object[0]);
            WealthSeatItem finalNextItem = nextItem;
            YYTaskExecutor.postToMainThread(() -> {
                if (this.mCallback != null) {
                    this.mCallback.onFinished(wealthSeatItem, finalNextItem);
                    this.mCallback.onNext(finalNextItem);
                }
            });
            return;
        }
        this.addSvga(wealthSeatItem.uid, svgaImageView);
        this.showSvga(svgaImageView, wealthSeatItem, nextItem);
    }

    private void addSvga(long uid, SVGAImageView svgaImageView) {
        if (this.mSeatLocationPresenter == null) {
            FeatureLog.i((String)"FTWealth", (String)"addSvga presenter null", (Object[])new Object[0]);
            return;
        }
        if (this.mSeatLocationPresenter.isDestroyed()) {
            FeatureLog.i((String)"FTWealth", (String)"addSvga presenter destroy", (Object[])new Object[0]);
            return;
        }
        if (this.mSeatLocationPresenter.getSeatLocation(false).getValue() == null) {
            if (this.mSeatPointMap.containsKey(uid)) {
                this.addSvgaToPage(this.mSeatPointMap.get(uid), svgaImageView);
            }
            return;
        }
        if (((Map)this.mSeatLocationPresenter.getSeatLocation(false).getValue()).containsKey(uid)) {
            this.addSvgaToPage((Point)((Map)this.mSeatLocationPresenter.getSeatLocation(false).getValue()).get(uid), svgaImageView);
        }
    }

    private void addSvgaToPage(Point point, SVGAImageView svgaImageView) {
        FeatureLog.i((String)"FTWealth", (String)"addSvgaToPage:%s", (Object[])new Object[]{point});
        if (point == null) {
            FeatureLog.i((String)"FTWealth", (String)"addSvgaToPage point null", (Object[])new Object[0]);
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)50.0f), ResolutionUtils.dip2Px((float)50.0f));
        svgaImageView.setLayoutParams(layoutParams);
        if (this.mPage.getPageView() instanceof ViewGroup) {
            ((ViewGroup)this.mPage.getPageView()).addView((View)svgaImageView);
        }
        svgaImageView.setLoops(1);
        if (LanguageUtils.isRtl()) {
            svgaImageView.setX((float)(point.x + ResolutionUtils.dip2Px((float)50.0f) / 2));
        } else {
            svgaImageView.setX((float)(point.x - ResolutionUtils.dip2Px((float)50.0f) / 2));
        }
        svgaImageView.setY((float)(point.y - ResolutionUtils.dip2Px((float)50.0f) / 2));
    }

    private void showSvga(SVGAImageView svgaImageView, final WealthSeatItem wealthSeatItem, final WealthSeatItem nextItem) {
        if (wealthSeatItem == null) {
            FeatureLog.i((String)"FTWealth", (String)"showSvga wealthSeatItem null", (Object[])new Object[0]);
            return;
        }
        this.loadSvga(svgaImageView, wealthSeatItem);
        svgaImageView.setCallback(new SVGACallback(){
            private boolean hasNext = false;

            public void onPause() {
            }

            public void onFinished() {
                if (AnimationManager.this.mCallback != null && !wealthSeatItem.hasShowResult()) {
                    wealthSeatItem.setHasShowResult(true);
                    FeatureLog.i((String)"FTWealth", (String)"svga onFinished:%s", (Object[])new Object[]{wealthSeatItem});
                    AnimationManager.this.mCallback.onFinished(wealthSeatItem, nextItem);
                    AnimationManager.this.mCallback.onNext(nextItem);
                }
            }

            public void onRepeat() {
            }

            public void onStep(int i, double v) {
                if (i == 100 && null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
                    ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play("wealth_open");
                }
                if (i == 160 && AnimationManager.this.mCallback != null && !wealthSeatItem.hasShowResult()) {
                    FeatureLog.i((String)"FTWealth", (String)"onStep", (Object[])new Object[0]);
                    AnimationManager.this.mCallback.onFinished(wealthSeatItem, nextItem);
                    wealthSeatItem.setHasShowResult(true);
                }
                if (i == 100 && AnimationManager.this.mCallback != null && !this.hasNext) {
                    AnimationManager.this.mCallback.onNext(nextItem);
                    this.hasNext = true;
                }
            }
        });
    }

    private void loadSvga(final SVGAImageView svgaImageView, final WealthSeatItem wealthSeatItem) {
        DyResLoader.INSTANCE.loadSvga(svgaImageView, this.getSvgaKey(), new ISvgaLoadCallback(){

            public void onFinished(final SVGAVideoEntity entity) {
                FeatureLog.i((String)"FTWealth", (String)"onFinished", (Object[])new Object[0]);
                if (wealthSeatItem == null) {
                    FeatureLog.i((String)"FTWealth", (String)"onFinished wealthSeatItem null", (Object[])new Object[0]);
                    return;
                }
                if (wealthSeatItem.getGameResultInfo() == null) {
                    FeatureLog.i((String)"FTWealth", (String)"onFinished gameResult null", (Object[])new Object[0]);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)wealthSeatItem.getGameResultInfo().getGiftUrl())) {
                    Bitmap bitmap = BitmapFactory.decodeResource((Resources)svgaImageView.getResources(), (int)R.drawable.icon_gift_default);
                    AnimationManager.this.loadBitmapToSvga(svgaImageView, bitmap, wealthSeatItem.getGameResultInfo(), entity);
                    return;
                }
                ImageLoader.loadBitmap((Context)svgaImageView.getContext(), (String)wealthSeatItem.getGameResultInfo().getGiftUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        Bitmap bitmap = BitmapFactory.decodeResource((Resources)svgaImageView.getResources(), (int)R.drawable.icon_gift_default);
                        AnimationManager.this.loadBitmapToSvga(svgaImageView, bitmap, wealthSeatItem.getGameResultInfo(), entity);
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        AnimationManager.this.loadBitmapToSvga(svgaImageView, bitmap, wealthSeatItem.getGameResultInfo(), entity);
                    }
                });
            }

            public void onFailed(Exception e) {
                FeatureLog.i((String)"FTWealth", (String)"onFailed:%s", (Object[])new Object[]{e.toString()});
            }
        });
    }

    private DResource getSvgaKey() {
        DResource resourceKey = DR.first_chest;
        WealthConfigData wealthConfigData = WealthDataService.INSTANCE.getWealthDataModel().getConfigData();
        if (wealthConfigData != null) {
            int configId = wealthConfigData.getConfigId();
            if (configId == 1) {
                resourceKey = DR.first_chest;
            } else if (configId == 2) {
                resourceKey = DR.second_chest;
            } else if (configId == 3) {
                resourceKey = DR.third_chest;
            } else if (configId == 4) {
                resourceKey = DR.four_chest;
            }
        }
        return resourceKey;
    }

    private SVGAImageView createSvga(WealthSeatItem wealthSeatItem) {
        if (this.mSeatLocationPresenter == null) {
            return null;
        }
        if (this.mSeatLocationPresenter.isDestroyed()) {
            return null;
        }
        if (this.mSeatLocationPresenter.getSeatLocation(false).getValue() == null) {
            Point point;
            if (this.mSeatPointMap.containsKey(wealthSeatItem.uid) && (point = this.mSeatPointMap.get(wealthSeatItem.uid)) != null && point.y >= 300) {
                SVGAImageView svgaImageView = new SVGAImageView((Context)((IChannelPageContext)this.mSeatLocationPresenter.getMvpContext()).getContext());
                return svgaImageView;
            }
            return null;
        }
        if (((Map)this.mSeatLocationPresenter.getSeatLocation(false).getValue()).containsKey(wealthSeatItem.uid)) {
            Point point = (Point)((Map)this.mSeatLocationPresenter.getSeatLocation(false).getValue()).get(wealthSeatItem.uid);
            if (point != null && point.y < 300) {
                return null;
            }
            SVGAImageView svgaImageView = new SVGAImageView((Context)((IChannelPageContext)this.mSeatLocationPresenter.getMvpContext()).getContext());
            return svgaImageView;
        }
        return null;
    }

    private void loadBitmapToSvga(SVGAImageView svgaImageView, Bitmap bitmap, GameResultInfo gameResultInfo, SVGAVideoEntity entity) {
        SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
        dynamicEntity.setDynamicImage(bitmap, "gift");
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(ColorUtils.parseColor((String)"#ffec00"));
        textPaint.setTextSize(24.0f);
        dynamicEntity.setDynamicText("x" + gameResultInfo.getAmount(), textPaint, "number");
        SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
        svgaImageView.setImageDrawable((Drawable)drawable2);
        svgaImageView.startAnimation();
        WealthDataService.INSTANCE.getWealthDataModel().setSeatPrepareIndex(gameResultInfo.getNextIndex());
    }

    public void clear() {
        this.mWealthSeatItemList.clear();
        this.mCallback = null;
    }

    public void setSeatLocationCallback(IChannelPageContext pageContext, ISeatLocationProvider callback) {
        if (callback == null) {
            FeatureLog.i((String)"FTWealth", (String)"setSeatLocationCallback callback null", (Object[])new Object[0]);
            return;
        }
        callback.getSeatLocation(false).observe((LifecycleOwner)pageContext.getLifecycleOwner(), (Observer)new Observer<Map<Long, Point>>(){

            public void onChanged(@Nullable Map<Long, Point> longPointMap) {
                FeatureLog.i((String)"FTWealth", (String)"onChanged:%s", (Object[])new Object[]{longPointMap});
                if (!FP.empty(longPointMap)) {
                    Set<Long> keySet = longPointMap.keySet();
                    for (long uid : keySet) {
                        AnimationManager.this.mSeatPointMap.put(uid, longPointMap.get(uid));
                    }
                }
            }
        });
    }

    public static interface ISeatAnimationCallback {
        public void onFinished(WealthSeatItem var1, WealthSeatItem var2);

        public void onNext(WealthSeatItem var1);
    }
}

