/*
 * Decompiled with CFR 0.152.
 */
package com.yy.billing.base;

public class PurchaseInfo {
    private final String signature;
    private final String jsonPurchaseInfo;
    private final String orderId;
    private final String productId;
    private final long purchaseTime;
    private final String purchaseToken;
    private final String payload;
    private final boolean isAcknowledged;

    public static Builder newBuilder(String signature, String jsonPurchaseInfo) {
        return new Builder(signature, jsonPurchaseInfo);
    }

    private PurchaseInfo(Builder builder) {
        this.signature = builder.signature;
        this.jsonPurchaseInfo = builder.jsonPurchaseInfo;
        this.orderId = builder.orderId;
        this.productId = builder.productId;
        this.purchaseTime = builder.purchaseTime;
        this.purchaseToken = builder.purchaseToken;
        this.payload = builder.payload;
        this.isAcknowledged = builder.isAcknowledged;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getJsonPurchaseInfo() {
        return this.jsonPurchaseInfo;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getProductId() {
        return this.productId;
    }

    public long getPurchaseTime() {
        return this.purchaseTime;
    }

    public String getPurchaseToken() {
        return this.purchaseToken;
    }

    public String getPayload() {
        return this.payload;
    }

    public boolean isAcknowledged() {
        return this.isAcknowledged;
    }

    public String toString() {
        return "PurchaseInfo{, orderId='" + this.orderId + '\'' + ", productId='" + this.productId + '\'' + ", isAcknowledged='" + this.isAcknowledged + '\'' + ", purchaseToken='" + this.purchaseToken + '\'' + ", payload='" + this.payload + '\'' + '}';
    }

    public static class Builder {
        private String signature = "";
        private String jsonPurchaseInfo = "";
        private String orderId = "";
        private String productId = "";
        private long purchaseTime;
        private String purchaseToken = "";
        private String payload = "";
        private boolean isAcknowledged = true;

        Builder(String signature, String jsonPurchaseInfo) {
            this.signature = signature;
            this.jsonPurchaseInfo = jsonPurchaseInfo;
        }

        public Builder orderId(String val) {
            this.orderId = val;
            return this;
        }

        public Builder productId(String val) {
            this.productId = val;
            return this;
        }

        public Builder purchaseTime(long val) {
            this.purchaseTime = val;
            return this;
        }

        public Builder purchaseToken(String val) {
            this.purchaseToken = val;
            return this;
        }

        public Builder payload(String val) {
            this.payload = val;
            return this;
        }

        public Builder isAcknowledged(boolean val) {
            this.isAcknowledged = val;
            return this;
        }

        public PurchaseInfo build() {
            return new PurchaseInfo(this);
        }
    }
}

