/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.bbs.bussiness.post.postdetail.v2;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.AbsSavedState;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.hiyo.bbs.R;
import com.yy.hiyo.bbs.bussiness.post.postdetail.v2.t;
import com.yy.hiyo.bbs.bussiness.post.postdetail.v2.u;
import com.yy.hiyo.bbs.bussiness.post.postdetail.v2.v;
import com.yy.hiyo.bbs.bussiness.post.postdetail.v2.w;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

@Keep
public class ViewPagerBottomSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_HIDDEN = 5;
    public static final int PEEK_HEIGHT_AUTO = -1;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private float mMinimumVelocity;
    private float mMaximumVelocity;
    private int mPeekHeight;
    private boolean mPeekHeightAuto;
    private int mPeekHeightMin;
    int mMinOffset;
    int mMaxOffset;
    boolean mHideable;
    private boolean mSkipCollapsed;
    int mState = 4;
    ViewDragHelper mViewDragHelper;
    private boolean mIgnoreEvents;
    private boolean mNestedScrolled;
    int mParentHeight;
    WeakReference<V> mViewRef;
    WeakReference<View> mNestedScrollingChildRef;
    private a mCallback;
    private VelocityTracker mVelocityTracker;
    int mActivePointerId;
    private int mInitialY;
    boolean mTouchingScrollingChild;
    private ViewPager.SimpleOnPageChangeListener pageChangeListener = new t(this);
    private final ViewDragHelper.Callback mDragCallback = new v(this);

    public ViewPagerBottomSheetBehavior() {
    }

    public ViewPagerBottomSheetBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.BottomSheetBehavior_Layout);
        TypedValue typedValue = typedArray.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight);
        if (typedValue != null && typedValue.data == -1) {
            this.setPeekHeight(typedValue.data);
        } else {
            this.setPeekHeight(typedArray.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, -1));
        }
        this.setHideable(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setSkipCollapsed(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        typedArray.recycle();
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v2) {
        return new SavedState(super.onSaveInstanceState(coordinatorLayout, v2), this.mState);
    }

    public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v2, Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(coordinatorLayout, v2, savedState.getSuperState());
        this.mState = savedState.state == 1 || savedState.state == 2 ? 4 : savedState.state;
    }

    public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v2, int n2) {
        int n3;
        if (ViewCompat.getFitsSystemWindows((View)coordinatorLayout) && !ViewCompat.getFitsSystemWindows(v2)) {
            ViewCompat.setFitsSystemWindows(v2, (boolean)true);
        }
        int n4 = v2.getTop();
        coordinatorLayout.onLayoutChild(v2, n2);
        this.mParentHeight = coordinatorLayout.getHeight();
        if (this.mPeekHeightAuto) {
            if (this.mPeekHeightMin == 0) {
                this.mPeekHeightMin = coordinatorLayout.getResources().getDimensionPixelSize(R.dimen.design_bottom_sheet_peek_height_min);
            }
            n3 = Math.max(this.mPeekHeightMin, this.mParentHeight - coordinatorLayout.getWidth() * 9 / 16);
        } else {
            n3 = this.mPeekHeight;
        }
        this.mMinOffset = Math.max(0, this.mParentHeight - v2.getHeight());
        this.mMaxOffset = Math.max(this.mParentHeight - n3, this.mMinOffset);
        if (this.mState == 3) {
            ViewCompat.offsetTopAndBottom(v2, (int)this.mMinOffset);
        } else if (this.mHideable && this.mState == 5) {
            ViewCompat.offsetTopAndBottom(v2, (int)this.mParentHeight);
        } else if (this.mState == 4) {
            ViewCompat.offsetTopAndBottom(v2, (int)this.mMaxOffset);
        } else if (this.mState == 1 || this.mState == 2) {
            ViewCompat.offsetTopAndBottom(v2, (int)(n4 - v2.getTop()));
        }
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)coordinatorLayout, (ViewDragHelper.Callback)this.mDragCallback);
        }
        this.mViewRef = new WeakReference<V>(v2);
        this.configViewPager((View)v2);
        this.mNestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)v2));
        return true;
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v2, MotionEvent motionEvent) {
        if (!v2.isShown()) {
            this.mIgnoreEvents = true;
            return false;
        }
        int n2 = motionEvent.getActionMasked();
        if (n2 == 0) {
            this.reset();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        switch (n2) {
            case 1: 
            case 3: {
                this.mTouchingScrollingChild = false;
                this.mActivePointerId = -1;
                if (!this.mIgnoreEvents) break;
                this.mIgnoreEvents = false;
                return false;
            }
            case 0: {
                View view;
                int n3 = (int)motionEvent.getX();
                this.mInitialY = (int)motionEvent.getY();
                View view2 = view = this.mNestedScrollingChildRef != null ? (View)this.mNestedScrollingChildRef.get() : null;
                if (view != null && coordinatorLayout.isPointInChildBounds(view, n3, this.mInitialY)) {
                    this.mActivePointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
                    this.mTouchingScrollingChild = true;
                }
                this.mIgnoreEvents = this.mActivePointerId == -1 && !coordinatorLayout.isPointInChildBounds(v2, n3, this.mInitialY);
                break;
            }
        }
        if (!this.mIgnoreEvents && this.mViewDragHelper.shouldInterceptTouchEvent(motionEvent)) {
            return true;
        }
        View view = (View)this.mNestedScrollingChildRef.get();
        return n2 == 2 && view != null && !this.mIgnoreEvents && this.mState != 1 && !coordinatorLayout.isPointInChildBounds(view, (int)motionEvent.getX(), (int)motionEvent.getY()) && Math.abs((float)this.mInitialY - motionEvent.getY()) > (float)this.mViewDragHelper.getTouchSlop();
    }

    public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v2, MotionEvent motionEvent) {
        if (!v2.isShown()) {
            return false;
        }
        int n2 = motionEvent.getActionMasked();
        if (this.mState == 1 && n2 == 0) {
            return true;
        }
        if (this.mViewDragHelper != null) {
            this.mViewDragHelper.processTouchEvent(motionEvent);
        }
        if (n2 == 0) {
            this.reset();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        if (n2 == 2 && !this.mIgnoreEvents && Math.abs((float)this.mInitialY - motionEvent.getY()) > (float)this.mViewDragHelper.getTouchSlop()) {
            this.mViewDragHelper.captureChildView(v2, motionEvent.getPointerId(motionEvent.getActionIndex()));
        }
        return !this.mIgnoreEvents;
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, View view2, int n2) {
        this.mNestedScrolled = false;
        return (n2 & 2) != 0;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2, int n3, int[] nArray) {
        int n4 = v2.getTop();
        int n5 = n4 - n3;
        if (n3 > 0) {
            if (n5 < this.mMinOffset) {
                nArray[1] = n4 - this.mMinOffset;
                ViewCompat.offsetTopAndBottom(v2, (int)(-nArray[1]));
                this.setStateInternal(3);
            } else {
                nArray[1] = n3;
                ViewCompat.offsetTopAndBottom(v2, (int)(-n3));
                this.setStateInternal(1);
            }
        } else if (n3 < 0 && !view.canScrollVertically(-1)) {
            if (n5 <= this.mMaxOffset || this.mHideable) {
                nArray[1] = n3;
                ViewCompat.offsetTopAndBottom(v2, (int)(-n3));
                this.setStateInternal(1);
            } else {
                nArray[1] = n4 - this.mMaxOffset;
                ViewCompat.offsetTopAndBottom(v2, (int)(-nArray[1]));
                this.setStateInternal(4);
            }
        }
        this.dispatchOnSlide(v2.getTop());
        this.mNestedScrolled = true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view) {
        int n2;
        int n3;
        if (v2.getTop() == this.mMinOffset) {
            this.setStateInternal(3);
            return;
        }
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
        float f2 = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
        float f3 = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
        if (f3 < 0.0f && Math.abs(f3) > this.mMinimumVelocity && Math.abs(f3) > Math.abs(f2)) {
            n3 = this.mMinOffset;
            n2 = 3;
        } else if (this.mHideable && this.shouldHide((View)v2, f3)) {
            n3 = this.mParentHeight;
            n2 = 5;
        } else if (f3 > 0.0f && Math.abs(f3) > this.mMinimumVelocity && Math.abs(f3) > Math.abs(f2)) {
            n3 = this.mMaxOffset;
            n2 = 4;
        } else {
            int n4 = v2.getTop();
            if (Math.abs(n4 - this.mMinOffset) < Math.abs(n4 - this.mMaxOffset)) {
                n3 = this.mMinOffset;
                n2 = 3;
            } else {
                n3 = this.mMaxOffset;
                n2 = 4;
            }
        }
        if (this.mViewDragHelper.smoothSlideViewTo(v2, v2.getLeft(), n3)) {
            this.setStateInternal(2);
            ViewCompat.postOnAnimation(v2, (Runnable)new b((View)v2, n2));
        } else {
            this.setStateInternal(n2);
        }
        this.mNestedScrolled = false;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v2, View view, float f2, float f3) {
        return view == this.mNestedScrollingChildRef.get() && (this.mState != 3 || super.onNestedPreFling(coordinatorLayout, v2, view, f2, f3));
    }

    void invalidateScrollingChild() {
        View view = this.findScrollingChild((View)this.mViewRef.get());
        this.mNestedScrollingChildRef = new WeakReference<View>(view);
    }

    public final void setPeekHeight(int n2) {
        View view;
        boolean bl2 = false;
        if (n2 == -1) {
            if (!this.mPeekHeightAuto) {
                this.mPeekHeightAuto = true;
                bl2 = true;
            }
        } else if (this.mPeekHeightAuto || this.mPeekHeight != n2) {
            this.mPeekHeightAuto = false;
            this.mPeekHeight = Math.max(0, n2);
            this.mMaxOffset = this.mParentHeight - n2;
            bl2 = true;
        }
        if (bl2 && this.mState == 4 && this.mViewRef != null && (view = (View)this.mViewRef.get()) != null) {
            view.requestLayout();
        }
    }

    public final int getPeekHeight() {
        return this.mPeekHeightAuto ? -1 : this.mPeekHeight;
    }

    public void setHideable(boolean bl2) {
        this.mHideable = bl2;
    }

    public boolean isHideable() {
        return this.mHideable;
    }

    public void setSkipCollapsed(boolean bl2) {
        this.mSkipCollapsed = bl2;
    }

    public boolean getSkipCollapsed() {
        return this.mSkipCollapsed;
    }

    public void setBottomSheetCallback(a a2) {
        this.mCallback = a2;
    }

    public final void setState(int n2) {
        if (n2 == this.mState) {
            return;
        }
        if (this.mViewRef == null) {
            if (n2 == 4 || n2 == 3 || this.mHideable && n2 == 5) {
                this.mState = n2;
            }
            return;
        }
        View view = (View)this.mViewRef.get();
        if (view == null) {
            return;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent != null && viewParent.isLayoutRequested() && ViewCompat.isAttachedToWindow((View)view)) {
            view.post((Runnable)new u(this, view, n2));
        } else {
            this.startSettlingAnimation(view, n2);
        }
    }

    public final int getState() {
        return this.mState;
    }

    void setStateInternal(int n2) {
        if (this.mState == n2) {
            return;
        }
        this.mState = n2;
        View view = (View)this.mViewRef.get();
        if (view != null && this.mCallback != null) {
            this.mCallback.a(view, n2);
        }
    }

    private void reset() {
        this.mActivePointerId = -1;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    boolean shouldHide(View view, float f2) {
        if (this.mSkipCollapsed) {
            return true;
        }
        if (view.getTop() < this.mMaxOffset) {
            return false;
        }
        float f3 = (float)view.getTop() + f2 * 0.1f;
        return Math.abs(f3 - (float)this.mMaxOffset) / (float)this.mPeekHeight > 0.5f;
    }

    private void configViewPager(View view) {
        YYViewPager yYViewPager;
        if (!(view instanceof ViewGroup)) {
            return;
        }
        if (view instanceof YYViewPager) {
            yYViewPager = (YYViewPager)view;
            yYViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            yYViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
        }
        yYViewPager = (ViewGroup)view;
        for (int i2 = 0; i2 < yYViewPager.getChildCount(); ++i2) {
            this.configViewPager(yYViewPager.getChildAt(i2));
        }
    }

    @VisibleForTesting
    View findScrollingChild(View view) {
        if (view == null || ViewCompat.isNestedScrollingEnabled((View)view)) {
            return view;
        }
        if (view instanceof YYViewPager) {
            YYViewPager yYViewPager = (YYViewPager)view;
            View view2 = yYViewPager.getCurrentView(yYViewPager.getCurrentItem());
            View view3 = this.findScrollingChild(view2);
            if (view3 != null) {
                return view3;
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n2 = viewGroup.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view4 = this.findScrollingChild(viewGroup.getChildAt(i2));
                if (view4 == null) continue;
                return view4;
            }
        }
        return null;
    }

    private float getYVelocity() {
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
        return this.mVelocityTracker.getYVelocity(this.mActivePointerId);
    }

    void startSettlingAnimation(View view, int n2) {
        int n3;
        if (n2 == 4) {
            n3 = this.mMaxOffset;
        } else if (n2 == 3) {
            n3 = this.mMinOffset;
        } else if (this.mHideable && n2 == 5) {
            n3 = this.mParentHeight;
        } else {
            throw new IllegalArgumentException("Illegal state argument: " + n2);
        }
        if (this.mViewDragHelper.smoothSlideViewTo(view, view.getLeft(), n3)) {
            this.setStateInternal(2);
            ViewCompat.postOnAnimation((View)view, (Runnable)new b(view, n2));
        } else {
            this.setStateInternal(n2);
        }
    }

    void dispatchOnSlide(int n2) {
        View view = (View)this.mViewRef.get();
        if (view != null && this.mCallback != null) {
            if (n2 > this.mMaxOffset) {
                this.mCallback.a(view, (float)(this.mMaxOffset - n2) / (float)(this.mParentHeight - this.mMaxOffset));
            } else {
                this.mCallback.a(view, (float)(this.mMaxOffset - n2) / (float)(this.mMaxOffset - this.mMinOffset));
            }
        }
    }

    @VisibleForTesting
    int getPeekHeightMin() {
        return this.mPeekHeightMin;
    }

    public static <V extends View> ViewPagerBottomSheetBehavior<V> from(V v2) {
        ViewGroup.LayoutParams layoutParams = v2.getLayoutParams();
        if (!(layoutParams instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)layoutParams).getBehavior();
        if (!(behavior instanceof ViewPagerBottomSheetBehavior)) {
            throw new IllegalArgumentException("The view is not associated with ViewPagerBottomSheetBehavior");
        }
        return (ViewPagerBottomSheetBehavior)behavior;
    }

    static /* synthetic */ float access$000(ViewPagerBottomSheetBehavior viewPagerBottomSheetBehavior) {
        return viewPagerBottomSheetBehavior.mMinimumVelocity;
    }

    protected static class SavedState
    extends AbsSavedState {
        final int state;
        public static final Parcelable.Creator<SavedState> CREATOR = new w();

        public SavedState(Parcel parcel) {
            this(parcel, null);
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.state = parcel.readInt();
        }

        public SavedState(Parcelable parcelable, int n2) {
            super(parcelable);
            this.state = n2;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.state);
        }
    }

    private class b
    implements Runnable {
        private final View b;
        private final int c;

        b(View view, int n2) {
            this.b = view;
            this.c = n2;
        }

        @Override
        public void run() {
            if (ViewPagerBottomSheetBehavior.this.mViewDragHelper != null && ViewPagerBottomSheetBehavior.this.mViewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.b, (Runnable)this);
            } else {
                ViewPagerBottomSheetBehavior.this.setStateInternal(this.c);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface State {
    }

    public static abstract class a {
        public abstract void a(@NonNull View var1, int var2);

        public abstract void a(@NonNull View var1, float var2);
    }
}

