/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.appbase.R;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import java.util.ArrayList;
import java.util.List;

public class MultiAvatarView
extends YYRelativeLayout {
    private static final int MAX_ITEM = 5;
    private int avatarSize;
    private int avatarSpace;
    private int avatarBorderSize;
    private static int[] ids = new int[]{R.id.multi_avatar_1, R.id.multi_avatar_2, R.id.multi_avatar_3, R.id.multi_avatar_4, R.id.multi_avatar_5};
    private List<CircleImageView> circleImageViewList;
    private List<String> avatarUrls;

    public MultiAvatarView(Context context) {
        this(context, null);
    }

    public MultiAvatarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultiAvatarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MultiAvatarView);
        this.avatarSize = ta.getDimensionPixelSize(R.styleable.MultiAvatarView_avatarSize, ResolutionUtils.dip2Px((float)50.0f));
        this.avatarSpace = ta.getDimensionPixelSize(R.styleable.MultiAvatarView_avatarSpace, -ResolutionUtils.dip2Px((float)10.0f));
        this.avatarBorderSize = ta.getDimensionPixelSize(R.styleable.MultiAvatarView_avatarBorderWidth, ResolutionUtils.dip2Px((float)3.0f));
        ta.recycle();
        this.initView();
    }

    private void initView() {
        if (NAB.B.equals(NewABDefine.BBS_SCROLL_OPT.getTest())) {
            this.circleImageViewList = this.createAvatarViewsNew();
            this.addAvatarViewsNew();
        }
    }

    private void setUrlsOld(List<String> avatarUrls) {
        List<CircleImageView> circleImageViewList = this.createAvatarViewsOld(avatarUrls);
        this.addAvatarViewsOld(circleImageViewList);
    }

    private List<CircleImageView> createAvatarViewsOld(List<String> userInfoList) {
        int startIndex;
        ArrayList<CircleImageView> circleImageViewList = new ArrayList<CircleImageView>(5);
        for (int i = startIndex = Math.min(4, userInfoList.size() - 1); i >= 0; --i) {
            String avatar = userInfoList.get(i);
            CircleImageView circleImageView = new CircleImageView(this.getContext());
            circleImageView.setBorderColor(-1);
            circleImageView.setBorderWidth(this.avatarBorderSize);
            circleImageViewList.add(circleImageView);
            String url = avatar + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((ImageView)circleImageView, (String)url, (int)0, (int)AvatarUtils.getDefaultAvatar(0));
        }
        return circleImageViewList;
    }

    private void addAvatarViewsOld(List<CircleImageView> avatarViewList) {
        for (int i = 0; i < avatarViewList.size() && i < 5; ++i) {
            CircleImageView avatarView = avatarViewList.get(i);
            avatarView.setId(ids[i]);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.avatarSize, this.avatarSize);
            if (i == 0) {
                lp.addRule(11);
                lp.addRule(21);
            } else {
                int rightMargin;
                int toLeftOfId = ids[i - 1];
                lp.addRule(0, toLeftOfId);
                lp.rightMargin = rightMargin = this.avatarSpace;
                lp.addRule(16, toLeftOfId);
                lp.setMarginEnd(rightMargin);
            }
            this.addView((View)avatarView, (ViewGroup.LayoutParams)lp);
        }
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp != null) {
            int avatarCount = avatarViewList.size();
            lp.width = avatarCount == 0 ? 0 : this.avatarSize * avatarCount + this.avatarSpace * (avatarCount - 1);
        }
    }

    public void setUrls(List<String> avatarUrls) {
        if (NAB.B.equals(NewABDefine.BBS_SCROLL_OPT.getTest())) {
            MLog.info((Object)"MultiAvatarView", (String)"hit b !", (Object[])new Object[0]);
            this.setUrlsNew(avatarUrls);
            return;
        }
        this.setUrlsOld(avatarUrls);
    }

    private void setUrlsNew(List<String> avatarUrls) {
        this.avatarUrls = avatarUrls;
        if (FP.empty(this.circleImageViewList)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            CircleImageView circleImageView = this.circleImageViewList.get(i);
            if (i <= avatarUrls.size() - 1) {
                String url = avatarUrls.get(i) + YYImageUtils.getThumbnailPostfix((int)75);
                circleImageView.setVisibility(0);
                ImageLoader.loadImage((ImageView)circleImageView, (String)url, (int)0, (int)AvatarUtils.getDefaultAvatar(0));
                continue;
            }
            circleImageView.setVisibility(8);
        }
        int avatarCount = avatarUrls.size();
        int width = avatarCount == 0 ? 0 : this.avatarSize * avatarCount + this.avatarSpace * (avatarCount - 1);
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp != null) {
            lp.width = width;
        }
    }

    private List<CircleImageView> createAvatarViewsNew() {
        ArrayList<CircleImageView> circleImageViewList = new ArrayList<CircleImageView>(5);
        int startIndex = 4;
        for (int i = 0; i < startIndex; ++i) {
            CircleImageView circleImageView = new CircleImageView(this.getContext());
            circleImageView.setBorderColor(-1);
            circleImageView.setBorderWidth(this.avatarBorderSize);
            circleImageView.setVisibility(8);
            circleImageViewList.add(circleImageView);
        }
        return circleImageViewList;
    }

    private void addAvatarViewsNew() {
        for (int i = 0; i < 4; ++i) {
            CircleImageView avatarView = this.circleImageViewList.get(i);
            avatarView.setId(ids[i]);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.avatarSize, this.avatarSize);
            if (i == 0) {
                lp.addRule(9);
                lp.addRule(20);
            } else {
                int rightMargin;
                int toLeftOfId = ids[i - 1];
                lp.addRule(1, toLeftOfId);
                lp.leftMargin = rightMargin = this.avatarSpace;
                lp.addRule(17, toLeftOfId);
                lp.setMarginStart(rightMargin);
            }
            this.addView((View)avatarView, (ViewGroup.LayoutParams)lp);
        }
    }

    public void setAvatarSize(int avatarSize) {
        this.avatarSize = avatarSize;
        this.invalidate();
    }

    public void setAvatarSpace(int avatarSpace) {
        this.avatarSpace = avatarSpace;
        this.invalidate();
    }

    public void setAvatarBorderSize(int size) {
        this.avatarBorderSize = size;
        this.invalidate();
    }
}

