/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import com.yy.appbase.R;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/yy/appbase/util/ZodiacUtils;", "", "()V", "mArr", "", "mZodiacIcons", "mZodiacTexts", "getZodiac", "", "birday", "getZodiacIcon", "", "getZodiacIndex", "appbase_debug"})
public final class ZodiacUtils {
    private static final int[] mArr;
    private static final int[] mZodiacTexts;
    private static final int[] mZodiacIcons;
    public static final ZodiacUtils INSTANCE;

    @NotNull
    public final String getZodiac(@Nullable String birday) {
        int index = this.getZodiacIndex(birday);
        if (index < 0 || index >= mZodiacTexts.length) {
            index = 0;
        }
        String string2 = ResourceUtils.getString((int)mZodiacTexts[index]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(mZodiacTexts[index])");
        return string2;
    }

    public final int getZodiacIcon(@Nullable String birday) {
        int index = this.getZodiacIndex(birday);
        if (index < 0 || index >= mZodiacIcons.length) {
            index = 0;
        }
        return mZodiacIcons[index];
    }

    private final int getZodiacIndex(String birday) {
        if (FP.empty((CharSequence)birday)) {
            return 0;
        }
        try {
            Calendar cal;
            Date date = DateUtils.getDateFromStr((String)birday, (String)"yyyy-MM-dd");
            if (date == null) {
                date = DateUtils.getDateFromStr((String)birday, (String)"yyyy - MM - dd");
            }
            Calendar calendar = cal = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
            calendar.setTime(date);
            int monthBirth = cal.get(2);
            int dayOfMonthBirth = cal.get(5);
            int index = monthBirth + 1;
            if (dayOfMonthBirth < mArr[monthBirth]) {
                --index;
            }
            return index;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    private ZodiacUtils() {
    }

    static {
        ZodiacUtils zodiacUtils;
        INSTANCE = zodiacUtils = new ZodiacUtils();
        mArr = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
        mZodiacTexts = new int[]{R.string.capricorn, R.string.aquarius, R.string.pisces, R.string.aries, R.string.taurus, R.string.gemini, R.string.cancer, R.string.leo, R.string.virgo, R.string.libra, R.string.scorpio, R.string.sagittarius, R.string.capricorn};
        mZodiacIcons = new int[]{R.drawable.icon_zodiac_capricorn, R.drawable.icon_zodiac_aquarius, R.drawable.icon_zodiac_pisces, R.drawable.icon_zodiac_aries, R.drawable.icon_zodiac_taurus, R.drawable.icon_zodiac_gemini, R.drawable.icon_zodiac_cancer, R.drawable.icon_zodiac_leo, R.drawable.icon_zodiac_virgo, R.drawable.icon_zodiac_libra, R.drawable.icon_zodiac_scorpio, R.drawable.icon_zodiac_sagittarius, R.drawable.icon_zodiac_capricorn};
    }
}

