/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import java.util.concurrent.ConcurrentHashMap;

public class RepeatClickUtils {
    private static final long DEFAULT_CLICKTIME = 1000L;
    private volatile boolean isEnable = true;
    private static ConcurrentHashMap<String, Long> repeatHash = new ConcurrentHashMap();

    public static synchronized boolean canRepeatClick() {
        return RepeatClickUtils.canRepeatClick("default_key");
    }

    public static synchronized boolean canRepeatClick(String key) {
        return RepeatClickUtils.canRepeatClick(key, 1000L);
    }

    public static synchronized boolean canRepeatClick(String key, long gapTime) {
        if (repeatHash != null) {
            if (repeatHash.get(key) == null) {
                repeatHash.put(key, System.currentTimeMillis());
                return true;
            }
            long lastTime = repeatHash.get(key);
            long curTs = System.currentTimeMillis();
            if (curTs - lastTime > gapTime || curTs < lastTime) {
                repeatHash.put(key, curTs);
                return true;
            }
            return false;
        }
        return true;
    }
}

