/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class AssetIndex {
    private static final String TAG = "assetIndex";
    private static SoftReference<List<String>> assetFileListCache;

    public static String[] list(String path) throws IOException {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        boolean enableAssetIndex = SettingFlags.getBoolean((String)"asset_index_enable_switch", (boolean)true);
        MLog.debug((Object)TAG, (String)("enableAssetIndex:" + enableAssetIndex), (Object[])new Object[0]);
        if (enableAssetIndex && !RuntimeContext.isHagoPartySdk()) {
            boolean hasAssetIndexList;
            List<String> assetFileList = AssetIndex.getAssetIndexList();
            boolean bl = hasAssetIndexList = assetFileList != null && !assetFileList.isEmpty();
            if (hasAssetIndexList) {
                ArrayList<String> fileInDirectory = new ArrayList<String>();
                String directory = path;
                if (!directory.endsWith(File.separator)) {
                    directory = directory + File.separator;
                }
                for (String file : assetFileList) {
                    if (!file.startsWith(directory)) continue;
                    String rest = file.substring(directory.length());
                    fileInDirectory.add(rest);
                }
                MLog.debug((Object)TAG, (String)"by asset index", (Object[])new Object[0]);
                return fileInDirectory.toArray(new String[fileInDirectory.size()]);
            }
        }
        try {
            MLog.debug((Object)TAG, (String)"by  assetmanager list(path)", (Object[])new Object[0]);
            return RuntimeContext.sApplicationContext.getAssets().list(path);
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (String)"list() error", (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAssetIndexList() {
        List<String> cacheList;
        boolean assetIndexListCacheEnable = SettingFlags.getBoolean((String)"asset_index_list_cache_switch", (boolean)true);
        if (assetIndexListCacheEnable && (cacheList = AssetIndex.getAssetFileListCache()) != null) {
            MLog.debug((Object)TAG, (String)"getAssetIndexList() by cache list", (Object[])new Object[0]);
            return cacheList;
        }
        ArrayList<String> assetFileList = new ArrayList<String>();
        InputStream in = null;
        BufferedReader buffReader = null;
        try {
            String line;
            in = RuntimeContext.sApplicationContext.getAssets().open("assets.index");
            buffReader = new BufferedReader(new InputStreamReader(in));
            while ((line = buffReader.readLine()) != null) {
                assetFileList.add(line);
            }
            MLog.debug((Object)TAG, (String)"create index from assets", (Object[])new Object[0]);
        }
        catch (IOException e) {
            try {
                MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(in);
                IOUtils.safeClose(buffReader);
                throw throwable;
            }
            IOUtils.safeClose((Closeable)in);
            IOUtils.safeClose((Closeable)buffReader);
        }
        IOUtils.safeClose((Closeable)in);
        IOUtils.safeClose((Closeable)buffReader);
        if (assetIndexListCacheEnable) {
            AssetIndex.setAssetFileListCache(assetFileList);
            MLog.debug((Object)TAG, (String)"getAssetIndexList() and do cache", (Object[])new Object[0]);
        }
        return assetFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAssetFileListCache() {
        Class<AssetIndex> clazz = AssetIndex.class;
        synchronized (AssetIndex.class) {
            if (assetFileListCache != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return assetFileListCache.get();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAssetFileListCache(List<String> assetFileList) {
        if (assetFileList.isEmpty()) {
            return;
        }
        Class<AssetIndex> clazz = AssetIndex.class;
        synchronized (AssetIndex.class) {
            assetFileListCache = new SoftReference<List<String>>(assetFileList);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

