/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.user;

import com.yy.appbase.data.UserInfoExt;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.IQueryUserBy3rdAccountCallBack;
import com.yy.appbase.user.IGetUserInfoExtCallBack;
import com.yy.base.utils.StringUtils;
import com.yy.socialplatformbase.data.UserBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class UserInfoExtHelper {
    public static void getUserExtListByFacebookUsers(IUserInfoService userInfoService, final ArrayList<UserBaseInfo> facebookUserList, final IGetUserInfoExtCallBack callBack) {
        if (userInfoService == null || facebookUserList == null || facebookUserList.size() <= 0) {
            if (callBack != null) {
                callBack.onError("11113", new RuntimeException());
            }
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (UserBaseInfo info : facebookUserList) {
            if (info == null || !StringUtils.isNotEmpty((String)info.getUserId())) continue;
            ids.add(info.getUserId());
        }
        userInfoService.getUserInfoByThirdPartyAccount(ids, new IQueryUserBy3rdAccountCallBack(){

            @Override
            public void onSuccess(HashMap<String, UserInfoKS> hagoUserInfos) {
                ArrayList userInfoExts = UserInfoExtHelper.composeUserInfoExt(facebookUserList, hagoUserInfos);
                if (callBack != null) {
                    callBack.onSuccess(userInfoExts);
                }
            }

            @Override
            public void onError(String errorCode, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
            }
        });
    }

    private static ArrayList<UserInfoExt> composeUserInfoExt(ArrayList<UserBaseInfo> list, HashMap<String, UserInfoKS> hagoUserInfos) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        ArrayList<UserInfoExt> userInfoExts = new ArrayList<UserInfoExt>(list.size());
        UserInfoExt item = null;
        for (UserBaseInfo info : list) {
            if (info == null) continue;
            item = new UserInfoExt();
            item.mThirdPartyUserInfo = info;
            item.mOurUserInfo = hagoUserInfos != null ? hagoUserInfos.get(info.getUserId()) : null;
            userInfoExts.add(item);
        }
        return userInfoExts;
    }
}

