/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class VoiceRoomFollowConfig
extends AConfigData {
    private static final String TAG = "VoiceRoomFollowConfig";
    private int mFollowTime = 180;
    private int mNewRegisterFollowTime = 60;
    private int mFollowCount = 3;
    private int mRadioFollowTime = 1;
    private int mNewRegisterRadioFollowTime = 50;
    private int mFollowGuideTimes = 3;
    private int mNewRegisterFollowGuideTimes = 3;
    private int mFollowFloatGuideSecond = 10;
    private int mNewRegisterFollowFloatGuideSecond = 90;
    private int mFloatingSecond = 10;
    private List<Integer> mPluginModeList = new ArrayList<Integer>();
    private int mRadioVideoFollowTime = 90;
    private int mNewRegisterRadioVideoFollowTime = 45;
    private int mFollowPeopleCount = 6;
    private int mNewRegisterMultiVideoFollowTime = 45;
    private long mFollowShowTime = 10000L;
    private long mFollowDelayTime = 10000L;

    @Override
    public BssCode getBssCode() {
        return BssCode.VOICE_ROOM_FOLLOW;
    }

    @Override
    public void parseConfig(String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            FeatureLog.d((String)"FTVoiceRoomFollow", (String)"configs %s", (Object[])new Object[]{configs});
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)configs);
            if (jsonObject.has("follow_time")) {
                this.mFollowTime = jsonObject.optInt("follow_time");
            }
            this.mNewRegisterFollowTime = jsonObject.optInt("new_register_follow_time", this.mNewRegisterFollowTime);
            if (jsonObject.has("follow_count")) {
                this.mFollowCount = jsonObject.optInt("follow_count");
            }
            if (jsonObject.has("radio_follow_time")) {
                this.mRadioFollowTime = jsonObject.optInt("radio_follow_time");
            }
            this.mNewRegisterRadioFollowTime = jsonObject.optInt("new_register_radio_follow_time", this.mNewRegisterRadioFollowTime);
            if (jsonObject.has("radio_video_follow_time")) {
                this.mRadioVideoFollowTime = jsonObject.optInt("radio_video_follow_time");
            }
            this.mNewRegisterRadioVideoFollowTime = jsonObject.optInt("new_register_radio_video_follow_time", this.mNewRegisterRadioVideoFollowTime);
            this.mNewRegisterMultiVideoFollowTime = jsonObject.optInt("new_register_multi_video_follow_time", this.mNewRegisterMultiVideoFollowTime);
            if (jsonObject.has("follow_guide_times")) {
                this.mFollowGuideTimes = jsonObject.optInt("follow_guide_times");
            }
            this.mNewRegisterFollowGuideTimes = jsonObject.optInt("new_register_follow_guide_times", this.mNewRegisterFollowGuideTimes);
            if (jsonObject.has("follow_float_guide_second")) {
                this.mFollowFloatGuideSecond = jsonObject.optInt("follow_float_guide_second");
            }
            this.mNewRegisterFollowFloatGuideSecond = jsonObject.optInt("new_register_follow_float_guide_second", this.mNewRegisterFollowFloatGuideSecond);
            if (jsonObject.has("floating_time")) {
                this.mFloatingSecond = jsonObject.optInt("floating_time");
            }
            if (jsonObject.has("follow_show_time")) {
                this.mFollowShowTime = jsonObject.optLong("follow_show_time");
            }
            if (jsonObject.has("follow_delay_show_time")) {
                this.mFollowDelayTime = jsonObject.optLong("follow_delay_show_time");
            }
            if (jsonObject.has("follow_people_count")) {
                this.mFollowPeopleCount = jsonObject.optInt("follow_people_count");
            }
            if (jsonObject.has("plugin_modes")) {
                String modeStr = jsonObject.optString("plugin_modes", "");
                String[] modes = modeStr.split(",");
                try {
                    for (String mode : modes) {
                        this.mPluginModeList.add(Integer.parseInt(mode));
                    }
                }
                catch (NumberFormatException e) {
                    MLog.error((Object)TAG, (String)"parse plugin_modes failed ", (Throwable)e, (Object[])new Object[0]);
                }
            }
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"parseConfig\uff0cfollowTime:%s\uff0cfollowCount:%s", (Object[])new Object[]{this.mFollowTime, this.mFollowCount});
        }
        catch (Throwable e) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    public int getFollowPeopleCount() {
        return this.mFollowPeopleCount;
    }

    public long getFollowDelayTime() {
        return this.mFollowDelayTime;
    }

    public long getFollowShowTime() {
        return this.mFollowShowTime;
    }

    public int getFollowFloatGuideSecond() {
        return this.mFollowFloatGuideSecond;
    }

    public int getFloatingSecond() {
        return this.mFloatingSecond;
    }

    public int getFollowGuideTimes() {
        return this.mFollowGuideTimes;
    }

    public int getFollowTime() {
        return this.mFollowTime;
    }

    public int getRadioFollowTime() {
        return this.mRadioFollowTime;
    }

    public int getFollowCount() {
        return this.mFollowCount;
    }

    public int getRadioVideoFollowTime() {
        return this.mRadioVideoFollowTime;
    }

    public List<Integer> getFollowPluginModes() {
        return this.mPluginModeList;
    }

    public int getNewRegisterFollowTime() {
        return this.mNewRegisterFollowTime;
    }

    public int getNewRegisterRadioFollowTime() {
        return this.mNewRegisterRadioFollowTime;
    }

    public int getNewRegisterRadioVideoFollowTime() {
        return this.mNewRegisterRadioVideoFollowTime;
    }

    public int getNewRegisterFollowFloatGuideSecond() {
        return this.mNewRegisterFollowFloatGuideSecond;
    }

    public int getNewRegisterFollowGuideTimes() {
        return this.mNewRegisterFollowGuideTimes;
    }

    public int getNewRegisterMultiVideoFollowTime() {
        return this.mNewRegisterMultiVideoFollowTime;
    }
}

