/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONObject;

public class RiskTipsConfig
extends AConfigData {
    private static final String TAG = "RiskTipsConfig";
    private boolean mSwitch = false;
    private String mContent;
    private int times = 1;
    private boolean serverSwitch = false;

    @Override
    public BssCode getBssCode() {
        return BssCode.RISK_TIPS_CONFIG;
    }

    @Override
    public void parseConfig(String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"configs %s", (Object[])new Object[]{configs});
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)configs);
            if (jsonObject.has("switch")) {
                this.mSwitch = jsonObject.optBoolean("switch", false);
            }
            if (jsonObject.has("txt")) {
                this.mContent = jsonObject.optString("txt");
            }
            if (jsonObject.has("tips_times")) {
                this.times = jsonObject.optInt("tips_times");
            }
            if (jsonObject.has("service_switch")) {
                this.serverSwitch = jsonObject.optBoolean("service_switch", false);
            }
            MLog.info((Object)TAG, (String)"parseConfig\uff0cRiskTipsConfig:switch=%s, times = %s", (Object[])new Object[]{this.mSwitch, this.times});
        }
        catch (Throwable e) {
            MLog.info((Object)TAG, (String)"parseConfig %s error", (Object[])new Object[]{configs});
        }
    }

    public boolean isServerSwitch() {
        return this.serverSwitch;
    }

    public boolean isSwitch() {
        return this.mSwitch;
    }

    public String getContent() {
        return this.mContent;
    }

    public int getTimes() {
        return this.times;
    }
}

