/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;

public class RevenueDomainConfig
extends AConfigData {
    private Config config;
    private static Config DEFAULT_CONFIG = new Config();

    @Override
    public BssCode getBssCode() {
        return BssCode.REVENUE_DOMAIN_ROUTE;
    }

    @Override
    public void parseConfig(String configs) {
        MLog.info((Object)"RevenueDomainConfig", (String)configs, (Object[])new Object[0]);
        this.config = (Config)JsonParser.parseJsonObject((String)configs, Config.class);
    }

    @Override
    public boolean parseDefault() {
        MLog.info((Object)"RevenueDomainConfig", (String)"parseDefault", (Object[])new Object[0]);
        this.config = DEFAULT_CONFIG;
        return true;
    }

    public String getBucket(String country) {
        String bucket = "";
        if (this.config != null) {
            bucket = this.findBucket(this.config, country);
        }
        if (TextUtils.isEmpty((CharSequence)bucket)) {
            bucket = this.findBucket(DEFAULT_CONFIG, country);
        }
        bucket = TextUtils.isEmpty((CharSequence)bucket) ? RevenueDomainConfig.DEFAULT_CONFIG.defaultInfo.getBucket() : bucket;
        return bucket;
    }

    public String getBackup(String bucket) {
        String backup = "";
        if (this.config != null) {
            backup = this.findBackup(this.config, bucket);
        }
        if (TextUtils.isEmpty((CharSequence)backup)) {
            backup = this.findBackup(DEFAULT_CONFIG, bucket);
        }
        backup = TextUtils.isEmpty((CharSequence)backup) ? RevenueDomainConfig.DEFAULT_CONFIG.defaultInfo.getBackup() : backup;
        return backup;
    }

    private String findBucket(Config config, String country) {
        String bucket = "";
        if (!FP.empty(config.routeList)) {
            bucket = this.findBucket(config.routeList, country);
        }
        bucket = TextUtils.isEmpty((CharSequence)bucket) ? config.defaultInfo.getBucket() : bucket;
        return bucket;
    }

    private String findBackup(Config config, String bucket) {
        if (config == null || FP.empty(config.routeList)) {
            return "";
        }
        for (DomainInfo info : config.routeList) {
            if (!StringUtils.equalsIgnoreCase((String)bucket, (String)info.getBucket())) continue;
            return info.getBackup();
        }
        return "";
    }

    private String findBucket(List<DomainInfo> routeList, String country) {
        DomainInfo info = this.findDomain(routeList, country);
        return info == null ? "" : info.getBucket();
    }

    private DomainInfo findDomain(List<DomainInfo> routeList, String country) {
        if (FP.empty(routeList)) {
            return null;
        }
        for (DomainInfo info : routeList) {
            if (!StringUtils.equalsIgnoreCase((String)country, (String)info.getCountry())) continue;
            return info;
        }
        return null;
    }

    static {
        RevenueDomainConfig.DEFAULT_CONFIG.defaultBucket = "yjd";
        RevenueDomainConfig.DEFAULT_CONFIG.defaultInfo = new DomainInfo("ID", "yjd", "yjd-proxy-turnover.ihago.net");
        RevenueDomainConfig.DEFAULT_CONFIG.routeList = new ArrayList<DomainInfo>();
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("ID", "yjd", "yjd-proxy-turnover.ihago.net"));
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("IN", "mm", "mm-proxy-turnover.ihago.net"));
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("SG", "jlp", "jlb-proxy-turnover.ihago.net"));
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("US", "gg", ""));
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("AE", "db", ""));
        RevenueDomainConfig.DEFAULT_CONFIG.routeList.add(new DomainInfo("BR", "sbl", ""));
    }

    public static class DomainInfo {
        @SerializedName(value="country")
        private String country = "";
        @SerializedName(value="bucket")
        private String bucket = "";
        @SerializedName(value="backup")
        private String backup = "";

        public DomainInfo(String country, String bucket, String backup) {
            this.country = country == null ? "" : country;
            this.bucket = bucket == null ? "" : bucket;
            this.backup = backup == null ? "" : backup;
        }

        public String getCountry() {
            return this.country == null ? "" : this.country;
        }

        public String getBucket() {
            return this.bucket == null ? "" : this.bucket;
        }

        public String getBackup() {
            return this.backup == null ? "" : this.backup;
        }
    }

    private static class Config {
        @SerializedName(value="defaultBucket")
        @Deprecated
        public String defaultBucket;
        @SerializedName(value="defaultInfo")
        public DomainInfo defaultInfo;
        @SerializedName(value="routeList")
        public List<DomainInfo> routeList;

        private Config() {
        }
    }
}

