/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfigData;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfigItem;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class NetPreventDuplicateConfig
extends AConfigData {
    public static final int CONFIG_ITEM_TYPE_HTTP = 1;
    public static final int CONFIG_ITEM_TYPE_PROTO = 2;
    private static final String TAG = "NetPreventDuplicateConfig";
    private static NetPreventDuplicateConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.NET_PREVENTDUPLICATE;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetPreventDuplicateConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        try {
            mData = (NetPreventDuplicateConfigData)JsonParser.parseJsonObject((String)configs, NetPreventDuplicateConfigData.class);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
            } else {
                MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
            }
            if (mData != null) {
                MLog.info((Object)TAG, (String)"http switch:%b, time:%d; proto switch:%b, time:%d", (Object[])new Object[]{NetPreventDuplicateConfig.mData.httpSwtichOn, NetPreventDuplicateConfig.mData.httpCacheEffectiveTime, NetPreventDuplicateConfig.mData.httpSwtichOn, NetPreventDuplicateConfig.mData.protoCacheEffectiveTime});
            }
        }
        catch (Exception e) {
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException(e);
            }
            MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static boolean isStatSwitchOn() {
        if (mData == null) {
            return false;
        }
        return NetPreventDuplicateConfig.mData.statSwitchOn;
    }

    public static boolean isStatRequestStatusSwitchOn() {
        if (mData == null) {
            return false;
        }
        return NetPreventDuplicateConfig.mData.statRequestStatus;
    }

    public static boolean isStatCalculationTimeSwitchOn() {
        if (mData == null) {
            return false;
        }
        return NetPreventDuplicateConfig.mData.statCalculationTime;
    }

    public static boolean isNetPreventDuplicateSwitchOn(int type2) {
        if (mData == null) {
            return false;
        }
        if (type2 == 1) {
            return NetPreventDuplicateConfig.mData.httpSwtichOn;
        }
        if (type2 == 2) {
            return NetPreventDuplicateConfig.mData.protoSwtichOn;
        }
        return false;
    }

    public static int getDefaultCacheEffectiveTime(int type2) {
        if (mData == null) {
            return 0;
        }
        if (type2 == 1) {
            return NetPreventDuplicateConfig.mData.httpCacheEffectiveTime;
        }
        if (type2 == 2) {
            return NetPreventDuplicateConfig.mData.protoCacheEffectiveTime;
        }
        return 0;
    }

    public static NetPreventDuplicateConfigItem getItem(int type2, String uri, String serviceName, String methodName) {
        List<NetPreventDuplicateConfigItem> items = null;
        if (type2 == 1) {
            if (mData != null && NetPreventDuplicateConfig.mData.httpItems != null && NetPreventDuplicateConfig.mData.httpItems.size() > 0) {
                items = NetPreventDuplicateConfig.mData.httpItems;
            }
        } else if (type2 == 2 && mData != null && NetPreventDuplicateConfig.mData.protoItems != null && NetPreventDuplicateConfig.mData.protoItems.size() > 0) {
            items = NetPreventDuplicateConfig.mData.protoItems;
        }
        if (items != null) {
            boolean uriEqualed = false;
            boolean serviceNameEqualed = false;
            boolean methodNameEqualed = false;
            String uriSplit = null;
            for (NetPreventDuplicateConfigItem item : items) {
                boolean bl = uriEqualed = StringUtils.isEmpty((String)uri) || StringUtils.equal((String)item.uri, (String)uri);
                if (!uriEqualed && StringUtils.isNotEmpty((String)item.uri)) {
                    uriEqualed = uri.endsWith(item.uri);
                }
                if (!uriEqualed && StringUtils.isNotEmpty((String)item.uri)) {
                    if (uriSplit == null) {
                        uriSplit = uri.split("\\?", 2)[0];
                    }
                    uriEqualed = uriSplit.endsWith(item.uri);
                }
                serviceNameEqualed = StringUtils.isEmpty((String)serviceName) || StringUtils.equal((String)item.serviceName, (String)serviceName);
                boolean bl2 = methodNameEqualed = StringUtils.isEmpty((String)methodName) || StringUtils.equal((String)item.methodName, (String)methodName);
                if (!uriEqualed || !serviceNameEqualed || !methodNameEqualed) continue;
                return item;
            }
        }
        return null;
    }
}

