/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.MemRecycleConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.ACWindowStack;

public class MemRecycleAndCrashOptConfig
extends AConfigData {
    private static final String TAG = "MemRecycleConfig";
    private static MemRecycleConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.MEM_RECYCLE_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    MemRecycleAndCrashOptConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        try {
            mData = (MemRecycleConfigData)JsonParser.parseJsonObject((String)configs, MemRecycleConfigData.class);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
            } else {
                MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
            }
            if (mData != null) {
                MLog.info((Object)TAG, (String)"windowNotRecycle:%s", (Object[])new Object[]{MemRecycleAndCrashOptConfig.mData.windowNotRecycle != null ? MemRecycleAndCrashOptConfig.mData.windowNotRecycle : ""});
                RuntimeContext.setMonitorRemoveViewSwtich((MemRecycleAndCrashOptConfig.mData.removeViewLog == 1 ? 1 : 0) != 0);
                ACWindowStack.setRemoveViewCrashCatch((MemRecycleAndCrashOptConfig.mData.removeViewCrashCatch == 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException(e);
            }
            MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static boolean isWindowForceNotRecycle(String windowName) {
        if (mData != null && MemRecycleAndCrashOptConfig.mData.windowNotRecycle != null) {
            return MemRecycleAndCrashOptConfig.mData.windowNotRecycle.contains(windowName);
        }
        return false;
    }

    public static boolean isServiceLockOptOff() {
        return mData != null && MemRecycleAndCrashOptConfig.mData.serviceLockOptOff == 1;
    }

    public static boolean isBackgroundPauseAni() {
        return mData == null || MemRecycleAndCrashOptConfig.mData.backgroundPauseAni == 1;
    }

    public static boolean isBackgroundMarkWindowHide() {
        return mData == null || MemRecycleAndCrashOptConfig.mData.backgroundMarkWindowHide == 1;
    }

    public static boolean isBackgroundImUnreadOpt() {
        return mData == null || MemRecycleAndCrashOptConfig.mData.backgroundImUnreadOpt == 1;
    }

    public static MemRecycleConfigData getData() {
        return mData;
    }
}

