/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import androidx.annotation.Keep;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;
import org.json.JSONObject;

public class GrowthConfig
extends AConfigData {
    private static final String TAG = "GrowthConfig";
    @SerializedName(value="web_intercept_data")
    public WebInterceptData mWebInterceptData;
    @SerializedName(value="image_loader_config")
    public ImageLoaderConfig imageLoaderConfig;

    @Override
    public BssCode getBssCode() {
        return BssCode.GROWTH;
    }

    @Override
    public boolean recycleAfterParse() {
        return true;
    }

    @Override
    public void parseConfig(String configs) {
        try {
            if (StringUtils.isEmpty((String)configs)) {
                return;
            }
            MLog.debug((Object)TAG, (String)("parseConfig: " + configs), (Object[])new Object[0]);
            JSONObject jo = JsonParser.obtainJSONObject((String)configs);
            this.parseSetting(jo);
            this.parseOther(configs);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)"parseConfig error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public WebInterceptData getWebInterceptData() {
        return this.mWebInterceptData;
    }

    private void parseSetting(JSONObject jo) {
        this.parseAndSaveForInt(jo, "proc_al\u0192ive_delay_time", "proc_al\u0192ive_delay_time", 2);
        this.parseAndSaveForInt(jo, "net_stat_sampling", "net_stat_sampling", 1000);
        this.parseAndSaveForInt(jo, "image_stat_sampling", "image_stat_sampling", 100);
        this.parseAndSaveForBoolean(jo, "net_quic_enable", "net_quic_enable", true);
        this.parseAndSaveForBoolean(jo, "push_fetch_msg", "push_fetch_msg", true);
        this.parseAndSaveForBoolean(jo, "push_fetch_use_http", "push_fetch_use_http", true);
        this.parseAndSaveForBoolean(jo, "image_quality_switch", "image_quality_switch", false);
        this.parseAndSaveForInt(jo, "cdn_switch_err_times", "cdn_switch_err_times", 5);
        this.parseAndSaveForBoolean(jo, "heic_local_conver_switch", "heic_local_conver_switch", true);
        this.parseAndSaveForInt(jo, "luban_compress_ignoreby_size", "luban_compress_ignoreby_size", 100);
        this.parseAndSaveForInt(jo, "compress_quality", "compress_quality", 60);
        this.parseAndSaveForInt(jo, "ws_ping_interval", "ws_ping_interval", 20);
        this.parseAndSaveForInt(jo, "ws_pong_lost_times", "ws_pong_lost_times", 2);
        this.parseAndSaveForBoolean(jo, "key_https_trust_switch", "key_https_trust_switch", true);
        this.parseAndSaveForInt(jo, "image_max_http_err_times", "image_max_http_err_times", 3);
        this.parseAndSaveForBoolean(jo, "dl_multi_thread_switch", "dl_multi_thread_switch", true);
        this.parseAndSaveForInt(jo, "dl_thread_num_default", "dl_thread_num_default", 3);
        this.parseAndSaveForInt(jo, "dl_thread_num_2g", "dl_thread_num_2g", 1);
        this.parseAndSaveForInt(jo, "dl_thread_num_3g", "dl_thread_num_3g", 2);
        this.parseAndSaveForInt(jo, "dl_thread_num_4g", "dl_thread_num_4g", 3);
        this.parseAndSaveForInt(jo, "dl_thread_num_wifi", "dl_thread_num_wifi", 3);
        this.parseAndSaveForInt(jo, "dl_buf_size", "dl_buf_size", 65536);
        this.parseAndSaveForInt(jo, "dl_sync_buf_size", "dl_sync_buf_size", 131072);
        this.parseAndSaveForBoolean(jo, "video_preload_only_wifi_switch", "video_preload_only_wifi_switch", false);
        this.parseAndSaveForBoolean(jo, "video_dash_play_enable", "video_dash_play_enable", false);
        this.parseAndSaveForBoolean(jo, "video_player_enable_cronet", "video_player_enable_cronet", false);
        this.parseAndSaveForBoolean(jo, "key_push_sdk_ext_report_switch", "key_push_sdk_ext_report_switch", false);
        this.parseAndSaveForBoolean(jo, "key_low_phone_video_h264_switch", "key_low_phone_video_h264_switch", false);
        this.parseAndSaveForString(jo, "key_video_rate_map", "key_video_rate_map");
        this.parseAndSaveForInt(jo, "key_video_dl_increment_time", "key_video_dl_increment_time", 5000);
        this.parseAndSaveForBoolean(jo, "key_video_pre_upload", "key_video_pre_upload", true);
        this.parseAndSaveForBoolean(jo, "enable_upgrade", "enable_upgrade", true);
        this.parseAndSaveForBoolean(jo, "key_fb_login_webview", "key_fb_login_webview", false);
        this.parseAndSaveForBoolean(jo, "flag_xm_net_receiver", "flag_xm_net_receiver", true);
        this.parseAndSaveForBoolean(jo, "key_memory_monitor_switch", "key_memory_monitor_switch", false);
        this.parseAndSaveForInt(jo, "key_memory_monitor_frequency", "key_memory_monitor_frequency", 180);
        this.parseAndSaveForInt(jo, "key_memory_monitor_threshold", "key_memory_monitor_threshold", 85);
        this.parseAndSaveForInt(jo, "grace_error_retry_times", "grace_error_retry_times", 1);
        this.parseAndSaveForBoolean(jo, "grace_enable_retry", "grace_enable_retry", true);
        this.parseAndSaveForBoolean(jo, "grace_enable_tls_1_3", "grace_enable_tls_1_3", false);
        this.parseAndSaveForBoolean(jo, "grace_cronet_timeout_enable", "grace_cronet_timeout_enable", false);
        this.parseAndSaveForInt(jo, "grace_thread_pool_max_thread_low", "grace_thread_pool_max_thread_low", 32);
        this.parseAndSaveForInt(jo, "grace_thread_pool_max_thread", "grace_thread_pool_max_thread", 64);
        this.parseAndSaveForInt(jo, "grace_thread_pool_core_size", "grace_thread_pool_core_size", HardwareUtils.getCpuCoreCount() * 2);
        this.parseAndSaveForBoolean(jo, "key_enable_report_hiido_white", "key_enable_report_hiido_white", true);
        this.parseAndSaveForBoolean(jo, "ws_http_merge", "ws_http_merge", true);
        this.parseAndSaveForBoolean(jo, "game_predownload_switch", "game_predownload_switch", false);
        this.parseAndSaveForBoolean(jo, "key_matrix_enable", "key_matrix_enable", true);
        this.parseAndSaveForBoolean(jo, "key_trace_enable", "key_trace_enable", true);
        this.parseAndSaveForBoolean(jo, "key_fps_enable", "key_fps_enable", false);
        this.parseAndSaveForInt(jo, "key_method_threshold", "key_method_threshold", 2000);
        this.parseAndSaveForInt(jo, "key_block_report_file_size", "key_block_report_file_size", 5120);
        this.parseAndSaveForBoolean(jo, "key_gp_service_dialog_show_enable", "key_gp_service_dialog_show_enable", true);
        this.parseAndSaveForBoolean(jo, "asset_index_enable_switch", "asset_index_enable_switch", false);
        this.parseAndSaveForBoolean(jo, "asset_index_list_cache_switch", "asset_index_list_cache_switch", false);
        this.parseAndSaveForBoolean(jo, "key_okhttp_thread_pool_replace", "key_okhttp_thread_pool_replace", false);
        this.parseAndSaveForBoolean(jo, "reliable_broadcast", "reliable_broadcast", false);
        this.parseAndSaveForString(jo, "key_push_continuous_day_list", "key_push_continuous_day_list");
        this.parseAndSaveForBoolean(jo, "web_cdn_intercept_switch", "web_cdn_intercept_switch", false);
        this.parseAndSaveForBoolean(jo, "key_glide_executor", "key_glide_executor", false);
        this.parseAndSaveForBoolean(jo, "key_pre_connect_enable", "key_pre_connect_enable", true);
        this.parseAndSaveForBoolean(jo, "key_dp_cache_switch", "key_dp_cache_switch", true);
        this.parseAndSaveForLong(jo, "key_dp_cache_expire", "key_dp_cache_expire", 86400);
        this.parseAndSaveForBoolean(jo, "key_dp_web_preload_switch", "key_dp_web_preload_switch", false);
        this.parseAndSaveForLong(jo, "key_push_awake_remain_duration", "key_push_awake_remain_duration", 30000);
        this.parseAndSaveForBoolean(jo, "key_dp_google_play_use", "key_dp_google_play_use", false);
        this.parseAndSaveForString(jo, "push_active_user_shield_id", "push_active_user_shield_id");
        this.parseAndSaveForString(jo, "push_noclick_user_shield_id", "push_noclick_user_shield_id");
        this.parseAndSaveForString(jo, "grace_cronet_timeout", "grace_cronet_timeout");
    }

    private void parseOther(String configString) {
        try {
            GrowthConfig parseConfig2 = (GrowthConfig)JsonParser.parseJsonObject((String)configString, GrowthConfig.class);
            if (parseConfig2 != null) {
                this.mWebInterceptData = parseConfig2.mWebInterceptData;
                this.imageLoaderConfig = parseConfig2.imageLoaderConfig;
                if (this.imageLoaderConfig != null) {
                    SettingFlags.setIntValue((String)"image_heif_min_sdk_ver", (int)this.imageLoaderConfig.minSdkVersion);
                }
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"parseOther error", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private void parseAndSaveForLong(JSONObject jo, String growthKey, String settingFlagKey, int defaultValue) {
        this.parseLongValueToKeysAndValues(jo, growthKey);
        this.saveLongValueToSettingFlags(growthKey, settingFlagKey, defaultValue);
    }

    private void parseAndSaveForInt(JSONObject jo, String growthKey, String settingFlagKey, int defaultValue) {
        this.parseIntValueToKeysAndValues(jo, growthKey);
        this.saveIntValueToSettingFlags(growthKey, settingFlagKey, defaultValue);
    }

    private void parseAndSaveForBoolean(JSONObject jo, String growthKey, String settingFlagKey, boolean defaultValue) {
        this.parseBoolValueToKeysAndValues(jo, growthKey);
        this.saveBoolValueToSettingFlags(growthKey, settingFlagKey, defaultValue);
    }

    private void parseAndSaveForString(JSONObject jo, String growthKey, String settingFlagKey) {
        this.parseStringValueToKeysAndValues(jo, growthKey);
        this.saveStringValueToSettingFlags(growthKey, settingFlagKey);
    }

    private void saveIntValueToSettingFlags(String perfConfigKey, String settingFlagKey, int defaultValue) {
        if (this.containsKey(perfConfigKey)) {
            SettingFlags.setIntValue((String)settingFlagKey, (int)this.getIntValue(perfConfigKey, defaultValue));
        }
    }

    private void saveLongValueToSettingFlags(String perfConfigKey, String settingFlagKey, int defaultValue) {
        if (this.containsKey(perfConfigKey)) {
            SettingFlags.setLongValue((String)settingFlagKey, (long)this.getLongValue(perfConfigKey, defaultValue));
        }
    }

    private void saveBoolValueToSettingFlags(String perfConfigKey, String settingFlagKey, boolean defaultValue) {
        if (this.containsKey(perfConfigKey)) {
            SettingFlags.setBoolean((String)settingFlagKey, (boolean)this.getBoolValue(perfConfigKey, defaultValue));
        }
    }

    private void saveStringValueToSettingFlags(String perfConfigKey, String settingFlagKey) {
        if (this.containsKey(perfConfigKey)) {
            SettingFlags.setStringValue((String)settingFlagKey, (String)this.getStringValue(perfConfigKey));
        }
    }

    @Keep
    public static class ImageLoaderConfig {
        @SerializedName(value="heif")
        public ImageFormatItem heif;
        @SerializedName(value="minSdkVersion")
        public int minSdkVersion = 24;

        public static class ImageFormatItem {
            @SerializedName(value="enable")
            public boolean isEnable = false;
            @SerializedName(value="url_black_list")
            public List<String> blackList;
            @SerializedName(value="support_host")
            public List<String> supportHost;
        }
    }

    public static class WebInterceptData {
        @SerializedName(value="switch_3_42_0")
        public boolean isSwitchOn;
        @SerializedName(value="enable_cache")
        public boolean enableCache;
        @SerializedName(value="black_list")
        public List<String> blackList;
        @SerializedName(value="white_list")
        public List<String> whiteList;
    }
}

