/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.AppKeysDef;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CrashProtectConfigData;
import com.yy.appbase.unifyconfig.config.CrashProtectItem;
import com.yy.appbase.util.FunctionReporter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class CrashProtectConfig
extends AConfigData {
    private static final String TAG = "CrashProtectConfig";
    private CrashProtectConfigData mData;

    @Override
    public BssCode getBssCode() {
        return CrashProtectConfig.getRealBssCode();
    }

    public static BssCode getRealBssCode() {
        if (AppKeysDef.isHago() || AppKeysDef.isOla()) {
            return BssCode.CRASH_PROTECT;
        }
        if (RuntimeContext.isHagoPartySdk()) {
            return BssCode.CRASH_PROTECT_SDK;
        }
        return BssCode.CRASH_PROTECT;
    }

    @Override
    public void parseConfig(final String configs) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    CrashProtectConfig.this.parseConfigInner(configs);
                }
            }, (long)2000L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        try {
            this.mData = (CrashProtectConfigData)JsonParser.parseJsonObject((String)configs, CrashProtectConfigData.class);
            MLog.debug((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
            if (this.mData != null && this.mData.items != null && this.mData.items.size() > 0) {
                FunctionReporter.statFunctionWorked(TAG);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public boolean needCatchByExtInfoContain(boolean uiThread, int excHasHappenTimes, String eString) {
        if (this.mData == null || this.mData.items == null || this.mData.items.size() < 1) {
            return false;
        }
        if (!uiThread && !this.mData.includeNonUITHread) {
            return false;
        }
        String extInfo = eString;
        if (StringUtils.isEmpty((String)extInfo)) {
            return false;
        }
        List<CrashProtectItem> protectItems = this.mData.items;
        boolean matched = false;
        for (CrashProtectItem item : protectItems) {
            if (item == null || !item.isContainInfoValid() || item.getCatchTimes() <= excHasHappenTimes) continue;
            if (StringUtils.isNotEmpty((String)item.crashContainInfo) && extInfo.contains(item.crashContainInfo)) {
                matched = true;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public boolean needCatch(boolean uiThread, StackTraceElement[] elements, int excHasHappenTimes) {
        if (this.mData == null || this.mData.items == null || this.mData.items.size() < 1) {
            return false;
        }
        if (elements == null) {
            return false;
        }
        if (!uiThread && !this.mData.includeNonUITHread) {
            return false;
        }
        boolean matched = false;
        List<CrashProtectItem> protectItems = this.mData.items;
        for (CrashProtectItem item : protectItems) {
            int lineNumInStack;
            if (item == null || item.catchTimes <= excHasHappenTimes) continue;
            if (item.isSpecifyCodeLineValid() && (lineNumInStack = item.lineNumInStack - 1) < elements.length) {
                StackTraceElement specifyElement = elements[lineNumInStack];
                matched = this.matchBySpecifyLine(specifyElement, item);
            }
            if (matched) {
                return true;
            }
            if (!item.isCodeLineValid() || !(matched = this.matchByFixedLine(elements, item))) continue;
            return true;
        }
        return false;
    }

    private boolean matchBySpecifyLine(StackTraceElement specifyElement, CrashProtectItem item) {
        if (specifyElement == null) {
            return false;
        }
        return (StringUtils.equal((String)specifyElement.getClassName(), (String)item.lineSpecify.declaringClass) || StringUtils.equal((String)specifyElement.getFileName(), (String)item.lineSpecify.fileName)) && StringUtils.equal((String)specifyElement.getMethodName(), (String)item.lineSpecify.methodName) && this.equalWithIgnore(specifyElement.getLineNumber(), item.lineSpecify.lineNumber);
    }

    private boolean equalWithIgnore(int element, int config) {
        return StringUtils.equal((Integer)element, (Integer)config) || StringUtils.equal((Integer)config, (Integer)-1);
    }

    private boolean matchByFixedLine(StackTraceElement[] elements, CrashProtectItem item) {
        if (elements.length <= 4) {
            return false;
        }
        StackTraceElement elementOne = elements[0];
        StackTraceElement elementTwo = elements[1];
        StackTraceElement elementThree = elements[2];
        if (elementOne == null || elementTwo == null || elementThree == null) {
            return false;
        }
        return this.match(elementOne, elementTwo, elementThree, item);
    }

    private boolean match(StackTraceElement elementOne, StackTraceElement elementTwo, StackTraceElement elementThree, CrashProtectItem item) {
        StackTraceElement nextMatch = null;
        if ((StringUtils.equal((String)elementOne.getClassName(), (String)item.lineOne.declaringClass) || StringUtils.equal((String)elementOne.getFileName(), (String)item.lineOne.fileName)) && StringUtils.equal((String)elementOne.getMethodName(), (String)item.lineOne.methodName) && elementOne.getLineNumber() == item.lineOne.lineNumber) {
            nextMatch = elementTwo;
        } else if ((StringUtils.equal((String)elementTwo.getClassName(), (String)item.lineOne.declaringClass) || StringUtils.equal((String)elementTwo.getFileName(), (String)item.lineOne.fileName)) && StringUtils.equal((String)elementTwo.getMethodName(), (String)item.lineOne.methodName) && (elementOne.getLineNumber() == item.lineOne.lineNumber || elementTwo.getLineNumber() == item.lineOne.lineNumber)) {
            nextMatch = elementThree;
        }
        if (nextMatch != null) {
            if (item.lineTwo != null && item.lineTwo.isValid()) {
                if ((StringUtils.equal((String)nextMatch.getClassName(), (String)item.lineTwo.declaringClass) || StringUtils.equal((String)nextMatch.getFileName(), (String)item.lineTwo.fileName)) && StringUtils.equal((String)nextMatch.getMethodName(), (String)item.lineTwo.methodName) && nextMatch.getLineNumber() == item.lineTwo.lineNumber) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

