/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.waveview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYView;
import java.util.Iterator;
import java.util.Vector;

public class WaveView
extends YYView {
    private static final int FPS = 16;
    private float mInitialRadius;
    private float mMaxRadius;
    private float mAlphaPct = 1.0f;
    private long mDuration = 2000L;
    private int mSpeed = 500;
    private float mMaxRadiusRate = 1.0f;
    private boolean mMaxRadiusSet;
    private boolean mIsRunning;
    private long mLastCreateTime;
    private Vector<Circle> mCircleList = new Vector();
    private Interpolator mInterpolator = new LinearInterpolator();
    private Paint mPaint = new Paint(1);
    private boolean mLooping = false;
    private Runnable mCreateCircle = new Runnable(){

        @Override
        public void run() {
            if (WaveView.this.mIsRunning) {
                WaveView.this.newCircle();
                if (WaveView.this.mLooping) {
                    WaveView.this.removeCallbacks(WaveView.this.mCreateCircle);
                    WaveView.this.postDelayed(WaveView.this.mCreateCircle, WaveView.this.mSpeed + 10);
                } else {
                    WaveView.this.removeCallbacks(WaveView.this.mCreateCircle);
                    WaveView.this.mIsRunning = false;
                }
            }
        }
    };

    public WaveView(Context context) {
        super(context);
    }

    public WaveView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (!this.mMaxRadiusSet) {
            this.mMaxRadius = (float)Math.min(w, h) * this.mMaxRadiusRate / 2.0f;
        }
    }

    protected void onDraw(Canvas canvas) {
        Iterator<Circle> iterator2 = this.mCircleList.iterator();
        while (iterator2.hasNext()) {
            Circle circle = iterator2.next();
            float radius = circle.getCurrentRadius();
            if (System.currentTimeMillis() - circle.mCreateTime < this.mDuration) {
                this.mPaint.setAlpha(circle.getAlpha());
                canvas.drawCircle((float)(this.getWidth() >> 1), (float)(this.getHeight() >> 1), radius, this.mPaint);
                continue;
            }
            iterator2.remove();
        }
        if (this.mCircleList.size() > 0) {
            this.postInvalidateDelayed(16L);
        }
    }

    public void start() {
        if (RuntimeContext.isInGray()) {
            FeatureLog.i((String)"FTVoice", (String)("WaveView start mIsRunning = " + this.mIsRunning), (Object[])new Object[0]);
        }
        if (!this.mIsRunning) {
            this.mIsRunning = true;
            this.post(this.mCreateCircle);
        }
    }

    public void stop() {
        this.mIsRunning = false;
    }

    public void stopImmediately() {
        this.mIsRunning = false;
        this.mCircleList.clear();
        this.invalidate();
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void setStyle(Paint.Style style2) {
        this.mPaint.setStyle(style2);
    }

    public void setMaxRadiusRate(float maxRadiusRate) {
        this.mMaxRadiusRate = maxRadiusRate;
    }

    public void setAlphaPct(float alphaPct) {
        this.mAlphaPct = alphaPct;
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setInitialRadius(float radius) {
        this.mInitialRadius = radius;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public void setMaxRadius(float maxRadius) {
        this.mMaxRadius = maxRadius;
        this.mMaxRadiusSet = true;
    }

    public void setSpeed(int speed) {
        this.mSpeed = speed;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopImmediately();
    }

    private void newCircle() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastCreateTime < (long)this.mSpeed) {
            return;
        }
        Circle circle = new Circle();
        this.mCircleList.add(circle);
        this.mLastCreateTime = currentTime;
        this.invalidate();
    }

    public void setLooping(boolean isLooping) {
        this.mLooping = isLooping;
    }

    private class Circle {
        private long mCreateTime = System.currentTimeMillis();

        Circle() {
        }

        int getAlpha() {
            float percent = (this.getCurrentRadius() - WaveView.this.mInitialRadius) / (WaveView.this.mMaxRadius - WaveView.this.mInitialRadius);
            return (int)(255.0f * WaveView.this.mAlphaPct - WaveView.this.mInterpolator.getInterpolation(percent) * 255.0f * WaveView.this.mAlphaPct);
        }

        float getCurrentRadius() {
            float percent = (float)(System.currentTimeMillis() - this.mCreateTime) * 1.0f / (float)WaveView.this.mDuration;
            return WaveView.this.mInitialRadius + WaveView.this.mInterpolator.getInterpolation(percent) * (WaveView.this.mMaxRadius - WaveView.this.mInitialRadius);
        }
    }
}

