/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.volume;

import android.view.View;
import android.view.ViewGroup;
import com.yy.appbase.ui.widget.volume.GameVolumeView;
import com.yy.base.taskexecutor.YYTaskExecutor;

public enum VolumeViewManager {
    INSTANCE;

    private GameVolumeView mPKGameVolumeView;
    private Runnable mHideVolumeRunnable;
    private static final int HIDE_VOLUME_VIEW_TIME = 3000;

    public void showVolumeView(ViewGroup mRootView, boolean up, int type2) {
        if (this.mPKGameVolumeView == null) {
            this.mPKGameVolumeView = new GameVolumeView(mRootView.getContext());
            this.mPKGameVolumeView.setClickable(true);
        }
        if (this.mPKGameVolumeView.getParent() != mRootView) {
            if (this.mPKGameVolumeView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mPKGameVolumeView.getParent()).removeView((View)this.mPKGameVolumeView);
            }
            mRootView.addView((View)this.mPKGameVolumeView);
        }
        this.mPKGameVolumeView.setDirection(up);
        this.mPKGameVolumeView.setType(type2);
        if (this.mPKGameVolumeView.getVisibility() != 0) {
            this.mPKGameVolumeView.setVisibility(0);
        }
        this.prepareHideVolumeRunnable();
    }

    private void prepareHideVolumeRunnable() {
        if (this.mHideVolumeRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideVolumeRunnable);
        }
        if (this.mHideVolumeRunnable == null) {
            this.mHideVolumeRunnable = new Runnable(){

                @Override
                public void run() {
                    VolumeViewManager.this.hideVolumeView();
                }
            };
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mHideVolumeRunnable, (long)3000L);
    }

    private void hideVolumeView() {
        if (this.mPKGameVolumeView != null) {
            if (this.mPKGameVolumeView.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mPKGameVolumeView.getParent()).removeView((View)this.mPKGameVolumeView);
            }
            this.mPKGameVolumeView.setVisibility(8);
        }
        if (this.mHideVolumeRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideVolumeRunnable);
        }
        this.mPKGameVolumeView = null;
        this.mHideVolumeRunnable = null;
    }
}

