/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.volume;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.volume.IVolumeCallbacks;
import com.yy.appbase.ui.widget.volume.VolumeUtils;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;

public class GameVolumeView
extends YYFrameLayout
implements IVolumeCallbacks.UpdateVolumeViewCallback {
    private static final String TAG = "PKGameVolumeView";
    public static final int VOLUME_GAME = 0;
    public static final int VOLUME_VOICE = 1;
    public static final int VOLUME_ALL = 2;
    private Context mContext;
    private View mRoot;
    private SeekBar mPlayerVolumeSeekBar;
    private SeekBar mGameVolumeSeekBar;
    private YYLinearLayout mLlGame;
    private YYLinearLayout mLlPlayer;
    private boolean mDirection;
    private IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter();

    public GameVolumeView(@NonNull Context context) {
        this(context, null);
    }

    public GameVolumeView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameVolumeView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mRoot = LayoutInflater.from((Context)context).inflate(R.layout.layout_pk_game_volume, (ViewGroup)this, true);
        this.findViews(this.mRoot);
        this.initSeekBar();
    }

    private void findViews(View root) {
        this.mPlayerVolumeSeekBar = (SeekBar)root.findViewById(R.id.ww_player_volume);
        this.mGameVolumeSeekBar = (SeekBar)root.findViewById(R.id.ww_game_volume);
        this.mLlGame = (YYLinearLayout)root.findViewById(R.id.ll_game);
        this.mLlPlayer = (YYLinearLayout)root.findViewById(R.id.ll_player);
    }

    public void setType(int type2) {
        switch (type2) {
            case 2: {
                this.mLlPlayer.setVisibility(0);
                this.mLlGame.setVisibility(0);
                this.setGameVolume(this.mDirection);
                break;
            }
            case 0: {
                this.mLlPlayer.setVisibility(8);
                this.mLlGame.setVisibility(0);
                this.setGameVolume(this.mDirection);
                break;
            }
            case 1: {
                this.mLlPlayer.setVisibility(0);
                this.mLlGame.setVisibility(8);
                this.setPlayerVolume(this.mDirection);
                break;
            }
        }
    }

    private void initSeekBar() {
        this.mPlayerVolumeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)GameVolumeView.TAG, (String)"initSeekBar play:%d", (Object[])new Object[]{progress});
                }
                VolumeUtils.adjustPlayerVolume(progress, true);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mGameVolumeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)GameVolumeView.TAG, (String)"initSeekBar game:%d", (Object[])new Object[]{progress});
                }
                VolumeUtils.adjustGameVolume(progress);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.updateVolume();
    }

    private void updateVolume() {
        this.updateGameVolumeView();
        this.updatePlayerVolumeView();
    }

    private void updateGameVolumeView() {
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final int gameVolume = VolumeUtils.getGameVolume() * 100 / VolumeUtils.getGameMaxVolume();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (GameVolumeView.this.mGameVolumeSeekBar == null) {
                            return;
                        }
                        GameVolumeView.this.mGameVolumeSeekBar.setProgress(gameVolume);
                    }
                });
            }
        }, 0L);
    }

    private void updatePlayerVolumeView() {
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final int playerVolume = VolumeUtils.getPlayerVolume() * 100 / VolumeUtils.getPlayerMaxVolume();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (GameVolumeView.this.mPlayerVolumeSeekBar == null) {
                            return;
                        }
                        GameVolumeView.this.mPlayerVolumeSeekBar.setProgress(playerVolume);
                    }
                });
            }
        }, 0L);
    }

    public void setGameVolume(boolean up) {
        int currentVolume = this.mGameVolumeSeekBar.getProgress();
        currentVolume = up ? (currentVolume += 10) : (currentVolume -= 10);
        this.mGameVolumeSeekBar.setProgress(currentVolume);
    }

    public void setPlayerVolume(boolean up) {
        int currentVolume = this.mPlayerVolumeSeekBar.getProgress();
        currentVolume = up ? (currentVolume += 10) : (currentVolume -= 10);
        this.mPlayerVolumeSeekBar.setProgress(currentVolume);
    }

    protected void onDetachedFromWindow() {
        int game = this.mGameVolumeSeekBar.getProgress();
        int player = this.mPlayerVolumeSeekBar.getProgress();
        VolumeUtils.saveVolume(game, player);
        super.onDetachedFromWindow();
    }

    @Override
    public void onUpdateVolumeViewCallback() {
        this.updatePlayerVolumeView();
    }

    public void setDirection(boolean direction) {
        this.mDirection = direction;
    }
}

