/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.recycler;

import android.graphics.Rect;
import android.util.SparseArray;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;
import java.util.ArrayList;
import java.util.List;

public class FlowLayoutManager
extends RecyclerView.LayoutManager {
    private static final String TAG = FlowLayoutManager.class.getSimpleName();
    private static final int MAX_LINES = 3;
    final FlowLayoutManager self = this;
    protected int width;
    protected int height;
    private int left;
    private int top;
    private int right;
    private int usedMaxWidth;
    private int verticalScrollOffset = 0;
    private boolean isLimitLines = true;
    protected int totalHeight = 0;
    private Row row = new Row();
    private List<Row> lineRows = new ArrayList<Row>();
    private int currentLines = 1;
    OnHeightChangeListener mOnHeightChangeListener;
    private SparseArray<Rect> allItemFrames = new SparseArray();

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public FlowLayoutManager() {
        this.setAutoMeasureEnabled(true);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        MLog.info((Object)TAG, (String)"onLayoutChildren", (Object[])new Object[0]);
        this.totalHeight = 0;
        int cuLineTop = this.top;
        int cuLineWidth = 0;
        int maxHeightItem = 0;
        this.row = new Row();
        this.lineRows.clear();
        this.allItemFrames.clear();
        this.removeAllViews();
        if (this.getItemCount() == 0) {
            this.detachAndScrapAttachedViews(recycler);
            this.verticalScrollOffset = 0;
            return;
        }
        if (this.getChildCount() == 0 && state.isPreLayout()) {
            return;
        }
        this.detachAndScrapAttachedViews(recycler);
        if (this.getChildCount() == 0) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.left = this.getPaddingLeft();
            this.right = this.getPaddingRight();
            this.top = this.getPaddingTop();
            this.usedMaxWidth = this.width - this.left - this.right;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            Rect frame;
            int itemTop;
            int itemLeft;
            MLog.info((Object)TAG, (String)("index:" + i), (Object[])new Object[0]);
            View childAt = recycler.getViewForPosition(i);
            if (8 == childAt.getVisibility()) continue;
            this.measureChildWithMargins(childAt, 0, 0);
            int childWidth = this.getDecoratedMeasuredWidth(childAt);
            int childHeight = this.getDecoratedMeasuredHeight(childAt);
            int childUseWidth = childWidth;
            int childUseHeight = childHeight;
            if (this.currentLines == 3 && this.mOnHeightChangeListener != null) {
                this.mOnHeightChangeListener.currentChild(i);
            }
            if (cuLineWidth + childUseWidth <= this.usedMaxWidth) {
                itemLeft = this.left + cuLineWidth;
                itemTop = cuLineTop;
                frame = (Rect)this.allItemFrames.get(i);
                if (frame == null) {
                    frame = new Rect();
                }
                frame.set(itemLeft, itemTop, itemLeft + childWidth, itemTop + childHeight);
                this.allItemFrames.put(i, (Object)frame);
                cuLineWidth += childUseWidth;
                maxHeightItem = Math.max(maxHeightItem, childUseHeight);
                this.row.addViews(new Item(childUseHeight, childAt, frame));
                this.row.setCuTop(cuLineTop);
                this.row.setMaxHeight(maxHeightItem);
            } else {
                this.formatAboveRow();
                this.totalHeight += maxHeightItem;
                itemTop = cuLineTop += maxHeightItem;
                itemLeft = this.left;
                frame = (Rect)this.allItemFrames.get(i);
                if (frame == null) {
                    frame = new Rect();
                }
                frame.set(itemLeft, itemTop, itemLeft + childWidth, itemTop + childHeight);
                this.allItemFrames.put(i, (Object)frame);
                cuLineWidth = childUseWidth;
                maxHeightItem = childUseHeight;
                this.row.addViews(new Item(childUseHeight, childAt, frame));
                this.row.setCuTop(cuLineTop);
                this.row.setMaxHeight(maxHeightItem);
                ++this.currentLines;
            }
            if (i != this.getItemCount() - 1) continue;
            this.formatAboveRow();
            this.totalHeight += maxHeightItem;
        }
        this.totalHeight = Math.max(this.totalHeight, this.getVerticalSpace());
        MLog.info((Object)TAG, (String)("onLayoutChildren totalHeight:" + this.totalHeight), (Object[])new Object[0]);
        this.fillLayout(recycler, state);
    }

    private void fillLayout(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.isPreLayout() || this.getItemCount() == 0) {
            return;
        }
        Rect displayFrame = new Rect(this.getPaddingLeft(), this.getPaddingTop() + this.verticalScrollOffset, this.getWidth() - this.getPaddingRight(), this.verticalScrollOffset + (this.getHeight() - this.getPaddingBottom()));
        for (int j = 0; j < this.lineRows.size(); ++j) {
            Row row = this.lineRows.get(j);
            float lineTop = row.cuTop;
            float lineBottom = lineTop + row.maxHeight;
            List<Item> views = row.views;
            for (int i = 0; i < views.size(); ++i) {
                View scrap = views.get((int)i).view;
                this.measureChildWithMargins(scrap, 0, 0);
                this.addView(scrap);
                Rect frame = views.get((int)i).rect;
                this.layoutDecoratedWithMargins(scrap, frame.left, frame.top - this.verticalScrollOffset, frame.right, frame.bottom - this.verticalScrollOffset);
            }
        }
    }

    private void formatAboveRow() {
        List<Item> views = this.row.views;
        for (int i = 0; i < views.size(); ++i) {
            Item item = views.get(i);
            View view = item.view;
            int position = this.getPosition(view);
            if (!((float)((Rect)this.allItemFrames.get((int)position)).top < this.row.cuTop + (this.row.maxHeight - (float)views.get((int)i).useHeight) / 2.0f)) continue;
            Rect frame = (Rect)this.allItemFrames.get(position);
            if (frame == null) {
                frame = new Rect();
            }
            frame.set(((Rect)this.allItemFrames.get((int)position)).left, (int)(this.row.cuTop + (this.row.maxHeight - (float)views.get((int)i).useHeight) / 2.0f), ((Rect)this.allItemFrames.get((int)position)).right, (int)(this.row.cuTop + (this.row.maxHeight - (float)views.get((int)i).useHeight) / 2.0f + (float)this.getDecoratedMeasuredHeight(view)));
            this.allItemFrames.put(position, (Object)frame);
            item.setRect(frame);
            views.set(i, item);
        }
        this.row.views = views;
        this.lineRows.add(this.row);
        this.row = new Row();
    }

    public boolean canScrollVertically() {
        return true;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        MLog.info((Object)"TAG", (String)("totalHeight:" + this.totalHeight), (Object[])new Object[0]);
        int travel = dy;
        if (this.verticalScrollOffset + dy < 0) {
            travel = -this.verticalScrollOffset;
        } else if (this.verticalScrollOffset + dy > this.totalHeight - this.getVerticalSpace()) {
            travel = this.totalHeight - this.getVerticalSpace() - this.verticalScrollOffset;
        }
        this.verticalScrollOffset += travel;
        this.offsetChildrenVertical(-travel);
        this.fillLayout(recycler, state);
        return travel;
    }

    private int getVerticalSpace() {
        return this.self.getHeight() - this.self.getPaddingBottom() - this.self.getPaddingTop();
    }

    public int getHorizontalSpace() {
        return this.self.getWidth() - this.self.getPaddingLeft() - this.self.getPaddingRight();
    }

    public void setOnHeightChangeListener(OnHeightChangeListener onHeightChangeListener) {
        this.mOnHeightChangeListener = onHeightChangeListener;
    }

    static interface OnHeightChangeListener {
        public void currentChild(int var1);
    }

    public class Row {
        float cuTop;
        float maxHeight;
        List<Item> views = new ArrayList<Item>();

        public void setCuTop(float cuTop) {
            this.cuTop = cuTop;
        }

        public void setMaxHeight(float maxHeight) {
            this.maxHeight = maxHeight;
        }

        public void addViews(Item view) {
            this.views.add(view);
        }
    }

    public class Item {
        int useHeight;
        View view;
        Rect rect;

        public void setRect(Rect rect) {
            this.rect = rect;
        }

        public Item(int useHeight, View view, Rect rect) {
            this.useHeight = useHeight;
            this.view = view;
            this.rect = rect;
        }
    }
}

