/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.edit;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.utils.ToastUtils;

public class FixEditTextView
extends YYEditText {
    private OnDelKeyEventListener mDelKeyEventListener;
    private TextPasteCallback mTextPasteCallback;

    public FixEditTextView(Context context) {
        super(context);
    }

    public FixEditTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FixEditTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setTextPasteCallback(TextPasteCallback callback) {
        this.mTextPasteCallback = callback;
    }

    public boolean performLongClick() {
        try {
            return super.performLongClick();
        }
        catch (Exception e) {
            MLog.error((Object)"FixEdit", (String)"Exception on long click, exception:", (Object[])new Object[]{e.toString()});
            return false;
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new CustomInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    public boolean onTextContextMenuItem(int id2) {
        if (id2 == 0x1020022) {
            if (this.mTextPasteCallback != null) {
                this.mTextPasteCallback.onTextPaste();
                return true;
            }
            return super.onTextContextMenuItem(id2);
        }
        return super.onTextContextMenuItem(id2);
    }

    protected void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                super.onDraw(canvas);
            }
            catch (IndexOutOfBoundsException e) {
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)this.getContext(), (String)"FixEditTextView ondraw IndexOutOfBoundsException", (int)1);
                }
                MLog.error((Object)"FixEditTextView", (String)"FixEditTextView ondraw, exception:", (Object[])new Object[]{e.toString()});
            }
        } else {
            super.onDraw(canvas);
        }
    }

    public void setDelKeyEventListener(OnDelKeyEventListener delKeyEventListener) {
        this.mDelKeyEventListener = delKeyEventListener;
    }

    public void removeDelKeyEventListener() {
        this.mDelKeyEventListener = null;
    }

    public static interface OnDelKeyEventListener {
        public void onDeleteClick();
    }

    public static interface TextPasteCallback {
        public void onTextPaste();
    }

    private class CustomInputConnection
    extends InputConnectionWrapper {
        public CustomInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean sendKeyEvent(KeyEvent event) {
            if (event.getAction() == 0 && event.getKeyCode() == 67 && FixEditTextView.this.mDelKeyEventListener != null) {
                FixEditTextView.this.mDelKeyEventListener.onDeleteClick();
            }
            return super.sendKeyEvent(event);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (beforeLength == 1 && afterLength == 0 && FixEditTextView.this.mDelKeyEventListener != null) {
                FixEditTextView.this.mDelKeyEventListener.onDeleteClick();
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }
}

