/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.util.SparseArray;
import android.view.View;

public interface BubbleStyle {
    public void setArrowDirection(ArrowDirection var1);

    public ArrowDirection getArrowDirection();

    public void setArrowHeight(float var1);

    public float getArrowHeight();

    public void setArrowWidth(float var1);

    public float getArrowWidth();

    public void setArrowPosPolicy(ArrowPosPolicy var1);

    public ArrowPosPolicy getArrowPosPolicy();

    public void setArrowPosDelta(float var1);

    public float getArrowPosDelta();

    public void setArrowTo(int var1);

    public void setArrowTo(View var1);

    public View getArrowTo();

    public void setFillColor(int var1);

    public int getFillColor();

    public void setBorderColor(int var1);

    public int getBorderColor();

    public void setBorderWidth(float var1);

    public float getBorderWidth();

    public void setFillPadding(float var1);

    public float getFillPadding();

    public void setCornerRadius(float var1, float var2, float var3, float var4);

    public void setCornerRadius(float var1);

    public float getCornerTopLeftRadius();

    public float getCornerTopRightRadius();

    public float getCornerBottomLeftRadius();

    public float getCornerBottomRightRadius();

    public void setPadding(int var1, int var2, int var3, int var4);

    public int getPaddingLeft();

    public int getPaddingTop();

    public int getPaddingRight();

    public int getPaddingBottom();

    public void requestUpdateBubble();

    public void setCustomArrowXY(float var1, float var2);

    public static enum ArrowPosPolicy {
        TargetCenter(0),
        SelfCenter(1),
        SelfBegin(2),
        SelfEnd(3);

        private static final SparseArray<ArrowPosPolicy> intToTypeDict;
        private int mValue = 0;

        public int getValue() {
            return this.mValue;
        }

        private ArrowPosPolicy(int value) {
            this.mValue = value;
        }

        public static ArrowPosPolicy valueOf(int value) {
            ArrowPosPolicy type2 = (ArrowPosPolicy)((Object)intToTypeDict.get(value));
            if (type2 == null) {
                return TargetCenter;
            }
            return type2;
        }

        static {
            intToTypeDict = new SparseArray();
            for (ArrowPosPolicy type2 : ArrowPosPolicy.values()) {
                intToTypeDict.put(type2.mValue, (Object)type2);
            }
        }
    }

    public static enum ArrowDirection {
        None(-1),
        Auto(0),
        Left(1),
        Up(2),
        Right(3),
        Down(4);

        private static final SparseArray<ArrowDirection> intToTypeDict;
        private int mValue = 0;

        public int getValue() {
            return this.mValue;
        }

        private ArrowDirection(int value) {
            this.mValue = value;
        }

        public static ArrowDirection valueOf(int value) {
            ArrowDirection type2 = (ArrowDirection)((Object)intToTypeDict.get(value));
            if (type2 == null) {
                return Auto;
            }
            return type2;
        }

        public boolean isLeft() {
            return this == Left;
        }

        public boolean isUp() {
            return this == Up;
        }

        public boolean isRight() {
            return this == Right;
        }

        public boolean isDown() {
            return this == Down;
        }

        static {
            intToTypeDict = new SparseArray();
            for (ArrowDirection type2 : ArrowDirection.values()) {
                intToTypeDict.put(type2.mValue, (Object)type2);
            }
        }
    }
}

