/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.auto;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.yy.appbase.ui.widget.auto.AutoAdjustHelper;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;

public class AutoAdjustImageView
extends RecycleImageView {
    private AutoAdjustHelper mHelper = new AutoAdjustHelper();
    private int mCustWidth;
    private int mCustHeight;
    private boolean isAutoAdjust = true;

    public AutoAdjustImageView(Context context) {
        this(context, null);
    }

    public AutoAdjustImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        DrawableRecycler.closeAutoRecycle((View)this);
        this.init(context, attrs);
    }

    public AutoAdjustImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        DrawableRecycler.closeAutoRecycle((View)this);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mHelper.init(context, attrs);
        DrawableRecycler.closeAutoRecycle((View)this);
    }

    public void setAutoAdjust(boolean isAutoAdjust) {
        this.isAutoAdjust = isAutoAdjust;
    }

    public void setCustWidth(int width) {
        this.mCustWidth = width;
    }

    public void setCustHeight(int height) {
        this.mCustHeight = height;
    }

    public void setAdjustType(int type2) {
        this.mHelper.setAdjustType(type2);
    }

    public void setScaleRate(float scale) {
        this.mHelper.setScale(scale);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isAutoAdjust) {
            int custWidth = 0;
            int custHeight = 0;
            if (this.mCustHeight != 0 && this.mCustWidth != 0) {
                custWidth = this.mCustWidth;
                custHeight = this.mCustHeight;
            } else {
                Drawable drawable2 = this.getDrawable();
                if (drawable2 != null) {
                    custWidth = drawable2.getIntrinsicWidth();
                    custHeight = drawable2.getIntrinsicHeight();
                }
            }
            this.mHelper.setRelativeHeight(custHeight);
            this.mHelper.setRelativeWidth(custWidth);
            this.mHelper.onMeasureView(widthMeasureSpec, heightMeasureSpec);
            super.onMeasure(this.mHelper.getWidthSpec(), this.mHelper.getHeightSpec());
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean closeAutoRecycleDrawables() {
        return true;
    }
}

