/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.utils;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;

public class LayoutUtil {
    public static void setStartEndMargin(ViewGroup.MarginLayoutParams param) {
        if (Build.VERSION.SDK_INT >= 17) {
            param.setMarginStart(param.leftMargin);
            param.setMarginEnd(param.rightMargin);
        }
    }

    public static void setMargins(ViewGroup.MarginLayoutParams lp, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            lp.setMarginStart(start);
            lp.setMarginEnd(end);
        } else {
            lp.leftMargin = start;
            lp.rightMargin = end;
        }
        lp.topMargin = top;
        lp.bottomMargin = bottom;
    }

    public static void setPadding(View view, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(start, top, end, bottom);
        } else if (LanguageUtils.isRtl()) {
            view.setPadding(end, top, start, bottom);
        } else {
            view.setPadding(start, top, end, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, @Nullable Drawable start, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else if (LanguageUtils.isLtr()) {
            textView.setCompoundDrawables(start, top, end, bottom);
        } else {
            textView.setCompoundDrawables(end, top, start, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, @DrawableRes int start, @DrawableRes int top, @DrawableRes int end, @DrawableRes int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else {
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds(textView, start != 0 ? ResourceUtils.getDrawable((int)start) : null, top != 0 ? ResourceUtils.getDrawable((int)top) : null, end != 0 ? ResourceUtils.getDrawable((int)end) : null, bottom != 0 ? ResourceUtils.getDrawable((int)bottom) : null);
        }
    }
}

