/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.utils;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.IntEvaluator;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import java.util.Random;

public class AnimatorUtils {
    private static final String TAG = "AnimatorUtils";
    private static final int DEFAULT_BOUND = 100;
    private static int MIN_ANIM_DELAY = 10;
    private static Random mRandom;
    public static final int DEFAULT_UP_ANIMAITON_TIME = 100;

    public static boolean canAnimation() {
        return !RuntimeContext.isPhoneSuperLow();
    }

    public static AnimatorSet dropDownAnimator(final View myView) {
        AnimatorSet set = new AnimatorSet();
        float height = 80.0f;
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"y", (float[])new float[]{-height, 0.0f})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                myView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }

    public static AnimatorSet dropUpAnimator(final View myView) {
        AnimatorSet set = new AnimatorSet();
        float height = 80.0f;
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"y", (float[])new float[]{0.0f, -height})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                myView.setVisibility(8);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }

    public static AnimatorSet pushInFromLeftAnimator(final View myView) {
        AnimatorSet set = new AnimatorSet();
        if (myView.getContext() == null) {
            return set;
        }
        int width = ResolutionUtils.getScreenWidth((Context)myView.getContext());
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"translationX", (float[])new float[]{width, 0.0f})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                myView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        set.start();
        return set;
    }

    public static AnimatorSet popOutFromRightAnimator(final View myView) {
        AnimatorSet set = new AnimatorSet();
        if (myView.getContext() == null) {
            return set;
        }
        int width = ResolutionUtils.getScreenWidth((Context)myView.getContext());
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"translationX", (float[])new float[]{0.0f, width})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                myView.setVisibility(8);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        set.start();
        return set;
    }

    public static ObjectAnimator rotateRepeatAnimator(View myView) {
        LinearInterpolator interpolator = new LinearInterpolator();
        ObjectAnimator rotateAnim = ObjectAnimator.ofFloat((Object)myView, (String)"rotation", (float[])new float[]{0.0f, 359.0f});
        rotateAnim.setDuration(5000L);
        rotateAnim.setRepeatCount(-1);
        rotateAnim.setRepeatMode(1);
        rotateAnim.setInterpolator((TimeInterpolator)interpolator);
        return rotateAnim;
    }

    public static AnimatorSet scaleIn(final View myView) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)myView, (String)"scaleX", (float[])new float[]{0.1f, 1.0f}), ObjectAnimator.ofFloat((Object)myView, (String)"scaleY", (float[])new float[]{0.1f, 1.0f})});
        set.setDuration(400L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                myView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }

    public static AnimatorSet alphaShow(final View myView) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"alpha", (float[])new float[]{0.0f, 1.0f})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                myView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }

    public static AnimatorSet alphaHide(final View myView) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)myView, (String)"alpha", (float[])new float[]{1.0f, 0.0f})});
        set.setDuration(300L);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                myView.setVisibility(8);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }

    public static ObjectAnimator alphaRepeatAnimator(Object myView) {
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)0.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)0.1f, (float)1.0f);
        Keyframe kf2 = Keyframe.ofFloat((float)0.5f, (float)1.0f);
        Keyframe kf3 = Keyframe.ofFloat((float)0.6f, (float)0.0f);
        Keyframe kf4 = Keyframe.ofFloat((float)1.0f, (float)0.0f);
        PropertyValuesHolder pvhRotation = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1, kf2, kf3, kf4});
        ObjectAnimator rotationAnim = ObjectAnimator.ofPropertyValuesHolder((Object)myView, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhRotation});
        rotationAnim.setDuration(6000L);
        rotationAnim.setRepeatCount(-1);
        rotationAnim.setRepeatMode(1);
        return rotationAnim;
    }

    public static ObjectAnimator alphaAnimator(Object myView) {
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)0.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)0.06f, (float)1.0f);
        Keyframe kf2 = Keyframe.ofFloat((float)0.94f, (float)1.0f);
        Keyframe kf3 = Keyframe.ofFloat((float)1.0f, (float)0.0f);
        PropertyValuesHolder pvhRotation = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1, kf2, kf3});
        ObjectAnimator rotationAnim = ObjectAnimator.ofPropertyValuesHolder((Object)myView, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhRotation});
        rotationAnim.setDuration(5600L);
        return rotationAnim;
    }

    public static void animatorStart(ImageView view) {
        if (view.getDrawable() instanceof AnimationDrawable) {
            ((AnimationDrawable)view.getDrawable()).start();
        }
    }

    public static void animatorStop(ImageView view) {
        if (view.getDrawable() instanceof AnimationDrawable) {
            ((AnimationDrawable)view.getDrawable()).stop();
        }
    }

    public static AnimatorSet slideInDownAnimator(View target) {
        AnimatorSet set = new AnimatorSet();
        ViewGroup parent = (ViewGroup)target.getParent();
        set.playTogether(new Animator[]{AnimatorUtils.buildHeightPropAnim(target, 0, parent.getHeight())});
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        set.setDuration(200L);
        return set;
    }

    public static AnimatorSet slideOutUpAnimator(View target) {
        AnimatorSet set = new AnimatorSet();
        ViewGroup parent = (ViewGroup)target.getParent();
        int distance = parent.getHeight() - target.getTop();
        set.playTogether(new Animator[]{AnimatorUtils.buildHeightPropAnim(target, distance, 0)});
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        set.setDuration(200L);
        return set;
    }

    private static ValueAnimator buildHeightPropAnim(final View target, final int start, final int end) {
        ValueAnimator valueAnimator = null;
        try {
            valueAnimator = ValueAnimator.ofInt((int[])new int[]{1, 100});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                private IntEvaluator mEvaluator = new IntEvaluator();

                public void onAnimationUpdate(ValueAnimator animator) {
                    int currentValue = (Integer)animator.getAnimatedValue();
                    float fraction = (float)currentValue / 100.0f;
                    target.getLayoutParams().height = this.mEvaluator.evaluate(fraction, Integer.valueOf(start), Integer.valueOf(end));
                    target.requestLayout();
                }
            });
        }
        catch (Throwable throwable) {
            MLog.error((Object)"buildHeightPropAnim", (String)"[buildHeightPropAnim] error!", (Object[])new Object[0]);
        }
        return valueAnimator;
    }

    public static int randomDelay(int bound) {
        return AnimatorUtils.randomDelay(MIN_ANIM_DELAY, bound);
    }

    public static int randomDelay(int from, int bound) {
        if (mRandom == null) {
            mRandom = new Random();
        }
        int result = from + mRandom.nextInt(bound > 0 ? bound : 100);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"randomDelay %d", (Object[])new Object[]{result});
        }
        return result;
    }

    @SuppressLint(value={"ObjectAnimatorBinding"})
    public static AnimatorSet scale(Object view, float ... args) {
        AnimatorSet aniSet = new AnimatorSet();
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])args);
        animatorX.setRepeatCount(-1);
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])args);
        animatorY.setRepeatCount(-1);
        aniSet.play((Animator)animatorX).with((Animator)animatorY);
        return aniSet;
    }
}

